/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.api.structure;

import git.jbredwards.nether_api.api.structure.ISpawningStructure;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;

public abstract class MapGenSpawningStructure
extends MapGenStructure
implements ISpawningStructure {
    @Nonnull
    public final Map<EnumCreatureType, List<Biome.SpawnListEntry>> spawnableCreatures = new EnumMap<EnumCreatureType, List<Biome.SpawnListEntry>>(EnumCreatureType.class);

    public void addSpawnableCreature(@Nonnull EnumCreatureType type, Biome.SpawnListEntry ... entries) {
        this.spawnableCreatures.computeIfAbsent(type, typeIn -> new LinkedList()).addAll(Arrays.asList(entries));
    }

    @Override
    @Nonnull
    public List<Biome.SpawnListEntry> getPossibleCreatures(@Nonnull EnumCreatureType type, @Nonnull World world, @Nonnull BlockPos pos) {
        List creatures;
        if (!this.spawnableCreatures.isEmpty() && !(creatures = this.spawnableCreatures.computeIfAbsent(type, typeIn -> new LinkedList())).isEmpty() && (this.func_175795_b(pos) || this.func_175796_a(world, pos)) && this.isBlockBelowValidForSpawns(type, world, pos.func_177977_b())) {
            return creatures;
        }
        return Collections.emptyList();
    }

    protected abstract boolean isBlockBelowValidForSpawns(@Nonnull EnumCreatureType var1, @Nonnull World var2, @Nonnull BlockPos var3);
}

