/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.api.util;

import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.common.compat.netherex.NetherExHandler;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public final class NetherGenerationUtils {
    public static void buildSurfaceAndSoulSandGravel(@Nonnull World world, @Nonnull Random rand, @Nonnull ChunkPrimer primer, int x, int z, double[] soulSandNoise, double[] gravelNoise, double[] depthBuffer, @Nonnull IBlockState stateToFill, @Nonnull IBlockState topBlockIn, @Nonnull IBlockState fillerBlockIn, @Nonnull IBlockState liquidBlockIn) {
        boolean soulSand = (!NetherAPI.isNetherExLoaded || NetherExHandler.doesSoulSandGenerate()) && soulSandNoise[x << 4 | z] + rand.nextDouble() * 0.2 > 0.0;
        boolean gravel = (!NetherAPI.isNetherExLoaded || NetherExHandler.doesGravelGenerate()) && gravelNoise[x << 4 | z] + rand.nextDouble() * 0.2 > 0.0;
        int depth = (int)(depthBuffer[x << 4 | z] / 3.0 + 3.0 + rand.nextDouble() * 0.25);
        int depthRemaining = -1;
        int seaLevel = world.func_181545_F() + 1;
        IBlockState topBlock = topBlockIn;
        IBlockState fillerBlock = fillerBlockIn;
        IBlockState prevCheckState = primer.func_177856_a(x, 128, z);
        for (int y = 127; y >= 0; --y) {
            IBlockState checkState = primer.func_177856_a(x, y, z);
            if (checkState.func_185904_a() != Material.field_151579_a) {
                if (checkState == stateToFill) {
                    if (depthRemaining == -1) {
                        if (depth <= 0) {
                            fillerBlock = fillerBlockIn;
                        } else if (y >= seaLevel - 4 && y <= seaLevel + 1) {
                            topBlock = topBlockIn;
                            fillerBlock = fillerBlockIn;
                            if (gravel) {
                                topBlock = Blocks.field_150351_n.func_176223_P();
                            }
                            if (soulSand) {
                                topBlock = Blocks.field_150425_aM.func_176223_P();
                                fillerBlock = Blocks.field_150425_aM.func_176223_P();
                            }
                        }
                        if (y < seaLevel && topBlock.func_185904_a() == Material.field_151579_a) {
                            topBlock = liquidBlockIn;
                        }
                        depthRemaining = depth;
                        if (prevCheckState.func_185904_a() == Material.field_151579_a) {
                            primer.func_177855_a(x, y, z, topBlock);
                            prevCheckState = topBlock;
                            continue;
                        }
                        primer.func_177855_a(x, y, z, fillerBlock);
                        prevCheckState = fillerBlock;
                        continue;
                    }
                    if (depthRemaining > 0) {
                        --depthRemaining;
                        primer.func_177855_a(x, y, z, fillerBlock);
                        prevCheckState = fillerBlock;
                        continue;
                    }
                    prevCheckState = checkState;
                    continue;
                }
                prevCheckState = checkState;
                continue;
            }
            depthRemaining = -1;
            prevCheckState = checkState;
        }
    }
}

