/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.modded;

import git.jbredwards.nether_api.mod.common.compat.betternether.BiomeBetterNether;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import paulevs.betternether.biomes.BiomeRegister;
import paulevs.betternether.biomes.NetherBiome;

public final class TransformerBetterNetherGenerator
implements IClassTransformer,
Opcodes {
    public static boolean isEnabled = true;

    static void legacyTransformer(@Nonnull ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("generate")) continue;
            int biomeIndex = -1;
            int wzIndex = -1;
            for (LocalVariableNode var : method.localVariables) {
                if (var.name.equals("wz")) {
                    wzIndex = var.index;
                    continue;
                }
                if (!var.name.equals("biome")) continue;
                biomeIndex = var.index;
            }
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("makeBiomeArray")) {
                    if (((MethodInsnNode)insn).desc.startsWith("(L")) {
                        method.instructions.remove(insn.getPrevious());
                    }
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn);
                    continue;
                }
                if (insn.getOpcode() == 54 && ((VarInsnNode)insn).var == wzIndex) {
                    InsnList list = new InsnList();
                    list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    list.add((AbstractInsnNode)new VarInsnNode(21, wzIndex - 2));
                    list.add((AbstractInsnNode)new VarInsnNode(21, wzIndex));
                    list.add((AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/nether_api/mod/asm/transformers/modded/TransformerBetterNetherGenerator$Hooks", "getNetherBiome", "(Lnet/minecraft/world/World;II)Lpaulevs/betternether/biomes/NetherBiome;", false));
                    list.add((AbstractInsnNode)new VarInsnNode(58, biomeIndex));
                    method.instructions.insert(insn, list);
                    continue;
                }
                if (insn.getOpcode() != 184 || !((MethodInsnNode)insn).name.equals("getBiomeLocal")) continue;
                if (((MethodInsnNode)insn).desc.contains("World")) {
                    method.instructions.remove(insn.getPrevious());
                }
                method.instructions.remove(insn.getPrevious());
                method.instructions.remove(insn.getPrevious());
                method.instructions.remove(insn.getPrevious());
                method.instructions.remove(insn.getPrevious());
                method.instructions.remove(insn.getNext());
                method.instructions.remove(insn);
                return;
            }
        }
    }

    static void continuationTransformer(@Nonnull ClassNode classNode) {
        for (MethodNode method : classNode.methods) {
            if (!method.name.equals("generate")) continue;
            for (AbstractInsnNode insn : method.instructions.toArray()) {
                if (insn.getOpcode() == 184 && ((MethodInsnNode)insn).name.equals("makeBiomeArray")) {
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn.getPrevious());
                    method.instructions.remove(insn);
                    continue;
                }
                if (insn.getOpcode() != 184 || !((MethodInsnNode)insn).name.equals("getBiomeFromCache")) continue;
                method.instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 10));
                method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/nether_api/mod/asm/transformers/modded/TransformerBetterNetherGenerator$Hooks", "getNetherBiome", "(II[[Lpaulevs/betternether/biomes/NetherBiome;Lnet/minecraft/world/World;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;)Lpaulevs/betternether/biomes/NetherBiome;", false));
                method.instructions.remove(insn);
                return;
            }
        }
    }

    @Nonnull
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (isEnabled && transformedName.equals("paulevs.betternether.world.BNWorldGenerator")) {
            ClassNode classNode = new ClassNode();
            new ClassReader(basicClass).accept((ClassVisitor)classNode, 4);
            boolean useLegacyTransformer = false;
            for (MethodNode method : classNode.methods) {
                if (!method.name.equals("smoothChunk")) continue;
                useLegacyTransformer = true;
                break;
            }
            if (useLegacyTransformer) {
                TransformerBetterNetherGenerator.legacyTransformer(classNode);
            } else {
                TransformerBetterNetherGenerator.continuationTransformer(classNode);
            }
            ClassWriter writer = new ClassWriter(3);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static final class Hooks {
        @Nonnull
        public static NetherBiome getNetherBiome(@Nonnull World world, int wx, int wz) {
            Biome biome = world.func_180494_b(new BlockPos(wx, 0, wz));
            return biome instanceof BiomeBetterNether ? ((BiomeBetterNether)biome).netherBiome : BiomeRegister.BIOME_EMPTY_NETHER;
        }

        @Nonnull
        public static NetherBiome getNetherBiome(int x, int z, @Nonnull NetherBiome[][] cache, @Nonnull World world, @Nonnull Random rand, @Nonnull BlockPos pos) {
            return cache[x][z] == null ? (cache[x][z] = Hooks.getNetherBiome(world, pos.func_177958_n(), pos.func_177952_p())) : cache[x][z];
        }
    }
}

