/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.asm.transformers.vanilla;

import git.jbredwards.nether_api.mod.common.registry.NetherAPIRegistry;
import java.util.Arrays;
import java.util.LinkedList;
import javax.annotation.Nonnull;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class TransformerCommandLocate
implements IClassTransformer,
Opcodes {
    @Nonnull
    public byte[] transform(@Nonnull String name, @Nonnull String transformedName, @Nonnull byte[] basicClass) {
        if (transformedName.equals("net.minecraft.command.CommandLocate")) {
            ClassNode classNode = new ClassNode();
            new ClassReader(basicClass).accept((ClassVisitor)classNode, 0);
            block0: for (MethodNode method : classNode.methods) {
                if (!method.name.equals(FMLLaunchHandler.isDeobfuscatedEnvironment() ? "getTabCompletions" : "func_184883_a")) continue;
                for (AbstractInsnNode insn : method.instructions.toArray()) {
                    if (insn.getOpcode() != 184 || !((MethodInsnNode)insn).name.equals(FMLLaunchHandler.isDeobfuscatedEnvironment() ? "getListOfStringsMatchingLastWord" : "func_71530_a")) continue;
                    method.instructions.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, "git/jbredwards/nether_api/mod/asm/transformers/vanilla/TransformerCommandLocate$Hooks", "getStructures", "([Ljava/lang/String;)[Ljava/lang/String;", false));
                    break block0;
                }
            }
            ClassWriter writer = new ClassWriter(0);
            classNode.accept((ClassVisitor)writer);
            return writer.toByteArray();
        }
        return basicClass;
    }

    public static final class Hooks {
        @Nonnull
        public static String[] getStructures(@Nonnull String[] vanillaStructures) {
            LinkedList<String> structures = new LinkedList<String>(Arrays.asList(vanillaStructures));
            NetherAPIRegistry.NETHER.getStructureHandlers().stream().map(MapGenStructure::func_143025_a).forEach(structures::add);
            NetherAPIRegistry.THE_END.getStructureHandlers().stream().map(MapGenStructure::func_143025_a).forEach(structures::add);
            return structures.toArray(new String[0]);
        }
    }
}

