/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.client.audio;

import git.jbredwards.nether_api.api.audio.IDarkSoundAmbience;
import git.jbredwards.nether_api.api.audio.ISoundAmbience;
import git.jbredwards.nether_api.api.audio.impl.DarkSoundAmbience;
import git.jbredwards.nether_api.api.biome.IAmbienceBiome;
import git.jbredwards.nether_api.api.world.IAmbienceWorldProvider;
import git.jbredwards.nether_api.mod.client.audio.FadingSound;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.MovingSound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="nether_api", value={Side.CLIENT})
final class BiomeAmbienceHandler {
    @Nonnull
    static final Map<Biome, FadingSound> activeBiomeAmbientSounds = new HashMap<Biome, FadingSound>();
    @Nonnull
    static final Minecraft mc = Minecraft.func_71410_x();
    @Nullable
    static Biome currentBiome;
    static float caveAmbienceChance;

    BiomeAmbienceHandler() {
    }

    @SubscribeEvent
    static void onPlayerTick(@Nonnull TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (BiomeAmbienceHandler.mc.field_71439_g != null && BiomeAmbienceHandler.mc.field_71441_e != null) {
                IDarkSoundAmbience caveSound;
                ISoundAmbience ambientSound;
                Biome biome = BiomeAmbienceHandler.mc.field_71441_e.func_180494_b(new BlockPos(ActiveRenderInfo.func_178806_a((Entity)BiomeAmbienceHandler.mc.field_71439_g, (double)mc.func_184121_ak())));
                activeBiomeAmbientSounds.values().removeIf(MovingSound::func_147667_k);
                if (biome != currentBiome) {
                    currentBiome = biome;
                    activeBiomeAmbientSounds.values().forEach(FadingSound::fadeOut);
                    ambientSound = IAmbienceWorldProvider.getAmbienceOrFallback(BiomeAmbienceHandler.mc.field_71441_e.field_73011_w, biome, IAmbienceWorldProvider::getAmbientSound, IAmbienceBiome::getAmbientSound, null);
                    if (ambientSound != null) {
                        activeBiomeAmbientSounds.compute(biome, (arg_0, arg_1) -> BiomeAmbienceHandler.lambda$onPlayerTick$0((SoundEvent)ambientSound, arg_0, arg_1));
                    }
                }
                if ((ambientSound = (ISoundAmbience)IAmbienceWorldProvider.getAmbienceOrFallback(BiomeAmbienceHandler.mc.field_71441_e.field_73011_w, biome, IAmbienceWorldProvider::getRandomAmbientSound, IAmbienceBiome::getRandomAmbientSound, null)) != null && BiomeAmbienceHandler.mc.field_71439_g.func_70681_au().nextDouble() < ambientSound.getChancePerTick()) {
                    PositionedSoundRecord sound = new PositionedSoundRecord(ambientSound.getSoundEvent().func_187503_a(), SoundCategory.AMBIENT, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f);
                    mc.func_147118_V().func_147682_a((ISound)sound);
                }
                if ((caveSound = (IDarkSoundAmbience)IAmbienceWorldProvider.getAmbienceOrFallback(BiomeAmbienceHandler.mc.field_71441_e.field_73011_w, biome, IAmbienceWorldProvider::getDarkAmbienceSound, IAmbienceBiome::getDarkAmbienceSound, DarkSoundAmbience.DEFAULT_CAVE)) != null) {
                    double searchZ;
                    double searchY;
                    int searchDiameter = caveSound.getLightSearchRadius() << 2;
                    double searchX = BiomeAmbienceHandler.mc.field_71439_g.field_70165_t + (double)BiomeAmbienceHandler.mc.field_71439_g.func_70681_au().nextInt(searchDiameter) - (double)caveSound.getLightSearchRadius();
                    BlockPos searchPos = new BlockPos(searchX, searchY = BiomeAmbienceHandler.mc.field_71439_g.field_70163_u + (double)BiomeAmbienceHandler.mc.field_71439_g.func_70047_e() + (double)BiomeAmbienceHandler.mc.field_71439_g.func_70681_au().nextInt(searchDiameter) - (double)caveSound.getLightSearchRadius(), searchZ = BiomeAmbienceHandler.mc.field_71439_g.field_70161_v + (double)BiomeAmbienceHandler.mc.field_71439_g.func_70681_au().nextInt(searchDiameter) - (double)caveSound.getLightSearchRadius());
                    int skyLight = BiomeAmbienceHandler.mc.field_71441_e.func_175642_b(EnumSkyBlock.SKY, searchPos);
                    if ((caveAmbienceChance = (float)((double)caveAmbienceChance - (skyLight > 0 ? (double)skyLight * 0.001 / 15.0 : (double)(BiomeAmbienceHandler.mc.field_71441_e.func_175642_b(EnumSkyBlock.BLOCK, searchPos) - 1) * caveSound.getChancePerTick()))) < 1.0f) {
                        caveAmbienceChance = Math.max(caveAmbienceChance, 0.0f);
                    } else {
                        double offsetX = searchX - BiomeAmbienceHandler.mc.field_71439_g.field_70165_t;
                        double offsetY = searchY - BiomeAmbienceHandler.mc.field_71439_g.field_70163_u - (double)BiomeAmbienceHandler.mc.field_71439_g.func_70047_e();
                        double offsetZ = searchZ - BiomeAmbienceHandler.mc.field_71439_g.field_70161_v;
                        double offset = Math.sqrt(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ);
                        double soundOffset = offset * (offset + caveSound.getSoundOffset());
                        float x = (float)(BiomeAmbienceHandler.mc.field_71439_g.field_70165_t + offsetX / soundOffset);
                        float y = (float)(BiomeAmbienceHandler.mc.field_71439_g.field_70163_u + (double)BiomeAmbienceHandler.mc.field_71439_g.func_70047_e() + offsetY / soundOffset);
                        float z = (float)(BiomeAmbienceHandler.mc.field_71439_g.field_70161_v + offsetZ / soundOffset);
                        PositionedSoundRecord sound = new PositionedSoundRecord(caveSound.getSoundEvent().func_187503_a(), SoundCategory.AMBIENT, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, x, y, z);
                        mc.func_147118_V().func_147682_a((ISound)sound);
                        caveAmbienceChance = 0.0f;
                    }
                }
            } else {
                activeBiomeAmbientSounds.clear();
                caveAmbienceChance = 0.0f;
                currentBiome = null;
            }
        }
    }

    private static /* synthetic */ FadingSound lambda$onPlayerTick$0(SoundEvent ambientSound, Biome biomeIn, FadingSound sound) {
        if (sound == null) {
            sound = new FadingSound(ambientSound, SoundCategory.AMBIENT);
            mc.func_147118_V().func_147682_a((ISound)sound);
        }
        sound.fadeIn();
        return sound;
    }
}

