/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.betternether;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.mod.common.compat.betternether.BiomeBetterNether;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.ObjIntConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.init.Biomes;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import paulevs.betternether.biomes.BiomeRegister;
import paulevs.betternether.biomes.NetherBiome;
import paulevs.betternether.config.ConfigLoader;
import paulevs.betternether.entities.EntityFirefly;

public final class BetterNetherHandler {
    @Nonnull
    static final List<BiomeBetterNether> BIOMES = new LinkedList<BiomeBetterNether>();
    @Nonnull
    static final Map<NetherBiome, BiomeBetterNether> BIOME_LOOKUP = new HashMap<NetherBiome, BiomeBetterNether>();
    @Nullable
    static Field legacyEnabledBiomes;

    public static void registerBiomes(@Nonnull INetherAPIRegistry registry) {
        for (BiomeBetterNether biome : BIOMES) {
            if (biome.netherBiome == BiomeRegister.BIOME_EMPTY_NETHER) continue;
            if (biome.netherBiome == BiomeRegister.BIOME_MUSHROOM_FOREST_EDGE) break;
            registry.registerBiome((Biome)biome, BetterNetherHandler.getWeight(biome));
        }
    }

    @Nonnull
    public static BiomeBetterNether getBiomeFromLookup(@Nonnull NetherBiome netherBiome) {
        BiomeBetterNether biome = BIOME_LOOKUP.get(netherBiome);
        if (biome != null) {
            return biome;
        }
        throw new IllegalStateException("No Biome found for BetterNether: {" + netherBiome.getName() + '}');
    }

    public static int getWeight(@Nonnull BiomeBetterNether biome) {
        if (biome.cachedWeight == -1) {
            if (biome.netherBiome instanceof WeightedRandom.Item) {
                biome.cachedWeight = ConfigLoader.mustInitBiome((NetherBiome)biome.netherBiome) ? biome.netherBiome.field_76292_a : 0;
            } else {
                if (legacyEnabledBiomes == null) {
                    legacyEnabledBiomes = ObfuscationReflectionHelper.findField(ConfigLoader.class, (String)"registerBiomes");
                }
                try {
                    biome.cachedWeight = ((boolean[])legacyEnabledBiomes.get(null))[biome.netherBiomeId] ? 1 : 0;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return biome.cachedWeight;
    }

    @SubscribeEvent
    static void registerBiomes(@Nonnull RegistryEvent.Register<Biome> event) {
        ObjIntConsumer<NetherBiome> registerAction = (netherBiome, netherBiomeId) -> {
            BiomeBetterNether biome = new BiomeBetterNether((NetherBiome)netherBiome, netherBiomeId);
            event.getRegistry().register((IForgeRegistryEntry)biome);
            BIOMES.add(biome);
            BIOME_LOOKUP.put((NetherBiome)netherBiome, biome);
            BiomeDictionary.addTypes((Biome)biome, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.HOT, BiomeDictionary.Type.DRY});
        };
        registerAction.accept(BiomeRegister.BIOME_EMPTY_NETHER, 0);
        registerAction.accept(BiomeRegister.BIOME_GRAVEL_DESERT, 1);
        registerAction.accept(BiomeRegister.BIOME_NETHER_JUNGLE, 2);
        registerAction.accept(BiomeRegister.BIOME_WART_FOREST, 3);
        registerAction.accept(BiomeRegister.BIOME_GRASSLANDS, 4);
        registerAction.accept(BiomeRegister.BIOME_MUSHROOM_FOREST, 5);
        registerAction.accept(BiomeRegister.BIOME_MUSHROOM_FOREST_EDGE, 6);
        registerAction.accept(BiomeRegister.BIOME_WART_FOREST_EDGE, 7);
        registerAction.accept(BiomeRegister.BIOME_BONE_REEF, 8);
        registerAction.accept(BiomeRegister.BIOME_POOR_GRASSLANDS, 9);
    }

    public static void removeOrFixEntitySpawnBiomes() {
        Biomes.field_76778_j.func_76747_a(EnumCreatureType.AMBIENT).removeIf(entry -> entry.field_76300_b == EntityFirefly.class);
        EntityRegistry.addSpawn(EntityFirefly.class, (int)100, (int)5, (int)10, (EnumCreatureType)EnumCreatureType.AMBIENT, (Biome[])new Biome[]{BetterNetherHandler.getBiomeFromLookup(BiomeRegister.BIOME_GRASSLANDS), BetterNetherHandler.getBiomeFromLookup(BiomeRegister.BIOME_NETHER_JUNGLE)});
        BetterNetherHandler.getBiomeFromLookup(BiomeRegister.BIOME_GRAVEL_DESERT).func_76747_a(EnumCreatureType.MONSTER).removeIf(entry -> EntityGhast.class.isAssignableFrom(entry.field_76300_b));
    }
}

