/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.netherex;

import com.google.common.base.Predicate;
import git.jbredwards.nether_api.api.biome.INetherBiome;
import git.jbredwards.nether_api.api.biome.INetherBiomeProvider;
import git.jbredwards.nether_api.api.block.INetherCarvable;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import logictechcorp.libraryex.IModData;
import logictechcorp.libraryex.event.LibExEventFactory;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.world.biome.BiomeNetherEx;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public abstract class AbstractNetherExBiome
extends BiomeNetherEx
implements INetherBiome,
INetherBiomeProvider,
INetherCarvable {
    public AbstractNetherExBiome(@Nonnull IModData data, @Nonnull Biome.BiomeProperties properties, @Nonnull String name) {
        super(data, properties, name);
    }

    @Override
    public boolean canNetherCarveThrough(@Nonnull IBlockState state, @Nonnull ChunkPrimer primer, int x, int y, int z) {
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData((Biome)this);
        return state == biomeData.getBiomeBlock(BiomeData.BlockType.SURFACE_BLOCK) || state == biomeData.getBiomeBlock(BiomeData.BlockType.SUBSURFACE_BLOCK);
    }

    @Override
    @Nonnull
    public List<BiomeManager.BiomeEntry> getSubBiomes() {
        return NetherEx.BIOME_DATA_MANAGER.getBiomeData((Biome)this).getSubBiomes().stream().filter(BiomeData::isEnabled).map(data -> new BiomeManager.BiomeEntry(data.getBiome(), data.getGenerationWeight())).collect(Collectors.toCollection(LinkedList::new));
    }

    @Override
    public void buildSurface(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ, @Nonnull ChunkPrimer primer, int x, int z, double[] soulSandNoise, double[] gravelNoise, double[] depthBuffer, double terrainNoise) {
        int prevSeaLevel = chunkGenerator.getWorld().func_181545_F();
        chunkGenerator.getWorld().func_181544_b(31);
        NetherEx.BIOME_DATA_MANAGER.getBiomeData((Biome)this).generateTerrain(chunkGenerator.getWorld(), chunkGenerator.getRand(), primer, chunkX << 4 | x, chunkZ << 4 | z, terrainNoise);
        chunkGenerator.getWorld().func_181544_b(prevSeaLevel);
    }

    @Override
    public void populate(@Nonnull INetherAPIChunkGenerator chunkGenerator, int chunkX, int chunkZ) {
        World world = chunkGenerator.getWorld();
        Random rand = chunkGenerator.getRand();
        BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)chunkGenerator, (World)world, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)false);
        TerrainGen.populate((IChunkGenerator)chunkGenerator, (World)world, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.CUSTOM);
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)chunkGenerator, (World)world, (Random)rand, (int)chunkX, (int)chunkZ, (boolean)false);
        LibExEventFactory.onPreDecorateBiome((World)world, (Random)rand, (ChunkPos)chunkPos);
        LibExEventFactory.onDecorateBiome((World)world, (Random)rand, (ChunkPos)chunkPos, (BlockPos)pos, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.CUSTOM);
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData((Biome)this);
        if (biomeData != BiomeData.EMPTY && biomeData.useDefaultBiomeDecorations()) {
            this.func_180624_a(world, rand, pos);
        }
        LibExEventFactory.onPostDecorateBiome((World)world, (Random)rand, (ChunkPos)chunkPos);
        LibExEventFactory.onPreOreGen((World)world, (Random)rand, (BlockPos)pos);
        LibExEventFactory.onOreGen((World)world, (Random)rand, (WorldGenerator)new WorldGenMinable(Blocks.field_150350_a.func_176223_P(), 0, (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150350_a)), (BlockPos)pos, (OreGenEvent.GenerateMinable.EventType)OreGenEvent.GenerateMinable.EventType.CUSTOM);
        LibExEventFactory.onPostOreGen((World)world, (Random)rand, (BlockPos)pos);
    }
}

