/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.compat.netherex;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import logictechcorp.libraryex.event.LibExEventFactory;
import logictechcorp.libraryex.world.biome.data.BiomeData;
import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.NetherExConfig;
import logictechcorp.netherex.init.NetherExBiomes;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public final class NetherExHandler {
    public static boolean doesXZShowFog() {
        return !NetherExConfig.client.visual.disableNetherFog;
    }

    public static boolean doesGravelGenerate() {
        return NetherExConfig.dimension.nether.generateGravel;
    }

    public static boolean doesSoulSandGenerate() {
        return NetherExConfig.dimension.nether.generateSoulSand;
    }

    public static void onChunkGenerate(@Nonnull Chunk chunk) {
        LibExEventFactory.onChunkGenerate((Chunk)chunk);
    }

    public static void registerBiomes(@Nonnull INetherAPIRegistry registry) {
        NetherExHandler.registerBiome(registry, (Biome)NetherExBiomes.ARCTIC_ABYSS);
        NetherExHandler.registerBiome(registry, (Biome)NetherExBiomes.FUNGI_FOREST);
        NetherExHandler.registerBiome(registry, (Biome)NetherExBiomes.RUTHLESS_SANDS);
        NetherExHandler.registerBiome(registry, (Biome)NetherExBiomes.TORRID_WASTELAND);
    }

    static void registerBiome(@Nonnull INetherAPIRegistry registry, @Nonnull Biome biome) {
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(biome);
        if (biomeData.isEnabled()) {
            registry.registerBiome(biome, biomeData.getGenerationWeight());
        }
    }

    @Nonnull
    public static List<Biome.SpawnListEntry> getSpawnableList(@Nonnull Biome biome, @Nonnull EnumCreatureType creatureType) {
        ArrayList<Biome.SpawnListEntry> spawns = new ArrayList<Biome.SpawnListEntry>(biome.func_76747_a(creatureType));
        BiomeData biomeData = NetherEx.BIOME_DATA_MANAGER.getBiomeData(biome);
        if (biomeData != BiomeData.EMPTY) {
            spawns.addAll(biomeData.getEntitySpawns(creatureType));
        }
        return spawns;
    }
}

