/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.registry;

import git.jbredwards.nether_api.api.registry.INetherAPIRegistry;
import git.jbredwards.nether_api.api.registry.INetherAPIRegistryListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nonnull;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.common.BiomeManager;

public enum NetherAPIRegistry implements INetherAPIRegistry
{
    NETHER,
    THE_END;

    @Nonnull
    final List<BiomeManager.BiomeEntry> biomes = new ArrayList<BiomeManager.BiomeEntry>();
    @Nonnull
    final List<MapGenStructure> structureHandlers = new ArrayList<MapGenStructure>();

    @Override
    public void registerBiome(@Nonnull Biome biome, int weight) {
        if (biome.delegate.name() == null) {
            throw new IllegalArgumentException("Biome must be registered!");
        }
        if (weight < 1) {
            return;
        }
        this.removeBiome(biome);
        this.biomes.add(new BiomeManager.BiomeEntry(biome, weight));
        if (biome instanceof INetherAPIRegistryListener) {
            ((INetherAPIRegistryListener)biome).onAddedToRegistry(this, OptionalInt.of(weight));
        }
    }

    @Override
    public boolean removeBiome(@Nonnull Biome biome) {
        return this.biomes.removeIf(entry -> {
            if (entry.biome == biome) {
                if (biome instanceof INetherAPIRegistryListener) {
                    ((INetherAPIRegistryListener)biome).onRemovedFromRegistry(this, OptionalInt.of(entry.field_76292_a));
                }
                return true;
            }
            return false;
        });
    }

    @Override
    @Nonnull
    public List<BiomeManager.BiomeEntry> getBiomes() {
        return Collections.unmodifiableList(this.biomes);
    }

    @Override
    public void registerStructure(@Nonnull MapGenStructure structureHandler) {
        this.removeStructure(structureHandler);
        this.structureHandlers.add(structureHandler);
        if (structureHandler instanceof INetherAPIRegistryListener) {
            ((INetherAPIRegistryListener)structureHandler).onAddedToRegistry(this, OptionalInt.empty());
        }
    }

    @Override
    public boolean removeStructure(@Nonnull MapGenStructure structureHandler) {
        return this.structureHandlers.removeIf(handler -> {
            if (handler == structureHandler) {
                if (handler instanceof INetherAPIRegistryListener) {
                    ((INetherAPIRegistryListener)handler).onRemovedFromRegistry(this, OptionalInt.empty());
                }
                return true;
            }
            return false;
        });
    }

    @Override
    @Nonnull
    public List<MapGenStructure> getStructureHandlers() {
        return Collections.unmodifiableList(this.structureHandlers);
    }

    @Override
    public void clear() {
        Iterator<BiomeManager.BiomeEntry> it = this.biomes.iterator();
        while (it.hasNext()) {
            BiomeManager.BiomeEntry entry = it.next();
            if (entry.biome instanceof INetherAPIRegistryListener) {
                ((INetherAPIRegistryListener)entry.biome).onRemovedFromRegistry(this, OptionalInt.of(entry.field_76292_a));
            }
            it.remove();
        }
        it = this.structureHandlers.iterator();
        while (it.hasNext()) {
            MapGenStructure structureHandler = (MapGenStructure)it.next();
            if (structureHandler instanceof INetherAPIRegistryListener) {
                ((INetherAPIRegistryListener)structureHandler).onRemovedFromRegistry(this, OptionalInt.empty());
            }
            it.remove();
        }
    }
}

