/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.biome;

import git.jbredwards.nether_api.api.event.NetherAPIBiomeSizeEvent;
import git.jbredwards.nether_api.api.event.NetherAPIInitBiomeGensEvent;
import git.jbredwards.nether_api.mod.common.world.biome.BiomeProviderNetherAPI;
import git.jbredwards.nether_api.mod.common.world.gen.layer.GenLayerNetherBiomes;
import git.jbredwards.nether_api.mod.common.world.gen.layer.GenLayerNetherEdgeBiomes;
import git.jbredwards.nether_api.mod.common.world.gen.layer.GenLayerNetherSubBiomes;
import javax.annotation.Nonnull;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BiomeProviderNether
extends BiomeProviderNetherAPI {
    public BiomeProviderNether(@Nonnull WorldType worldType, long seed) {
        super(worldType, seed);
    }

    @Override
    @Nonnull
    public GenLayer[] getBiomeGenerators(@Nonnull WorldType worldType, long seed) {
        NetherAPIBiomeSizeEvent.Nether event = new NetherAPIBiomeSizeEvent.Nether(worldType, 3);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        GenLayerFuzzyZoom biomeLayerBase = new GenLayerFuzzyZoom(10L, (GenLayer)new GenLayerNetherBiomes(20L));
        GenLayer biomeLayerWithSub = GenLayerZoom.func_75915_a((long)10L, (GenLayer)new GenLayerNetherSubBiomes(20L, (GenLayer)biomeLayerBase), (int)event.biomeSize);
        GenLayerNetherEdgeBiomes biomeLayerWithEdge = new GenLayerNetherEdgeBiomes(20L, biomeLayerWithSub);
        GenLayerSmooth biomeLayer = new GenLayerSmooth(10L, GenLayerZoom.func_75915_a((long)10L, (GenLayer)biomeLayerWithEdge, (int)2));
        GenLayerVoronoiZoom indexLayer = new GenLayerVoronoiZoom(10L, (GenLayer)biomeLayer);
        indexLayer.func_75905_a(seed);
        return new GenLayer[]{biomeLayer, indexLayer};
    }

    @Override
    @Nonnull
    public GenLayer[] getModdedBiomeGenerators(@Nonnull WorldType worldType, long seed, @Nonnull GenLayer[] original) {
        NetherAPIInitBiomeGensEvent.Nether event = new NetherAPIInitBiomeGensEvent.Nether(worldType, seed, original);
        MinecraftForge.TERRAIN_GEN_BUS.post((Event)event);
        return event.biomeGenerators;
    }
}

