/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.biome;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public abstract class BiomeProviderNetherAPI
extends BiomeProvider {
    public BiomeProviderNetherAPI(@Nonnull WorldType worldType, long seed) {
        GenLayer[] biomeGenerators = this.getModdedBiomeGenerators(worldType, seed, this.getBiomeGenerators(worldType, seed));
        this.field_76944_d = biomeGenerators[0];
        this.field_76945_e = biomeGenerators[1];
        this.field_76943_g = Collections.emptyList();
    }

    @Nonnull
    public abstract GenLayer[] getBiomeGenerators(@Nonnull WorldType var1, long var2);

    @Nonnull
    public abstract GenLayer[] getModdedBiomeGenerators(@Nonnull WorldType var1, long var2, @Nonnull GenLayer[] var4);

    @Nonnull
    public Biome[] func_76937_a(@Nullable Biome[] listToReuse, int x, int z, int width, int height) {
        IntCache.func_76446_a();
        int size = width * height;
        if (listToReuse == null || listToReuse.length < size) {
            listToReuse = new Biome[size];
        }
        int[] biomeIds = this.field_76944_d.func_75904_a(x, z, width, height);
        for (int i = 0; i < size; ++i) {
            int biomeId = biomeIds[i];
            listToReuse[i] = Objects.requireNonNull(Biome.func_150568_d((int)biomeId), () -> "Unmapped biome id: " + biomeId);
        }
        return listToReuse;
    }

    @Nonnull
    public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int height, boolean cacheFlag) {
        IntCache.func_76446_a();
        int size = width * height;
        if (listToReuse == null || listToReuse.length < size) {
            listToReuse = new Biome[size];
        }
        if (cacheFlag && width == 16 && height == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            Biome[] biomes = this.field_76942_f.func_76839_e(x, z);
            System.arraycopy(biomes, 0, listToReuse, 0, size);
            return listToReuse;
        }
        int[] biomeIds = this.field_76945_e.func_75904_a(x, z, width, height);
        for (int i = 0; i < size; ++i) {
            int biomeId = biomeIds[i];
            listToReuse[i] = Objects.requireNonNull(Biome.func_150568_d((int)biomeId), () -> "Unmapped biome id: " + biomeId);
        }
        return listToReuse;
    }

    public boolean func_76940_a(int x, int z, int radius, @Nonnull List<Biome> allowed) {
        return !allowed.isEmpty() && super.func_76940_a(x, z, radius, allowed);
    }

    @Nullable
    public BlockPos func_180630_a(int x, int z, int range, @Nonnull List<Biome> biomes, @Nonnull Random random) {
        return biomes.isEmpty() ? null : super.func_180630_a(x, z, range, biomes, random);
    }
}

