/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.nether_api.mod.common.world.gen;

import git.jbredwards.nether_api.api.biome.INetherBiome;
import git.jbredwards.nether_api.api.structure.ISpawningStructure;
import git.jbredwards.nether_api.api.util.NetherGenerationUtils;
import git.jbredwards.nether_api.api.world.INetherAPIChunkGenerator;
import git.jbredwards.nether_api.mod.NetherAPI;
import git.jbredwards.nether_api.mod.common.compat.netherex.NetherExHandler;
import git.jbredwards.nether_api.mod.common.registry.NetherAPIRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorHell;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.ForgeEventFactory;

public class ChunkGeneratorNether
extends ChunkGeneratorHell
implements INetherAPIChunkGenerator {
    @Nonnull
    protected final NoiseGeneratorPerlin terrainNoiseGen;
    @Nonnull
    protected Biome[] biomesForGeneration = new Biome[0];

    public ChunkGeneratorNether(@Nonnull World worldIn, boolean generateStructures, long seed) {
        super(worldIn, generateStructures, seed);
        this.terrainNoiseGen = new NoiseGeneratorPerlin(this.field_185954_p, 4);
    }

    public void func_185936_a(int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        super.func_185936_a(chunkX, chunkZ, primer);
    }

    public void func_185937_b(int chunkX, int chunkZ, @Nonnull ChunkPrimer primer) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)chunkX, (int)chunkZ, (ChunkPrimer)primer, (World)this.field_185952_n)) {
            return;
        }
        int originX = chunkX << 4;
        int originZ = chunkZ << 4;
        this.field_73185_q = this.field_73177_m.func_76304_a(this.field_73185_q, originX, originZ, 0, 16, 16, 1, 0.03125, 0.03125, 1.0);
        this.field_73184_r = this.field_73177_m.func_76304_a(this.field_73184_r, originX, 109, originZ, 16, 1, 16, 0.03125, 1.0, 0.03125);
        this.field_185955_s = this.field_73174_n.func_76304_a(this.field_185955_s, originX, originZ, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
        double[] terrainNoise = this.terrainNoiseGen.func_151599_a(null, (double)originX, (double)originZ, 16, 16, 0.0625, 0.0625, 1.0);
        for (int posX = 0; posX < 16; ++posX) {
            for (int posZ = 0; posZ < 16; ++posZ) {
                for (int posY = 4; posY >= 0; --posY) {
                    if (posY <= this.field_185954_p.nextInt(5)) {
                        primer.func_177855_a(posX, posY, posZ, field_185942_c);
                    }
                    if (posY < 4 - this.field_185954_p.nextInt(5)) continue;
                    primer.func_177855_a(posX, posY + 123, posZ, field_185942_c);
                }
                Biome biome = this.biomesForGeneration[posZ << 4 | posX];
                if (biome instanceof INetherBiome) {
                    ((INetherBiome)biome).buildSurface(this, chunkX, chunkZ, primer, posX, posZ, this.field_73185_q, this.field_73184_r, this.field_185955_s, terrainNoise[posZ << 4 | posX]);
                    continue;
                }
                NetherGenerationUtils.buildSurfaceAndSoulSandGravel(this.field_185952_n, this.field_185954_p, primer, posX, posZ, this.field_73185_q, this.field_73184_r, this.field_185955_s, field_185941_b, biome.field_76752_A, biome.field_76753_B, field_185943_d);
            }
        }
    }

    @Nonnull
    public Chunk func_185932_a(int x, int z) {
        this.field_185954_p.setSeed((long)x * 341873128712L + (long)z * 132897987541L);
        this.biomesForGeneration = this.field_185952_n.func_72959_q().func_76933_b(null, x << 4, z << 4, 16, 16);
        ChunkPrimer primer = new ChunkPrimer();
        this.func_185936_a(x, z, primer);
        this.func_185937_b(x, z, primer);
        this.field_185939_I.func_186125_a(this.field_185952_n, x, z, primer);
        if (this.areStructuresEnabled()) {
            if (this.field_73172_c != null) {
                this.field_73172_c.func_186125_a(this.field_185952_n, x, z, primer);
            }
            NetherAPIRegistry.NETHER.getStructureHandlers().forEach(structure -> structure.func_186125_a(this.field_185952_n, x, z, primer));
        }
        Chunk chunk = new Chunk(this.field_185952_n, primer, x, z);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
        }
        chunk.func_76613_n();
        if (NetherAPI.isNetherExLoaded) {
            NetherExHandler.onChunkGenerate(chunk);
        }
        return chunk;
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        boolean prevFixVanillaCascading = ForgeModContainer.fixVanillaCascading;
        ForgeModContainer.fixVanillaCascading = true;
        BlockPos pos = new BlockPos(chunkX << 4, 0, chunkZ << 4);
        Biome biome = this.field_185952_n.func_180494_b(pos.func_177982_a(16, 0, 16));
        ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
        NetherAPIRegistry.NETHER.getStructureHandlers().forEach(structure -> structure.func_175794_a(this.field_185952_n, this.field_185954_p, chunkPos));
        if (!(biome instanceof INetherBiome)) {
            this.populateWithVanilla(chunkX, chunkZ);
        } else {
            BlockFalling.field_149832_M = true;
            if (this.field_73172_c != null) {
                this.field_73172_c.func_175794_a(this.field_185952_n, this.field_185954_p, chunkPos);
            }
            ((INetherBiome)biome).populate(this, chunkX, chunkZ);
            BlockFalling.field_149832_M = false;
        }
        ForgeModContainer.fixVanillaCascading = prevFixVanillaCascading;
    }

    @Nonnull
    public List<Biome.SpawnListEntry> func_177458_a(@Nonnull EnumCreatureType creatureType, @Nonnull BlockPos pos) {
        if (this.areStructuresEnabled()) {
            if (creatureType == EnumCreatureType.MONSTER && this.field_73172_c != null && (this.field_73172_c.func_175795_b(pos) || this.field_73172_c.func_175796_a(this.field_185952_n, pos) && this.field_185952_n.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150385_bj)) {
                return this.field_73172_c.func_75059_a();
            }
            for (MapGenStructure structure : NetherAPIRegistry.NETHER.getStructureHandlers()) {
                List<Biome.SpawnListEntry> possibleCreatures;
                if (!(structure instanceof ISpawningStructure) || (possibleCreatures = ((ISpawningStructure)structure).getPossibleCreatures(creatureType, this.field_185952_n, pos)).isEmpty()) continue;
                return possibleCreatures;
            }
        }
        return NetherAPI.isNetherExLoaded ? NetherExHandler.getSpawnableList(this.field_185952_n.func_180494_b(pos), creatureType) : this.field_185952_n.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos position, boolean findUnexplored) {
        if (this.areStructuresEnabled()) {
            if ("Fortress".equals(structureName) && this.field_73172_c != null) {
                return this.field_73172_c.func_180706_b(worldIn, position, findUnexplored);
            }
            for (MapGenStructure structure : NetherAPIRegistry.NETHER.getStructureHandlers()) {
                if (!structure.func_143025_a().equals(structureName)) continue;
                return structure.func_180706_b(worldIn, position, findUnexplored);
            }
        }
        return null;
    }

    public boolean func_193414_a(@Nonnull World worldIn, @Nonnull String structureName, @Nonnull BlockPos pos) {
        if (this.areStructuresEnabled()) {
            if ("Fortress".equals(structureName) && this.field_73172_c != null) {
                return this.field_73172_c.func_175795_b(pos);
            }
            for (MapGenStructure structure : NetherAPIRegistry.NETHER.getStructureHandlers()) {
                if (!structure.func_143025_a().equals(structureName)) continue;
                return structure.func_175795_b(pos);
            }
        }
        return false;
    }

    public void func_180514_a(@Nonnull Chunk chunkIn, int x, int z) {
        if (this.areStructuresEnabled()) {
            this.field_73172_c.func_186125_a(this.field_185952_n, x, z, null);
            NetherAPIRegistry.NETHER.getStructureHandlers().forEach(structure -> structure.func_186125_a(this.field_185952_n, x, z, null));
        }
    }

    @Override
    @Nonnull
    public World getWorld() {
        return this.field_185952_n;
    }

    @Override
    @Nonnull
    public Random getRand() {
        return this.field_185954_p;
    }

    @Override
    public boolean areStructuresEnabled() {
        return this.field_185953_o;
    }

    @Override
    public void populateWithVanilla(int chunkX, int chunkZ) {
        super.func_185931_b(chunkX, chunkZ);
    }
}

