/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.rebornstorage.items;

import com.raoulvdberge.refinedstorage.RSItems;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskSyncData;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.List;
import java.util.UUID;
import me.modmuss50.rebornstorage.init.ModItems;
import me.modmuss50.rebornstorage.items.ItemBase;
import me.modmuss50.rebornstorage.items.ItemRebornStorageCellFluid;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public abstract class ItemRebornStorageCellBase
extends ItemBase
implements IStorageDiskProvider {
    private static final String NBT_ID = "id";

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        super.func_77663_a(stack, world, entity, slot, selected);
        if (!world.field_72995_K && !stack.func_77942_o()) {
            UUID id = UUID.randomUUID();
            API.instance().getStorageDiskManager(world).set(id, this.createDefaultDisk(world, this.getCapacity(stack)));
            API.instance().getStorageDiskManager(world).markForSaving();
            this.setId(stack, id);
        }
    }

    public abstract IStorageDisk createDefaultDisk(World var1, int var2);

    public void func_77624_a(ItemStack disk, World world, List<String> tooltip, ITooltipFlag flag) {
        if (this.isValid(disk)) {
            UUID id = this.getId(disk);
            API.instance().getStorageDiskSync().sendRequest(id);
            IStorageDiskSyncData data = API.instance().getStorageDiskSync().getData(id);
            if (data != null) {
                if (data.getCapacity() == -1) {
                    tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored())}));
                } else {
                    tooltip.add(I18n.func_135052_a((String)"misc.refinedstorage:storage.stored_capacity", (Object[])new Object[]{API.instance().getQuantityFormatter().format(data.getStored()), API.instance().getQuantityFormatter().format(data.getCapacity())}));
                }
            }
            if (flag.func_194127_a()) {
                tooltip.add(id.toString());
            }
        }
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public UUID getId(ItemStack disk) {
        return disk.func_77978_p().func_186857_a(NBT_ID);
    }

    public void setId(ItemStack disk, UUID id) {
        disk.func_77982_d(new NBTTagCompound());
        disk.func_77978_p().func_186854_a(NBT_ID, id);
    }

    public boolean isValid(ItemStack disk) {
        return disk.func_77942_o() && disk.func_77978_p().func_186855_b(NBT_ID);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        IStorageDisk disk;
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && (disk = API.instance().getStorageDiskManager(worldIn).getByStack(stack)) != null && disk.getStored() == 0L) {
            ItemStack part = new ItemStack(ModItems.REBORN_STORAGE_PART, 1, stack.func_77952_i() + (((Object)((Object)this)).getClass() == ItemRebornStorageCellFluid.class ? 4 : 0));
            if (!playerIn.field_71071_by.func_70441_a(part.func_77946_l())) {
                InventoryHelper.func_180173_a((World)worldIn, (double)playerIn.func_180425_c().func_177958_n(), (double)playerIn.func_180425_c().func_177956_o(), (double)playerIn.func_180425_c().func_177952_p(), (ItemStack)part);
            }
            API.instance().getStorageDiskManager(worldIn).remove(this.getId(stack));
            API.instance().getStorageDiskManager(worldIn).markForSaving();
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)RSItems.STORAGE_HOUSING));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }
}

