/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.rebornstorage.tiles;

import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.modmuss50.rebornstorage.RebornStorageEventHandler;
import me.modmuss50.rebornstorage.blocks.BlockMultiCrafter;
import me.modmuss50.rebornstorage.multiblocks.MultiBlockCrafter;
import me.modmuss50.rebornstorage.tiles.TileMultiCrafter;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import reborncore.RebornCore;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;

@RebornRegistry(modID="rebornstorage")
public class CraftingNode
implements INetworkNode,
ICraftingPatternContainer {
    World world;
    BlockPos pos;
    List<ICraftingPattern> actualPatterns = new ArrayList<ICraftingPattern>();
    @Nullable
    INetwork network;
    int ticks = 0;
    private UUID uuid;
    private boolean needsRebuild = false;
    private boolean isValid;
    private int speed = -1;
    @ConfigRegistry(comment="This is the crafting speed of the cpus, the higher the number the more crafting cpus will be needed to achieve greater speeds")
    public static int craftingSpeed = 15;
    @ConfigRegistry(comment="The number of seconds between a pattern rebuild when inserting items, a higher number will reduce the load on the server, but patterns may take longer to show")
    public static int invUpdateTime = 5;
    private int maxCraftingUpdates;
    private int craftingUpdatesLeft;
    private int updateInterval = 10;
    private int energyUsage = -1;
    private final String variant;
    public CachingItemHandler patterns = new CachingItemHandler(this, 78, (Consumer)new ListenerNetworkNode((INetworkNode)this), new Predicate[]{s -> s.func_77973_b() instanceof ICraftingPatternProvider && ((ICraftingPatternProvider)s.func_77973_b()).create(this.world, s).isValid()}){

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            CraftingNode.this.markDirty();
            CraftingNode.this.needsRebuild = true;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };

    public void invalidate() {
        this.isValid = false;
    }

    public CraftingNode(World world, BlockPos pos, String variant) {
        this.world = world;
        this.pos = pos;
        if (variant == null || variant.isEmpty()) {
            IBlockState state = world.func_180495_p(pos);
            variant = !(state.func_177230_c() instanceof BlockMultiCrafter) ? "unknown" : (String)((Object)state.func_177229_b((IProperty)BlockMultiCrafter.VARIANTS));
        }
        this.variant = variant;
    }

    public void rebuildPatterns(String reason) {
        this.actualPatterns.clear();
        if (!this.world.field_72995_K && this.isValidMultiBlock(true)) {
            if (!this.patterns.isEmpty()) {
                for (int i = 0; i < this.patterns.getSlots(); ++i) {
                    ItemStack stack = this.patterns.getStackInSlot(i);
                    if (!stack.func_190926_b() && stack.func_77973_b() instanceof ICraftingPatternProvider) {
                        if (this.patterns.craftingPatternMap.containsKey(i)) {
                            this.actualPatterns.add(this.patterns.craftingPatternMap.get(i));
                            continue;
                        }
                        ICraftingPattern pattern = ((ICraftingPatternProvider)stack.func_77973_b()).create(this.world, stack);
                        if (!pattern.isValid()) continue;
                        this.actualPatterns.add(pattern);
                        this.patterns.craftingPatternMap.put(i, pattern);
                        continue;
                    }
                    this.patterns.craftingPatternMap.remove(i);
                }
            } else {
                this.patterns.craftingPatternMap.clear();
            }
        }
        if (this.getNetwork() != null) {
            RebornStorageEventHandler.queue(this.network.getCraftingManager(), this, reason);
        }
    }

    protected void stateChange(INetwork network, boolean state, String reason) {
        if (!state) {
            this.actualPatterns.clear();
        }
        RebornStorageEventHandler.queue(network.getCraftingManager(), this, reason);
    }

    @Nullable
    public TileMultiCrafter getTile() {
        TileEntity tileEntity = this.world.func_175625_s(this.pos);
        if (tileEntity instanceof TileMultiCrafter) {
            return (TileMultiCrafter)tileEntity;
        }
        RebornCore.logHelper.debug((Object)(tileEntity + " is not an instance of TileMultiCrafter, this is an error and your RebornStorage multiblock may not work. Please report to the mod author " + this.pos));
        return null;
    }

    public boolean isValidMultiBlock(boolean check) {
        if (!check && this.isValid) {
            return true;
        }
        TileMultiCrafter tileMultiCrafter = this.getTile();
        if (tileMultiCrafter == null) {
            return false;
        }
        MultiBlockCrafter multiBlockCrafter = this.getTile().getMultiBlock();
        if (multiBlockCrafter == null) {
            return false;
        }
        this.isValid = multiBlockCrafter.isAssembled();
        return this.isValid;
    }

    public int getEnergyUsage() {
        if (this.energyUsage == -1) {
            switch (this.variant) {
                case "frame": {
                    this.energyUsage = 1;
                    break;
                }
                case "cpu": 
                case "io": 
                case "heat": {
                    this.energyUsage = 0;
                    break;
                }
                default: {
                    this.energyUsage = 50;
                }
            }
        }
        return this.energyUsage;
    }

    @Nonnull
    public ItemStack getItemStack() {
        return this.getTile().getStack();
    }

    public void onConnected(INetwork iNetwork) {
        this.network = iNetwork;
        this.stateChange(this.network, true, "connected to network");
        this.rebuildPatterns("connected to network");
    }

    public void onDisconnected(INetwork iNetwork) {
        this.network = null;
        this.actualPatterns.clear();
        this.stateChange(iNetwork, true, "disconnected from network");
    }

    public boolean canUpdate() {
        if (this.network != null) {
            return this.network.canRun();
        }
        return false;
    }

    @Nullable
    public INetwork getNetwork() {
        return this.network;
    }

    public void update() {
        ++this.ticks;
        if (this.ticks == 1) {
            this.rebuildPatterns("first tick rebuild");
        }
        if (this.ticks % 5 == 0) {
            this.updateUpdateInterval();
            this.updateMaxCraftingUpdates();
        }
        if (this.updateInterval != 0 && this.ticks % this.updateInterval == 0) {
            this.craftingUpdatesLeft = this.maxCraftingUpdates;
        }
        if (this.needsRebuild && this.world.func_82737_E() % (long)(invUpdateTime * 20) == 0L) {
            this.rebuildPatterns("inv slot change");
            this.needsRebuild = false;
        }
    }

    public boolean isTickable() {
        return this.variant.equals("storage");
    }

    public void useCraftingUpdates(int updates) {
        this.craftingUpdatesLeft = Math.max(this.craftingUpdatesLeft - updates, 0);
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public int getCraftingUpdatesLeft() {
        return this.craftingUpdatesLeft;
    }

    public NBTTagCompound write(NBTTagCompound nbtTagCompound) {
        StackUtils.writeItems((IItemHandler)this.patterns, (int)0, (NBTTagCompound)nbtTagCompound);
        return nbtTagCompound;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public World getWorld() {
        return this.world;
    }

    public void markDirty() {
        if (!this.world.field_72995_K) {
            API.instance().getNetworkNodeManager(this.world).markForSaving();
        }
    }

    public String getId() {
        return "rebornstorage:multiblockcrafter";
    }

    public void updateUpdateInterval() {
        this.updateInterval = Math.max(craftingSpeed - this.getCraftingCpus(), 1);
    }

    public void updateMaxCraftingUpdates() {
        if (this.getCraftingCpus() < craftingSpeed) {
            this.maxCraftingUpdates = 1;
        }
        this.maxCraftingUpdates = Math.max(this.getCraftingCpus() / Math.max(craftingSpeed, 1), 1);
    }

    public int getCraftingCpus() {
        if (this.isValid && this.speed != -1) {
            return this.speed;
        }
        if (!this.isValidMultiBlock(false)) {
            return 0;
        }
        TileMultiCrafter tile = this.getTile();
        if (tile == null) {
            return 0;
        }
        MultiBlockCrafter multiBlock = tile.getMultiBlock();
        if (multiBlock == null) {
            return 0;
        }
        this.speed = multiBlock.speed;
        return this.speed;
    }

    public IItemHandler getConnectedInventory() {
        return null;
    }

    @Nullable
    public IFluidHandler getConnectedFluidInventory() {
        return null;
    }

    public TileEntity getConnectedTile() {
        return null;
    }

    public TileEntity getFacingTile() {
        return null;
    }

    public EnumFacing getDirection() {
        return null;
    }

    public List<ICraftingPattern> getPatterns() {
        return this.actualPatterns;
    }

    public IItemHandlerModifiable getPatternInventory() {
        if (this.isValidMultiBlock(true) && this.getTile().getVarient() != null && this.getTile().getVarient().equals("storage")) {
            return this.patterns;
        }
        return null;
    }

    public String getName() {
        return "MultiBlock Crafter";
    }

    public BlockPos getPosition() {
        return this.pos;
    }

    @Nullable
    public ICraftingPatternContainer getRootContainer() {
        return null;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        return this.uuid;
    }

    public abstract class CachingItemHandler
    extends ItemHandlerBase {
        private int firstAvailable;
        private int lastUsed;
        protected CraftingNode craftingNode;
        protected HashMap<Integer, ICraftingPattern> craftingPatternMap;

        public CachingItemHandler(CraftingNode craftingNode, @Nullable int size, Consumer<Integer> listener, Predicate<ItemStack> ... validators) {
            super(size, listener, (Predicate[])validators);
            this.firstAvailable = 0;
            this.lastUsed = -1;
            this.craftingPatternMap = new HashMap();
            this.craftingNode = craftingNode;
        }

        protected void onLoad() {
            super.onLoad();
            this.firstAvailable = this.getSlots();
            this.lastUsed = -1;
            for (int i = 0; i < this.getSlots(); ++i) {
                if (this.getStackInSlot(i).func_190926_b()) {
                    this.firstAvailable = Integer.min(this.firstAvailable, i);
                    continue;
                }
                this.lastUsed = Integer.max(this.lastUsed, i);
            }
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            int i = slot;
            while (i < this.firstAvailable && i >= 0 && this.getStackInSlot(i).func_190926_b()) {
                this.firstAvailable = i--;
            }
            for (i = slot; i == this.firstAvailable && i < this.getSlots() && !this.getStackInSlot(i).func_190926_b(); ++i) {
                this.firstAvailable = i + 1;
            }
            i = slot;
            while (i > this.lastUsed && i < this.getSlots() && !this.getStackInSlot(i).func_190926_b()) {
                this.lastUsed = i++;
            }
            for (i = slot; i == this.lastUsed && i >= 0 && this.getStackInSlot(i).func_190926_b(); --i) {
                this.lastUsed = i - 1;
            }
            this.craftingPatternMap.remove(slot);
        }

        public int getFirstAvailable() {
            return this.firstAvailable;
        }

        public int getLastUsed() {
            return this.lastUsed;
        }

        public boolean isEmpty() {
            return this.lastUsed == -1;
        }

        public boolean isFull() {
            return this.firstAvailable == this.getSlots();
        }
    }
}

