/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.common.blocks;

import com.ferreusveritas.cathedral.common.blocks.StandardEnum;
import com.ferreusveritas.cathedral.proxy.ModelHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public abstract class BlockMultiVariant<E extends Enum<E>>
extends Block {
    public PropertyEnum<E> variant;
    public final E[] values;

    public BlockMultiVariant(Material materialIn, Class<E> e, String name) {
        super(materialIn);
        this.variant = PropertyEnum.func_177709_a((String)"variant", e);
        this.values = (Enum[])e.getEnumConstants();
        this.setRegistryName(name);
        this.func_149663_c(name);
    }

    public abstract void makeVariantProperty();

    protected BlockStateContainer func_180661_e() {
        this.makeVariantProperty();
        return new BlockStateContainer((Block)this, new IProperty[]{this.variant});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(this.variant, this.byMetadata(meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((StandardEnum)((Object)((Enum)((Object)state.func_177229_b(this.variant))))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((StandardEnum)((Object)((Enum)((Object)state.func_177229_b(this.variant))))).getMetadata();
    }

    public E byMetadata(int meta) {
        return this.values[MathHelper.func_76125_a((int)meta, (int)0, (int)(this.values.length - 1))];
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (E type : this.values) {
            items.add((Object)new ItemStack((Block)this, 1, ((StandardEnum)type).getMetadata()));
        }
    }

    public Item getItemMultiTexture() {
        return (Item)new ItemMultiTexture((Block)this, (Block)this, new ItemMultiTexture.Mapper(){

            public String apply(ItemStack stack) {
                return ((StandardEnum)BlockMultiVariant.this.byMetadata(stack.func_77960_j())).getUnlocalizedName();
            }
        }).setRegistryName(this.getRegistryName());
    }

    public void registerItemModels() {
        for (E type : this.values) {
            ModelHelper.regModel(Item.func_150898_a((Block)this), ((StandardEnum)type).getMetadata(), new ResourceLocation("cathedral", this.getRegistryName().func_110623_a() + "." + ((StandardEnum)type).getUnlocalizedName()));
        }
    }

    public void addChiselVariation(String group) {
        for (E type : this.values) {
            FMLInterModComms.sendMessage((String)"chisel", (String)"variation:add", (String)(group + "|" + this.getRegistryName() + "|" + ((StandardEnum)type).getMetadata()));
        }
    }
}

