/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.cathedral;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.features.IVariantEnumType;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.oredict.OreDictionary;

public class BlockChain
extends Block {
    public static final String name = "chain";
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockChain() {
        this(name);
    }

    public BlockChain(String name) {
        super(Material.field_151573_f);
        this.func_149713_g(0);
        this.func_149752_b(5.0f);
        this.func_149711_c(1.0f);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_149647_a(CathedralMod.tabCathedral);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getChainColor(int subBlock) {
        return EnumType.byMetadata(subBlock).color;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.UNDEFINED : BlockFaceShape.CENTER_SMALL;
    }

    public static enum EnumType implements IStringSerializable,
    IVariantEnumType
    {
        IRON(0, "Iron", 0xD7D7D7),
        GOLD(1, "Gold", 14727200),
        DWEMER(2, "Dwemer", 12822606),
        COPPER(3, "Copper", 12476721),
        BRONZE(4, "Bronze", 10971937),
        SILVER(5, "Silver", 0xD6DADD),
        ENDERIUM(6, "Enderium", 0x44B8B8);

        private final int meta;
        private final String name;
        private final String unlocalizedName;
        private final String orename;
        private final int color;

        private EnumType(int index, String name, int color) {
            this.meta = index;
            this.name = name.toLowerCase();
            this.unlocalizedName = name.toLowerCase();
            this.orename = name;
            this.color = color;
        }

        @Override
        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public String getOreName() {
            if (this.orename.equals(EnumType.DWEMER.orename)) {
                if (OreDictionary.doesOreNameExist((String)"nuggetDwemer")) {
                    return this.orename;
                }
                if (OreDictionary.doesOreNameExist((String)"nuggetDawnstone")) {
                    return "Dawnstone";
                }
            }
            return this.orename;
        }

        public static EnumType byMetadata(int meta) {
            return EnumType.values()[MathHelper.func_76125_a((int)meta, (int)0, (int)(EnumType.values().length - 1))];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public int getColor() {
            return this.color;
        }
    }
}

