/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.features.dwarven;

import com.ferreusveritas.cathedral.CathedralMod;
import com.ferreusveritas.cathedral.common.blocks.StandardEnum;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;

public class BlockDwarvenBars
extends BlockPane {
    public static final String name = "bars";
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final PropertyEnum<EnumCapping> CAPPING = PropertyEnum.func_177709_a((String)"capping", EnumCapping.class);

    public BlockDwarvenBars(String name) {
        super(Material.field_151573_f, true);
        this.setRegistryName(name);
        this.func_149663_c(name);
        this.func_180632_j(this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.NORMAL)));
        this.setHarvestLevel("pickaxe", 0);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149752_b(20.0f);
        this.func_149711_c(2.5f);
        this.func_149647_a(CathedralMod.tabDwemer);
    }

    public BlockDwarvenBars() {
        this(name);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176241_b, field_176242_M, field_176243_N, field_176244_O, VARIANT, CAPPING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        state = super.func_176221_a(state, worldIn, pos);
        boolean north = (Boolean)state.func_177229_b((IProperty)field_176241_b);
        boolean east = (Boolean)state.func_177229_b((IProperty)field_176242_M);
        boolean south = (Boolean)state.func_177229_b((IProperty)field_176243_N);
        boolean west = (Boolean)state.func_177229_b((IProperty)field_176244_O);
        return state.func_177226_a(CAPPING, (Comparable)((Object)(north && !east && !south && !west ? EnumCapping.NORTH : (!north && east && !south && !west ? EnumCapping.EAST : (!north && !east && south && !west ? EnumCapping.SOUTH : (!north && !east && !south && west ? EnumCapping.WEST : (!north && !east && !south && !west ? EnumCapping.POST : EnumCapping.NONE)))))));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byMetadata(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(VARIANT))).getMetadata();
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (EnumType type : EnumType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.getMetadata()));
        }
    }

    public static enum EnumCapping implements IStringSerializable
    {
        NONE,
        POST,
        NORTH,
        EAST,
        SOUTH,
        WEST;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }

    public static enum EnumType implements StandardEnum
    {
        NORMAL,
        ORNATE,
        FOOTER,
        HEADER,
        MASK,
        RHOMBUS;


        @Override
        public int getMetadata() {
            return this.ordinal();
        }

        public String toString() {
            return this.func_176610_l();
        }

        public static EnumType byMetadata(int meta) {
            return EnumType.values()[MathHelper.func_76125_a((int)meta, (int)0, (int)(EnumType.values().length - 1))];
        }
    }
}

