/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.models;

import com.ferreusveritas.cathedral.features.cathedral.EnumMaterial;
import com.ferreusveritas.cathedral.models.BakedModelBlockRailing;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class ModelBlockRailing
implements IModel {
    private IModel modelPost;
    private IModel modelCap;
    private IModel modelSide;
    private EnumMaterial material;

    public ModelBlockRailing(ResourceLocation modelLocation) {
        try {
            this.modelPost = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "block/cathedral/rail_post"));
            this.modelCap = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "block/cathedral/rail_cap"));
            this.modelSide = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(modelLocation.func_110624_b(), "block/cathedral/rail_side"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (modelLocation instanceof ModelResourceLocation) {
            ModelResourceLocation mrl = (ModelResourceLocation)modelLocation;
            this.material = EnumMaterial.byName(mrl.func_177518_c());
        }
    }

    public Collection<ResourceLocation> getTextures() {
        return this.getTextureMap().values();
    }

    private static Map<String, ResourceLocation> generic(EnumMaterial material, ResourceLocation defaultTexture) {
        HashMap<String, ResourceLocation> stuff = new HashMap<String, ResourceLocation>();
        stuff.put("default", defaultTexture);
        return stuff;
    }

    private Map<String, ResourceLocation> getTextureMap() {
        return ModelBlockRailing.generic(this.material, this.material.getBevelledTexture());
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        Map<String, String> stuff = this.getTextureMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ResourceLocation)e.getValue()).toString()));
        ImmutableMap textures = ImmutableMap.copyOf(stuff);
        IBakedModel bakedPost = this.modelPost.retexture(textures).bake(state, format, bakedTextureGetter);
        IBakedModel bakedCap = this.modelCap.retexture(textures).bake(state, format, bakedTextureGetter);
        IBakedModel[] bakedSides = new IBakedModel[4];
        for (EnumFacing dir : EnumFacing.field_176754_o) {
            int i = dir.func_176736_b();
            bakedSides[i] = this.modelSide.uvlock(true).retexture(textures).bake((IModelState)ModelRotation.func_177524_a((int)0, (int)(i * 90)), format, bakedTextureGetter);
        }
        TextureAtlasSprite particleSprite = bakedTextureGetter.apply(this.material.getFlatTexture());
        return new BakedModelBlockRailing(bakedPost, bakedCap, bakedSides, particleSprite);
    }
}

