/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.util;

import com.ferreusveritas.cathedral.util.UnpackedQuad;
import com.ferreusveritas.cathedral.util.UnpackedVertex;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class UnpackedModel {
    public static final Predicate TRUE = x -> true;
    public final Map<EnumFacing, List<UnpackedQuad>> upqMap = anySides.stream().collect(Collectors.toMap(d -> d, d -> new ArrayList()));
    public static final List<EnumFacing> anySides = Lists.newArrayList((Object[])new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST, null});

    private UnpackedModel() {
    }

    public UnpackedModel(IBakedModel bakedModel, IBlockState state, long rand) {
        this();
        for (EnumFacing dir : anySides) {
            this.upqMap.get(dir).addAll(bakedModel.func_188616_a(state, dir, rand).stream().map(UnpackedQuad::new).collect(Collectors.toList()));
        }
    }

    public UnpackedModel addQuad(UnpackedQuad quad, EnumFacing side) {
        this.upqMap.get(side).add(quad);
        return this;
    }

    public UnpackedModel addQuads(List<UnpackedQuad> quads, EnumFacing side) {
        this.upqMap.get(side).addAll(quads);
        return this;
    }

    public List<UnpackedQuad> getQuads(EnumFacing dir) {
        return this.upqMap.get(dir);
    }

    public List<UnpackedQuad> getQuads() {
        return this.getQuads(TRUE);
    }

    public List<UnpackedQuad> getQuads(@Nonnull Predicate<UnpackedQuad> filter) {
        return this.upqMap.values().stream().flatMap(Collection::stream).filter(filter).collect(Collectors.toList());
    }

    public UnpackedModel apply(Predicate<UnpackedQuad> filter, Consumer<UnpackedQuad> consumer) {
        this.getQuads(filter).forEach(consumer);
        return this;
    }

    public UnpackedModel apply(Consumer<UnpackedQuad> consumer) {
        this.getQuads().forEach(consumer);
        return this;
    }

    public AxisAlignedBB getModelAABB() {
        double minX = Double.NaN;
        double minY = Double.NaN;
        double minZ = Double.NaN;
        double maxX = Double.NaN;
        double maxY = Double.NaN;
        double maxZ = Double.NaN;
        for (Map.Entry<EnumFacing, List<UnpackedQuad>> entry : this.upqMap.entrySet()) {
            for (UnpackedQuad upq : entry.getValue()) {
                for (UnpackedVertex v : upq.vertices) {
                    minX = minX < (double)v.x ? minX : (double)v.x;
                    minY = minY < (double)v.y ? minY : (double)v.y;
                    minZ = minZ < (double)v.z ? minZ : (double)v.z;
                    maxX = maxX > (double)v.x ? maxX : (double)v.x;
                    maxY = maxY > (double)v.y ? maxY : (double)v.y;
                    maxZ = maxZ > (double)v.z ? maxZ : (double)v.z;
                }
            }
        }
        return new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public UnpackedModel makeFullBlock() {
        UnpackedModel upm = new UnpackedModel();
        for (EnumFacing dir : EnumFacing.values()) {
            if (this.upqMap.get(dir).size() > 0) {
                upm.addQuad(new UnpackedQuad(this.upqMap.get(dir).get(0)).normalize(), dir);
                continue;
            }
            this.getQuads((UnpackedQuad q) -> q.face == dir).stream().map(UnpackedQuad::new).peek(UnpackedQuad::calcArea).max((a, b) -> Float.compare(a.area, b.area)).ifPresent(q -> upm.addQuad(q.normalize(), dir));
        }
        return upm;
    }

    public UnpackedModel makePartialBlock(AxisAlignedBB aabb) {
        return this.makePartialBlock(aabb, true);
    }

    public UnpackedModel makePartialBlock(AxisAlignedBB aabb_in, boolean clip) {
        AxisAlignedBB aabb = clip ? aabb_in.func_191500_a(new AxisAlignedBB(BlockPos.field_177992_a)) : aabb_in;
        UnpackedModel upm = this.makeFullBlock().apply(q -> q.crop(aabb));
        for (EnumFacing dir : EnumFacing.values()) {
            double val = dir.func_176743_c().func_179524_a() + 1 >> 1;
            if (UnpackedModel.getAABBValue(aabb, dir) == val) continue;
            List<UnpackedQuad> list = upm.getQuads(dir);
            upm.addQuads(list, null);
            list.clear();
        }
        return upm;
    }

    public static double getAABBValue(AxisAlignedBB aabb, EnumFacing dir) {
        return (new double[]{aabb.field_72338_b, aabb.field_72337_e, aabb.field_72339_c, aabb.field_72334_f, aabb.field_72340_a, aabb.field_72336_d})[dir.func_176745_a()];
    }

    public UnpackedModel color(int color) {
        this.apply(q -> q.color(color));
        return this;
    }

    public UnpackedModel move(Vec3d offset) {
        this.apply(q -> q.move(offset));
        return this;
    }

    public Map<EnumFacing, List<BakedQuad>> pack() {
        return this.pack(TRUE);
    }

    public Map<EnumFacing, List<BakedQuad>> pack(Predicate<UnpackedQuad> filter) {
        Map<EnumFacing, List<BakedQuad>> bqMap = UnpackedModel.newBakedStorage();
        this.packInto(filter, bqMap);
        return bqMap;
    }

    public UnpackedModel packInto(Map<EnumFacing, List<BakedQuad>> bqMap) {
        return this.packInto(TRUE, bqMap);
    }

    public UnpackedModel packInto(Predicate<UnpackedQuad> filter, Map<EnumFacing, List<BakedQuad>> bqMap) {
        for (EnumFacing side : anySides) {
            bqMap.get(side).addAll(this.upqMap.get(side).stream().filter(filter).map(q -> q.pack()).collect(Collectors.toList()));
        }
        return this;
    }

    public static Map<EnumFacing, List<BakedQuad>> newBakedStorage() {
        return anySides.stream().collect(Collectors.toMap(d -> d, d -> new ArrayList()));
    }
}

