/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.cathedral.util;

import com.ferreusveritas.cathedral.util.UnpackedVertex;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.Attributes;

public class UnpackedQuad {
    public UnpackedVertex[] vertices = new UnpackedVertex[4];
    public TextureAtlasSprite sprite;
    public EnumFacing face;
    public int tintIndex;
    public float area;
    public boolean applyDiffuseLighting = true;

    public UnpackedQuad() {
        for (int i = 0; i < 4; ++i) {
            this.vertices[i] = new UnpackedVertex();
        }
    }

    public UnpackedQuad(UnpackedQuad o) {
        this.face = o.face;
        this.sprite = o.sprite;
        this.area = o.area;
        this.tintIndex = o.tintIndex;
        this.applyDiffuseLighting = o.applyDiffuseLighting;
        for (int i = 0; i < 4; ++i) {
            UnpackedVertex vert = this.vertices[i] = new UnpackedVertex();
            UnpackedVertex oVert = o.vertices[i];
            vert.x = oVert.x;
            vert.y = oVert.y;
            vert.z = oVert.z;
            vert.color = oVert.color;
            vert.u = oVert.u;
            vert.v = oVert.v;
            vert.nx = oVert.nx;
            vert.ny = oVert.ny;
            vert.nz = oVert.nz;
        }
    }

    public UnpackedQuad(BakedQuad inQuad) {
        this();
        int[] vertexDataIn = inQuad.func_178209_a();
        this.sprite = inQuad.func_187508_a();
        this.face = inQuad.func_178210_d();
        this.tintIndex = inQuad.func_178211_c();
        int vertexNum = 0;
        for (int vertexPos = 0; vertexPos < vertexDataIn.length; vertexPos += inQuad.getFormat().func_181719_f()) {
            int vfePos = 0;
            UnpackedVertex outVertex = this.vertices[vertexNum++];
            for (VertexFormatElement vfe : inQuad.getFormat().func_177343_g()) {
                switch (vfe.func_177375_c()) {
                    case POSITION: {
                        if (vfe.func_177367_b() == VertexFormatElement.EnumType.FLOAT) {
                            outVertex.x = Float.intBitsToFloat(vertexDataIn[vertexPos + vfePos + 0]);
                            outVertex.y = Float.intBitsToFloat(vertexDataIn[vertexPos + vfePos + 1]);
                            outVertex.z = Float.intBitsToFloat(vertexDataIn[vertexPos + vfePos + 2]);
                            break;
                        }
                        System.err.println("Unhandled " + vfe.func_177375_c() + " Data Type: " + vfe.func_177367_b());
                        break;
                    }
                    case NORMAL: {
                        if (vfe.func_177367_b() == VertexFormatElement.EnumType.BYTE) {
                            int normalData = vertexDataIn[vertexPos + vfePos + 0];
                            outVertex.nx = (byte)(normalData >> 0 & 0xFF);
                            outVertex.ny = (byte)(normalData >> 8 & 0xFF);
                            outVertex.nz = (byte)(normalData >> 16 & 0xFF);
                            break;
                        }
                        System.err.println("Unhandled " + vfe.func_177375_c() + " Data Type: " + vfe.func_177367_b());
                        break;
                    }
                    case COLOR: {
                        if (vfe.func_177367_b() == VertexFormatElement.EnumType.UBYTE) {
                            outVertex.color = vertexDataIn[vertexPos + vfePos + 0];
                            break;
                        }
                        System.err.println("Unhandled " + vfe.func_177375_c() + " Data Type: " + vfe.func_177367_b());
                        break;
                    }
                    case UV: {
                        if (vfe.func_177367_b() == VertexFormatElement.EnumType.FLOAT) {
                            outVertex.u = Float.intBitsToFloat(vertexDataIn[vertexPos + vfePos + 0]);
                            outVertex.v = Float.intBitsToFloat(vertexDataIn[vertexPos + vfePos + 1]);
                            break;
                        }
                        System.err.println("Unhandled " + vfe.func_177375_c() + " Data Type: " + vfe.func_177367_b());
                        break;
                    }
                    case PADDING: {
                        break;
                    }
                    default: {
                        System.err.println("Unhandled VertexFormat Element Usage: " + vfe.func_177375_c());
                    }
                }
                vfePos += vfe.func_177368_f() / 4;
            }
        }
    }

    public BakedQuad pack() {
        int[] data = new int[28];
        int n = 0;
        for (UnpackedVertex v : this.vertices) {
            data[n++] = Float.floatToIntBits(v.x);
            data[n++] = Float.floatToIntBits(v.y);
            data[n++] = Float.floatToIntBits(v.z);
            data[n++] = v.color;
            data[n++] = Float.floatToIntBits(v.u);
            data[n++] = Float.floatToIntBits(v.v);
            data[n++] = v.nx | v.ny << 8 | v.nz << 16;
        }
        return new BakedQuad(data, this.tintIndex, this.face, this.sprite, this.applyDiffuseLighting, Attributes.DEFAULT_BAKED_FORMAT);
    }

    public static List<UnpackedQuad> unpackAll(List<BakedQuad> inQuads) {
        return inQuads.stream().map(in -> new UnpackedQuad((BakedQuad)in)).collect(Collectors.toList());
    }

    public static List<BakedQuad> packAll(List<UnpackedQuad> inQuads) {
        return inQuads.stream().map(in -> in.pack()).collect(Collectors.toList());
    }

    public float calcArea() {
        float minX = Float.NaN;
        float minY = Float.NaN;
        float minZ = Float.NaN;
        float maxX = Float.NaN;
        float maxY = Float.NaN;
        float maxZ = Float.NaN;
        for (UnpackedVertex v : this.vertices) {
            minX = minX < v.x ? minX : v.x;
            minY = minY < v.y ? minY : v.y;
            minZ = minZ < v.z ? minZ : v.z;
            maxX = maxX > v.x ? maxX : v.x;
            maxY = maxY > v.y ? maxY : v.y;
            maxZ = maxZ > v.z ? maxZ : v.z;
        }
        switch (this.face.func_176740_k()) {
            case X: {
                this.area = (maxY - minY) * (maxZ - minZ);
            }
            case Y: {
                this.area = (maxX - minX) * (maxZ - minZ);
            }
            case Z: {
                this.area = (maxX - minX) * (maxY - minY);
            }
        }
        this.area = 0.0f;
        return this.area;
    }

    public UnpackedQuad normalize() {
        float[] corners = new float[]{this.sprite.func_94209_e(), this.sprite.func_94206_g(), this.sprite.func_94212_f(), this.sprite.func_94210_h()};
        ArrayList verts = Lists.newArrayList((Object[])this.vertices);
        for (int c = 0; c < 4; ++c) {
            float cU = corners[c & 2];
            float cV = corners[(c & 1) * 2 + 1];
            float minDelta = 999.0f;
            UnpackedVertex nearest = null;
            for (UnpackedVertex v : verts) {
                float delU = v.u - cU;
                float delV = v.v - cV;
                float delta = delU * delU + delV * delV;
                if (!(delta < minDelta)) continue;
                minDelta = delta;
                nearest = v;
            }
            verts.remove(nearest);
            nearest.u = cU;
            nearest.v = cV;
        }
        EnumFacing.Axis axis = this.face.func_176740_k();
        float limit = MathHelper.func_76125_a((int)this.face.func_176743_c().func_179524_a(), (int)0, (int)1);
        block7: for (UnpackedVertex v : this.vertices) {
            switch (axis) {
                case X: {
                    v.x = limit;
                    continue block7;
                }
                case Y: {
                    v.y = limit;
                    continue block7;
                }
                case Z: {
                    v.z = limit;
                }
            }
        }
        ArrayList<Vec3d> corners2 = new ArrayList<Vec3d>();
        for (int c = 0; c < 8; ++c) {
            double z;
            double y;
            double x = axis == EnumFacing.Axis.X ? (double)limit : (double)(c >> 2 & 1);
            Vec3d v = new Vec3d(x, y = axis == EnumFacing.Axis.Y ? (double)limit : (double)(c >> 1 & 1), z = axis == EnumFacing.Axis.Z ? (double)limit : (double)(c >> 0 & 1));
            if (corners2.contains(v)) continue;
            corners2.add(v);
        }
        ArrayList verts2 = Lists.newArrayList((Object[])this.vertices);
        for (Vec3d corn : corners2) {
            double minDelta = 999.0;
            UnpackedVertex nearest = null;
            for (UnpackedVertex v : verts2) {
                Vec3d vert = new Vec3d((double)v.x, (double)v.y, (double)v.z);
                double delta = corn.func_72436_e(vert);
                if (!(delta < minDelta)) continue;
                minDelta = delta;
                nearest = v;
            }
            verts2.remove(nearest);
            nearest.x = (float)corn.field_72450_a;
            nearest.y = (float)corn.field_72448_b;
            nearest.z = (float)corn.field_72449_c;
        }
        return this;
    }

    public UnpackedQuad move(Vec3d offset) {
        for (UnpackedVertex v : this.vertices) {
            v.x = (float)((double)v.x + offset.field_72450_a);
            v.y = (float)((double)v.y + offset.field_72448_b);
            v.z = (float)((double)v.z + offset.field_72449_c);
        }
        return this;
    }

    public UnpackedQuad color(float srcR, float srcG, float srcB, float srcA) {
        for (UnpackedVertex v : this.vertices) {
            int dstA = (int)((float)(v.color >> 24 & 0xFF) * srcA);
            int dstR = (int)((float)(v.color >> 16 & 0xFF) * srcR);
            int dstG = (int)((float)(v.color >> 8 & 0xFF) * srcG);
            int dstB = (int)((float)(v.color >> 0 & 0xFF) * srcB);
            v.color = dstA << 24 | dstB << 16 | dstG << 8 | dstR;
        }
        return this;
    }

    public UnpackedQuad color(float srcR, float srcG, float srcB) {
        return this.color(srcR, srcG, srcB, 1.0f);
    }

    public UnpackedQuad color(float factor) {
        return this.color(factor, factor, factor, 1.0f);
    }

    public UnpackedQuad color(int color) {
        float srcA = (float)(color >> 24 & 0xFF) / 255.0f;
        float srcR = (float)(color >> 16 & 0xFF) / 255.0f;
        float srcG = (float)(color >> 8 & 0xFF) / 255.0f;
        float srcB = (float)(color >> 0 & 0xFF) / 255.0f;
        return this.color(srcR, srcG, srcB, srcA);
    }

    public UnpackedQuad crop(AxisAlignedBB aabb) {
        UnpackedVertex[] v = new UnpackedVertex[5];
        v[4] = new UnpackedVertex();
        int[] sortData = new int[]{21505, 26418, 8262, 29971, 12546, 25687};
        for (int i = 0; i < 4; ++i) {
            int d = sortData[this.face.func_176745_a()] >> i * 4 & 7;
            v[i] = this.getClosestVertex(d >> 2 & 1, d >> 1 & 1, d >> 0 & 1, this.vertices);
        }
        int[][] mapping = new int[][]{{324, 9028, 291, 17476, 4676, 836}, {324, 9028, 17476, 291, 836, 4676}, {9028, 324, 4676, 836, 291, 17476}, {324, 9028, 4676, 836, 17476, 291}, {291, 17476, 4676, 836, 324, 9028}, {17476, 291, 4676, 836, 9028, 324}};
        int[] map = mapping[this.face.func_176745_a()];
        v[this.nyb((int)map[0], (int)4)].x = v[this.nyb((int)map[0], (int)0)].x = (float)aabb.field_72340_a;
        v[this.nyb((int)map[0], (int)8)].x = v[this.nyb((int)map[0], (int)0)].x;
        v[this.nyb((int)map[0], (int)12)].x = v[this.nyb((int)map[0], (int)0)].x;
        v[this.nyb((int)map[1], (int)4)].x = v[this.nyb((int)map[1], (int)0)].x = (float)aabb.field_72336_d;
        v[this.nyb((int)map[1], (int)8)].x = v[this.nyb((int)map[1], (int)0)].x;
        v[this.nyb((int)map[1], (int)12)].x = v[this.nyb((int)map[1], (int)0)].x;
        v[this.nyb((int)map[2], (int)4)].y = v[this.nyb((int)map[2], (int)0)].y = (float)aabb.field_72338_b;
        v[this.nyb((int)map[2], (int)8)].y = v[this.nyb((int)map[2], (int)0)].y;
        v[this.nyb((int)map[2], (int)12)].y = v[this.nyb((int)map[2], (int)0)].y;
        v[this.nyb((int)map[3], (int)4)].y = v[this.nyb((int)map[3], (int)0)].y = (float)aabb.field_72337_e;
        v[this.nyb((int)map[3], (int)8)].y = v[this.nyb((int)map[3], (int)0)].y;
        v[this.nyb((int)map[3], (int)12)].y = v[this.nyb((int)map[3], (int)0)].y;
        v[this.nyb((int)map[4], (int)4)].z = v[this.nyb((int)map[4], (int)0)].z = (float)aabb.field_72339_c;
        v[this.nyb((int)map[4], (int)8)].z = v[this.nyb((int)map[4], (int)0)].z;
        v[this.nyb((int)map[4], (int)12)].z = v[this.nyb((int)map[4], (int)0)].z;
        v[this.nyb((int)map[5], (int)4)].z = v[this.nyb((int)map[5], (int)0)].z = (float)aabb.field_72334_f;
        v[this.nyb((int)map[5], (int)8)].z = v[this.nyb((int)map[5], (int)0)].z;
        v[this.nyb((int)map[5], (int)12)].z = v[this.nyb((int)map[5], (int)0)].z;
        switch (this.face) {
            case DOWN: {
                v[0].u = v[1].u = this.sprite.func_94214_a(aabb.field_72340_a * 16.0);
                v[2].u = v[3].u = this.sprite.func_94214_a(aabb.field_72336_d * 16.0);
                v[1].v = v[2].v = this.sprite.func_94207_b((1.0 - aabb.field_72339_c) * 16.0);
                v[0].v = v[3].v = this.sprite.func_94207_b((1.0 - aabb.field_72334_f) * 16.0);
                break;
            }
            case UP: {
                v[0].u = v[1].u = this.sprite.func_94214_a(aabb.field_72340_a * 16.0);
                v[2].u = v[3].u = this.sprite.func_94214_a(aabb.field_72336_d * 16.0);
                v[0].v = v[3].v = this.sprite.func_94207_b(aabb.field_72339_c * 16.0);
                v[1].v = v[2].v = this.sprite.func_94207_b(aabb.field_72334_f * 16.0);
                break;
            }
            case NORTH: {
                v[2].u = v[3].u = this.sprite.func_94214_a((1.0 - aabb.field_72340_a) * 16.0);
                v[0].u = v[1].u = this.sprite.func_94214_a((1.0 - aabb.field_72336_d) * 16.0);
                v[1].v = v[2].v = this.sprite.func_94207_b((1.0 - aabb.field_72338_b) * 16.0);
                v[0].v = v[3].v = this.sprite.func_94207_b((1.0 - aabb.field_72337_e) * 16.0);
                break;
            }
            case SOUTH: {
                v[0].u = v[1].u = this.sprite.func_94214_a(aabb.field_72340_a * 16.0);
                v[2].u = v[3].u = this.sprite.func_94214_a(aabb.field_72336_d * 16.0);
                v[1].v = v[2].v = this.sprite.func_94207_b((1.0 - aabb.field_72338_b) * 16.0);
                v[0].v = v[3].v = this.sprite.func_94207_b((1.0 - aabb.field_72337_e) * 16.0);
                break;
            }
            case WEST: {
                v[0].u = v[1].u = this.sprite.func_94214_a(aabb.field_72339_c * 16.0);
                v[2].u = v[3].u = this.sprite.func_94214_a(aabb.field_72334_f * 16.0);
                v[1].v = v[2].v = this.sprite.func_94207_b((1.0 - aabb.field_72338_b) * 16.0);
                v[0].v = v[3].v = this.sprite.func_94207_b((1.0 - aabb.field_72337_e) * 16.0);
                break;
            }
            case EAST: {
                v[2].u = v[3].u = this.sprite.func_94214_a((1.0 - aabb.field_72339_c) * 16.0);
                v[0].u = v[1].u = this.sprite.func_94214_a((1.0 - aabb.field_72334_f) * 16.0);
                v[1].v = v[2].v = this.sprite.func_94207_b((1.0 - aabb.field_72338_b) * 16.0);
                v[0].v = v[3].v = this.sprite.func_94207_b((1.0 - aabb.field_72337_e) * 16.0);
            }
        }
        return this;
    }

    private int nyb(int val, int shift) {
        return val >> shift & 0xF;
    }

    public UnpackedVertex getClosestVertex(float x, float y, float z, UnpackedVertex[] vertices) {
        float minDelta = 999.0f;
        UnpackedVertex minVert = null;
        for (UnpackedVertex vert : vertices) {
            float delX = vert.x - x;
            float delY = vert.y - y;
            float delZ = vert.z - z;
            float delta = delX * delX + delY * delY + delZ * delZ;
            if (!(delta < minDelta)) continue;
            minDelta = delta;
            minVert = vert;
        }
        return minVert;
    }
}

