/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.client.render.TESRDankNullDock;
import p455w0rd.danknull.init.ModGuiHandler;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.inventory.PlayerSlot;
import p455w0rd.danknull.items.ItemDankNull;
import p455w0rd.danknull.network.PacketEmptyDock;
import p455w0rd.danknull.network.PacketSetDankNullInDock;
import p455w0rdslib.api.client.IModelHolder;

public class BlockDankNullDock
extends BlockContainer
implements IModelHolder {
    public static final ResourceLocation REGISTRY_NAME = new ResourceLocation("danknull", "danknull_dock");

    public BlockDankNullDock() {
        super(Material.field_151573_f);
        this.func_149663_c(REGISTRY_NAME.func_110623_a());
        this.setRegistryName(REGISTRY_NAME);
        this.func_149752_b(6000000.0f);
        this.func_149711_c(10.0f);
        GameRegistry.registerTileEntity(TileDankNullDock.class, (ResourceLocation)REGISTRY_NAME);
        this.func_149713_g(255);
        this.field_149783_u = true;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.isEmpty(worldIn, pos) ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.isEmpty(source, pos) ? new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0) : new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileDankNullDock();
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileDankNullDock.class, (TileEntitySpecialRenderer)new TESRDankNullDock());
    }

    private TileDankNullDock getTE(IBlockAccess worldIn, BlockPos pos) {
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileDankNullDock) {
            return (TileDankNullDock)te;
        }
        return null;
    }

    private boolean isEmpty(IBlockAccess world, BlockPos pos) {
        TileDankNullDock te = this.getTE(world, pos);
        return te != null && te.getDankNull().func_190926_b();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_184102_h().func_175579_a(world, pos, player)) {
            return false;
        }
        TileDankNullDock dankDock = this.getTE((IBlockAccess)world, pos);
        if (dankDock != null) {
            PlayerSlot slot = PlayerSlot.getHand(player, hand);
            ItemStack stack = slot.getStackInSlot(player);
            if (dankDock.getDankNull().func_190926_b()) {
                if (ItemDankNull.isDankNull(stack)) {
                    dankDock.setDankNull(stack);
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                    ModNetworking.getInstance().sendToAllTracking((IMessage)new PacketSetDankNullInDock(dankDock, stack), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 128.0));
                    return true;
                }
            } else {
                if (stack.func_190926_b() && player.func_70093_af()) {
                    player.func_184611_a(hand, dankDock.getDankNull().func_77946_l());
                    dankDock.removeDankNull();
                    ModNetworking.getInstance().sendToAll((IMessage)new PacketEmptyDock(dankDock.func_174877_v()));
                    dankDock.func_70296_d();
                    return true;
                }
                if (!player.func_70093_af() && hand == EnumHand.MAIN_HAND) {
                    ModGuiHandler.launchGui(ModGuiHandler.GUIType.DANKNULL_TE, player, world, pos);
                    return true;
                }
            }
        }
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getItemBlockWithNBT(world.func_175625_s(pos));
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        stack = this.getItemBlockWithNBT(te);
        BlockDankNullDock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    private ItemStack getItemBlockWithNBT(@Nullable TileEntity te) {
        ItemStack stack = new ItemStack((Block)this);
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (te != null) {
            te.func_189515_b(nbttagcompound);
            stack.func_77983_a("BlockEntityTag", (NBTBase)nbttagcompound);
        }
        return stack;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isSideSolid(IBlockState base_state, IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }
}

