/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.recipes;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import p455w0rd.danknull.init.ModItems;
import p455w0rd.danknull.items.ItemDankNull;

public class RecipeDankNullUpgrade
extends IForgeRegistryEntry.Impl<IRecipe>
implements IShapedRecipe {
    public final NonNullList<Ingredient> recipeItems;

    public RecipeDankNullUpgrade(NonNullList<Ingredient> ingredients) {
        this.recipeItems = ingredients;
    }

    public String func_193358_e() {
        return "danknull:danknullupgrade";
    }

    public ItemStack func_77571_b() {
        return ItemDankNull.getTier(this.getInputDankNull()).getUpgradedVersion(this.getInputDankNull());
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList nonnulllist = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < nonnulllist.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            nonnulllist.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return nonnulllist;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.recipeItems;
    }

    public ItemStack getInputDankNull() {
        for (Ingredient item : this.func_192400_c()) {
            if (item.func_193365_a().length <= 0 || !ItemDankNull.isDankNull(item.func_193365_a()[0])) continue;
            return item.func_193365_a()[0];
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        for (int widthIndex = 0; widthIndex <= inv.func_174922_i() - this.getRecipeWidth(); ++widthIndex) {
            for (int heightIndex = 0; heightIndex <= inv.func_174923_h() - this.getRecipeHeight(); ++heightIndex) {
                if (!this.checkMatch(inv, widthIndex, heightIndex)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMatch(InventoryCrafting inventory, int widthIndexStart, int heightIndexStart) {
        for (int column = 0; column < 3; ++column) {
            for (int row = 0; row < 3; ++row) {
                int recipeColumn = column - widthIndexStart;
                int recipeRow = row - heightIndexStart;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (recipeColumn >= 0 && recipeRow >= 0 && recipeColumn < 3 && recipeRow < 3) {
                    ingredient = (Ingredient)this.recipeItems.get(recipeColumn + recipeRow * 3);
                }
                if (ingredient.apply(inventory.func_70463_b(column, row))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!ItemDankNull.isDankNull(inv.func_70301_a(i))) continue;
            NBTTagCompound oldNBT = inv.func_70301_a(i).func_77978_p();
            ItemStack newStack = this.getNewNextTierStack(inv.func_70301_a(i));
            newStack.func_77982_d(oldNBT);
            return newStack;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getNewNextTierStack(ItemStack dankNull) {
        int tier = ItemDankNull.getTier(dankNull).ordinal();
        if (tier < 5) {
            ItemDankNull item = null;
            switch (tier) {
                case 0: {
                    item = ModItems.LAPIS_DANKNULL;
                    break;
                }
                case 1: {
                    item = ModItems.IRON_DANKNULL;
                    break;
                }
                case 2: {
                    item = ModItems.GOLD_DANKNULL;
                    break;
                }
                case 3: {
                    item = ModItems.DIAMOND_DANKNULL;
                    break;
                }
                case 4: {
                    item = ModItems.EMERALD_DANKNULL;
                }
            }
            return new ItemStack((Item)item);
        }
        return ItemStack.field_190927_a;
    }

    public int getWidth() {
        return 3;
    }

    public int getHeight() {
        return 3;
    }

    public int getRecipeWidth() {
        return this.getWidth();
    }

    public int getRecipeHeight() {
        return this.getHeight();
    }
}

