/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import logisticspipes.blocks.stats.LogisticsStatisticsTileEntity;
import logisticspipes.blocks.stats.TrackingTask;
import logisticspipes.config.Configs;
import logisticspipes.gui.popup.GuiMessagePopup;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.AddItemToTrackPacket;
import logisticspipes.network.packets.block.RequestAmountTaskSubGui;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.GuiCheckBox;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.InputBar;
import logisticspipes.utils.gui.ItemDisplay;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.util.TextUtil;
import org.lwjgl.input.Keyboard;

public class GuiAddTracking
extends SubGuiScreen
implements IItemSearch {
    private static final String PREFIX = "gui.networkstatistics.add.";
    ItemDisplay itemDisplay;
    InputBar search;
    private final LogisticsStatisticsTileEntity tile;

    public GuiAddTracking(LogisticsStatisticsTileEntity tile) {
        super(160, 200, 0, 0);
        this.tile = tile;
    }

    @Override
    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(3, this.guiLeft + 4, this.bottom - 25, 50, 20, "Refresh"));
        this.field_146292_n.add(new GuiButton(0, this.right - 55, this.bottom - 25, 50, 20, "Add"));
        this.field_146292_n.add(new SmallGuiButton(1, this.right - 15, this.guiTop + 5, 10, 10, ">"));
        this.field_146292_n.add(new SmallGuiButton(2, this.right - 90, this.guiTop + 5, 10, 10, "<"));
        this.field_146292_n.add(new SmallGuiButton(20, this.xCenter - 13, this.bottom - 21, 26, 10, "Sort"));
        if (this.search == null) {
            this.search = new InputBar(this.field_146289_q, this.getBaseScreen(), this.guiLeft + 30, this.bottom - 78, this.right - this.guiLeft - 58, 15);
        }
        this.search.reposition(this.guiLeft + 10, this.bottom - 58, this.right - this.guiLeft - 20, 15);
        if (this.itemDisplay == null) {
            this.itemDisplay = new ItemDisplay(this, this.field_146289_q, this.getBaseScreen(), null, this.guiLeft + 10, this.guiTop + 18, this.xSize - 20, this.ySize - 100, 0, 0, 0, new int[]{1, 10, 64, 64}, true);
        }
        this.itemDisplay.reposition(this.guiLeft + 10, this.guiTop + 18, this.xSize - 20, this.ySize - 80, 0, 0);
    }

    @Override
    public void exitGui() {
        super.exitGui();
        Keyboard.enableRepeatEvents((boolean)false);
        this.getBaseScreen().func_73866_w_();
    }

    @Override
    protected void renderToolTips(int mouseX, int mouseY, float par3) {
        if (!super.hasSubGui()) {
            GuiGraphics.displayItemToolTip(this.itemDisplay.getToolTip(), (Gui)this, this.field_73735_i, 0, 0);
        }
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        this.itemDisplay.renderItemArea(this.field_73735_i);
    }

    @Override
    protected void renderGuiBackground(int mouseX, int mouseY) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.guiLeft, this.guiTop, this.right, this.bottom, this.field_73735_i, true);
        this.itemDisplay.renderPageNumber(this.right - 47, this.guiTop + 6);
        this.search.func_146194_f();
        this.itemDisplay.renderSortMode(this.xCenter, this.bottom - 32);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        if (guibutton.field_146127_k == 0 && this.itemDisplay.getSelectedItem() != null) {
            boolean found = false;
            for (TrackingTask task : this.tile.tasks) {
                if (!task.item.equals(this.itemDisplay.getSelectedItem().getItem())) continue;
                found = true;
                break;
            }
            if (found) {
                this.setSubGui(new GuiMessagePopup(TextUtil.translate("gui.networkstatistics.add.alreadytracked", new String[0])));
            } else {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(AddItemToTrackPacket.class).setItem(this.itemDisplay.getSelectedItem().getItem()).setTilePos(this.tile));
                TrackingTask task = new TrackingTask();
                task.item = this.itemDisplay.getSelectedItem().getItem();
                this.tile.tasks.add(task);
                this.exitGui();
            }
        } else if (guibutton.field_146127_k == 1) {
            this.itemDisplay.nextPage();
        } else if (guibutton.field_146127_k == 2) {
            this.itemDisplay.prevPage();
        } else if (guibutton.field_146127_k == 3) {
            this.refreshItems();
        } else if (guibutton.field_146127_k == 8) {
            GuiCheckBox button = (GuiCheckBox)guibutton;
            Configs.DISPLAY_POPUP = button.change();
            Configs.savePopupState();
        } else if (guibutton.field_146127_k == 20) {
            this.itemDisplay.cycle();
        }
        super.func_146284_a(guibutton);
    }

    private void refreshItems() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestAmountTaskSubGui.class).setTilePos(this.tile));
    }

    protected void func_73864_a(int i, int j, int k) throws IOException {
        this.itemDisplay.handleClick(i, j, k);
        this.search.handleClick(i, j, k);
        super.func_73864_a(i, j, k);
    }

    @Override
    protected void func_73869_a(char c, int i) {
        if (i == 201) {
            this.itemDisplay.prevPage();
        } else if (i == 209) {
            this.itemDisplay.nextPage();
        } else if (i == 1 || !this.search.handleKey(c, i)) {
            super.func_73869_a(c, i);
        }
    }

    public void handlePacket(List<ItemIdentifierStack> identList) {
        if (this.itemDisplay == null) {
            this.itemDisplay = new ItemDisplay(this, this.field_146289_q, this.getBaseScreen(), null, this.guiLeft + 10, this.guiTop + 18, this.xSize - 20, this.ySize - 100, 0, 0, 0, new int[]{1, 10, 64, 64}, true);
        }
        this.itemDisplay.setItemList(identList);
    }

    @Override
    public boolean itemSearched(ItemIdentifier item) {
        if (this.search.isEmpty()) {
            return true;
        }
        if (this.isSearched(item.getFriendlyName().toLowerCase(Locale.US), this.search.func_146179_b().toLowerCase(Locale.US))) {
            return true;
        }
        Map enchantIdLvlMap = EnchantmentHelper.func_82781_a((ItemStack)item.unsafeMakeNormalStack(1));
        for (Map.Entry e : enchantIdLvlMap.entrySet()) {
            String enchantName = ((Enchantment)e.getKey()).func_77320_a();
            if (enchantName == null || !this.isSearched(enchantName.toLowerCase(Locale.US), this.search.func_146179_b().toLowerCase(Locale.US))) continue;
            return true;
        }
        return false;
    }

    private boolean isSearched(String value, String search) {
        boolean flag = true;
        for (String s : search.split(" ")) {
            if (value.contains(s)) continue;
            flag = false;
            break;
        }
        return flag;
    }
}

