/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.kotlin.Unit;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.computers.interfaces.CCCommand;
import logisticspipes.proxy.computers.interfaces.CCType;
import logisticspipes.proxy.computers.interfaces.ILPCCTypeHolder;
import logisticspipes.proxy.computers.objects.CCSinkResponder;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.IStore;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.property.Property;
import network.rs485.logisticspipes.property.PropertyHolder;
import network.rs485.logisticspipes.property.UtilKt;

@CCType(name="LogisticsModule")
public abstract class LogisticsModule
implements IStore,
ILPCCTypeHolder,
PropertyHolder {
    private final Object[] ccTypeHolder = new Object[1];
    @Nullable
    protected IWorldProvider _world;
    @Nullable
    protected IPipeServiceProvider _service;
    protected ModulePositionType slot;
    protected int positionInt;
    protected boolean initialized;

    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
        this._world = world;
        this._service = service;
    }

    @Nonnull
    public abstract String getLPName();

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return Collections.emptyList();
    }

    public void registerPosition(@Nonnull ModulePositionType slot, int positionInt) {
        this.slot = slot;
        this.positionInt = positionInt;
    }

    @Nonnull
    public BlockPos getBlockPos() {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            if (LogisticsPipes.isDEBUG()) {
                throw new IllegalStateException("Module has no service, but getBlockPos was called");
            }
            return BlockPos.field_177992_a;
        }
        if (this.slot.isInWorld()) {
            return service.getPos();
        }
        if (LogisticsPipes.isDEBUG()) {
            throw new IllegalStateException("Module is not in world, but getBlockPos was called");
        }
        return BlockPos.field_177992_a;
    }

    @Nullable
    public World getWorld() {
        IWorldProvider worldProvider = this._world;
        if (worldProvider == null) {
            return null;
        }
        return worldProvider.getWorld();
    }

    public ModulePositionType getSlot() {
        return this.slot;
    }

    public int getPositionInt() {
        return this.positionInt;
    }

    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        return null;
    }

    public abstract void tick();

    public abstract boolean hasGenericInterests();

    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemIdentifiers) {
    }

    public abstract boolean interestedInAttachedInventory();

    public abstract boolean interestedInUndamagedID();

    public abstract boolean receivePassive();

    public boolean hasEffect() {
        return false;
    }

    public List<CCSinkResponder> queueCCSinkEvent(ItemIdentifierStack item) {
        return new ArrayList<CCSinkResponder>(0);
    }

    @CCCommand(description="Returns true if the Pipe has a gui")
    public boolean hasGui() {
        return this instanceof Gui;
    }

    @Nonnull
    public LogisticsModule getModule() {
        return this;
    }

    @Nonnull
    protected ISlotUpgradeManager getUpgradeManager() {
        return Objects.requireNonNull(this._service, "service object was null in " + this).getUpgradeManager(this.slot, this.positionInt);
    }

    public String toString() {
        String at = "{service is null}";
        if (this._service != null) {
            at = Objects.toString(this._service.getPos());
        }
        String in = "{world is null}";
        if (this._world != null) {
            in = Objects.toString(this._world.getWorld());
        }
        return String.format("%s at %s in %s", this.getClass().getName(), at, in);
    }

    @Override
    public Object[] getTypeHolder() {
        return this.ccTypeHolder;
    }

    public void finishInit() {
        if (this.initialized) {
            if (LogisticsPipes.isTesting()) {
                throw new IllegalStateException("finishInit called on initialized " + this.getClass().getName());
            }
            if (LogisticsPipes.isDEBUG()) {
                System.err.println("finishInit called on initialized " + this.getClass().getName());
                new Exception().printStackTrace();
            }
            return;
        }
        if (this._service != null) {
            World blockAccess = this._world == null ? null : this._world.getWorld();
            MainProxy.runOnServer((IBlockAccess)blockAccess, () -> () -> UtilKt.addObserver(this.getProperties(), prop -> {
                this._service.markTileDirty();
                return Unit.INSTANCE;
            }));
        }
        this.initialized = true;
    }

    public static enum ModulePositionType {
        SLOT(true),
        IN_HAND(false),
        IN_PIPE(true);

        private final boolean inWorld;

        private ModulePositionType(boolean inWorld) {
            this.inWorld = inWorld;
        }

        public boolean isInWorld() {
            return this.inWorld;
        }
    }
}

