/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import com.google.common.collect.ImmutableList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.DelayQueue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.interfaces.IGuiOpenControler;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.ISlotUpgradeManager;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IItemSpaceControl;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logistics.LogisticsManager;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.abstractpackets.ModuleCoordinatesPacket;
import logisticspipes.network.guis.module.inhand.CraftingModuleInHand;
import logisticspipes.network.guis.module.inpipe.CraftingModuleSlot;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImport;
import logisticspipes.network.packets.cpipe.CPipeSatelliteImportBack;
import logisticspipes.network.packets.cpipe.CraftingPipeOpenConnectedGuiPacket;
import logisticspipes.network.packets.hud.HUDStartModuleWatchingPacket;
import logisticspipes.network.packets.hud.HUDStopModuleWatchingPacket;
import logisticspipes.network.packets.pipe.CraftingPipeUpdatePacket;
import logisticspipes.network.packets.pipe.FluidCraftingAmount;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.PipeFluidSatellite;
import logisticspipes.pipes.PipeItemsSatelliteLogistics;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.proxy.interfaces.IFuzzyRecipeProvider;
import logisticspipes.request.DictCraftingTemplate;
import logisticspipes.request.ICraftingTemplate;
import logisticspipes.request.IPromise;
import logisticspipes.request.IReqCraftingTemplate;
import logisticspipes.request.ItemCraftingTemplate;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.DictResource;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsDictPromise;
import logisticspipes.routing.LogisticsExtraDictPromise;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsItemOrder;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.CacheHolder;
import logisticspipes.utils.DelayedGeneric;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.connection.AdjacentUtilKt;
import network.rs485.logisticspipes.connection.LPNeighborTileEntityKt;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.inventory.IItemIdentifierInventory;
import network.rs485.logisticspipes.module.Gui;
import network.rs485.logisticspipes.property.BitSetProperty;
import network.rs485.logisticspipes.property.BooleanProperty;
import network.rs485.logisticspipes.property.IBitSet;
import network.rs485.logisticspipes.property.IntListProperty;
import network.rs485.logisticspipes.property.IntegerProperty;
import network.rs485.logisticspipes.property.ItemIdentifierInventoryProperty;
import network.rs485.logisticspipes.property.Property;
import network.rs485.logisticspipes.property.UUIDListProperty;
import network.rs485.logisticspipes.property.UUIDProperty;
import network.rs485.logisticspipes.property.UUIDPropertyKt;
import network.rs485.logisticspipes.util.FuzzyUtil;

public class ModuleCrafter
extends LogisticsModule
implements ICraftItems,
IHUDModuleHandler,
IModuleWatchReciver,
IGuiOpenControler,
Gui {
    public final ItemIdentifierInventoryProperty dummyInventory = new ItemIdentifierInventoryProperty(new ItemIdentifierInventory(11, "Requested items", 127), "");
    public final ItemIdentifierInventoryProperty liquidInventory = new ItemIdentifierInventoryProperty(new ItemIdentifierInventory(3, "Fluid items", 1, true), "FluidInv");
    public final ItemIdentifierInventoryProperty cleanupInventory = new ItemIdentifierInventoryProperty(new ItemIdentifierInventory(12, "Cleanup Filter Items", 1), "CleanupInv");
    public final UUIDProperty satelliteUUID = new UUIDProperty(null, "satelliteUUID");
    public final UUIDListProperty advancedSatelliteUUIDList = new UUIDListProperty("advancedSatelliteUUIDList");
    public final UUIDProperty liquidSatelliteUUID = new UUIDProperty(null, "liquidSatelliteId");
    public final UUIDListProperty liquidSatelliteUUIDList = new UUIDListProperty("liquidSatelliteUUIDList");
    public final IntegerProperty priority = new IntegerProperty(0, "priority");
    public final IntListProperty liquidAmounts = new IntListProperty("FluidAmount");
    public final BooleanProperty cleanupModeIsExclude = new BooleanProperty(true, "cleanupModeIsExclude");
    public final BitSetProperty fuzzyFlags = new BitSetProperty(new BitSet(40), "fuzzyBitSet");
    private final List<Property<?>> properties = ImmutableList.builder().add((Object)this.dummyInventory).add((Object)this.liquidInventory).add((Object)this.cleanupInventory).add((Object)this.satelliteUUID).add((Object)this.advancedSatelliteUUIDList).add((Object)this.liquidSatelliteUUID).add((Object)this.liquidSatelliteUUIDList).add((Object)this.priority).add((Object)this.liquidAmounts).add((Object)this.cleanupModeIsExclude).add((Object)this.fuzzyFlags).build();
    protected final DelayQueue<DelayedGeneric<Pair<ItemIdentifierStack, IAdditionalTargetInformation>>> _lostItems = new DelayQueue();
    protected final PlayerCollectionList localModeWatchers = new PlayerCollectionList();
    protected final PlayerCollectionList guiWatcher = new PlayerCollectionList();
    public ClientSideSatelliteNames clientSideSatelliteNames = new ClientSideSatelliteNames();
    protected SinkReply _sinkReply;
    @Nullable
    private IRequestItems _invRequester;
    private WeakReference<TileEntity> lastAccessedCrafter = new WeakReference<Object>(null);
    private boolean cachedAreAllOrderesToBuffer;
    private UpgradeSatelliteFromIDs updateSatelliteFromIDs = null;

    public ModuleCrafter() {
        this.advancedSatelliteUUIDList.ensureSize(9);
        this.liquidAmounts.ensureSize(3);
        this.liquidSatelliteUUIDList.ensureSize(3);
    }

    public static String getName() {
        return "crafter";
    }

    @Override
    @Nonnull
    public String getLPName() {
        return ModuleCrafter.getName();
    }

    @Override
    @Nonnull
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @Override
    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
        super.registerHandler(world, service);
        this._invRequester = (IRequestItems)((Object)service);
    }

    @Override
    public void registerPosition(@Nonnull LogisticsModule.ModulePositionType slot, int positionInt) {
        super.registerPosition(slot, positionInt);
        this._sinkReply = new SinkReply(SinkReply.FixedPriority.ItemSink, 0, true, false, 1, 0, new PipeLogisticsChassis.ChassiTargetInformation(this.getPositionInt()));
    }

    @Override
    public SinkReply sinksItem(@Nonnull ItemStack stack, ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit, boolean forcePassive) {
        if (bestPriority > this._sinkReply.fixedPriority.ordinal() || bestPriority == this._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= this._sinkReply.customPriority) {
            return null;
        }
        int itemCount = this.spaceFor(stack, item, includeInTransit);
        if (itemCount > 0) {
            return new SinkReply(this._sinkReply, itemCount, this.areAllOrderesToBuffer() ? SinkReply.BufferMode.DESTINATION_BUFFERED : SinkReply.BufferMode.NONE);
        }
        return null;
    }

    protected int spaceFor(@Nonnull ItemStack stack, ItemIdentifier item, boolean includeInTransit) {
        Pair<String, ItemIdentifier> key = new Pair<String, ItemIdentifier>("spaceFor", item);
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return 0;
        }
        Object cache2 = service.getCacheHolder().getCacheFor(CacheHolder.CacheTypes.Inventory, key);
        int onRoute = 0;
        if (includeInTransit) {
            onRoute = service.countOnRoute(item);
        }
        if (cache2 != null) {
            return (Integer)cache2 - onRoute;
        }
        if (includeInTransit) {
            stack = stack.func_77946_l();
            stack.func_190917_f(onRoute);
        }
        ISlotUpgradeManager upgradeManager = Objects.requireNonNull(this.getUpgradeManager());
        ItemStack finalStack = stack;
        Integer count2 = AdjacentUtilKt.sneakyInventoryUtils(service.getAvailableAdjacent(), upgradeManager).stream().map(invUtil -> invUtil.roomForItem(finalStack)).reduce(Integer::sum).orElse(0);
        service.getCacheHolder().setCache(CacheHolder.CacheTypes.Inventory, key, count2);
        return count2 - onRoute;
    }

    private UUID getUUIDForSatelliteName(String name) {
        for (PipeItemsSatelliteLogistics pipe : PipeItemsSatelliteLogistics.AllSatellites) {
            if (!pipe.getSatellitePipeName().equals(name)) continue;
            return pipe.getRouter().getId();
        }
        return null;
    }

    private UUID getUUIDForFluidSatelliteName(String name) {
        for (PipeFluidSatellite pipe : PipeFluidSatellite.AllSatellites) {
            if (!pipe.getSatellitePipeName().equals(name)) continue;
            return pipe.getRouter().getId();
        }
        return null;
    }

    @Override
    public void tick() {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return;
        }
        this.enabledUpdateEntity();
        if (this.updateSatelliteFromIDs != null && service.isNthTick(100)) {
            UUID uuid;
            UUID uuid2;
            int i;
            boolean canBeRemoved;
            if (this.updateSatelliteFromIDs.advancedSatelliteIdArray != null) {
                canBeRemoved = true;
                for (i = 0; i < this.updateSatelliteFromIDs.advancedSatelliteIdArray.length; ++i) {
                    if (this.updateSatelliteFromIDs.advancedSatelliteIdArray[i] == -1) continue;
                    uuid2 = this.getUUIDForSatelliteName(Integer.toString(this.updateSatelliteFromIDs.advancedSatelliteIdArray[i]));
                    if (uuid2 != null) {
                        this.updateSatelliteFromIDs.advancedSatelliteIdArray[i] = -1;
                        this.advancedSatelliteUUIDList.set(i, uuid2);
                        continue;
                    }
                    canBeRemoved = false;
                }
                if (canBeRemoved) {
                    this.updateSatelliteFromIDs.advancedSatelliteIdArray = null;
                }
            }
            if (this.updateSatelliteFromIDs.liquidSatelliteIdArray != null) {
                canBeRemoved = true;
                for (i = 0; i < this.updateSatelliteFromIDs.liquidSatelliteIdArray.length; ++i) {
                    if (this.updateSatelliteFromIDs.liquidSatelliteIdArray[i] == -1) continue;
                    uuid2 = this.getUUIDForFluidSatelliteName(Integer.toString(this.updateSatelliteFromIDs.liquidSatelliteIdArray[i]));
                    if (uuid2 != null) {
                        this.updateSatelliteFromIDs.liquidSatelliteIdArray[i] = -1;
                        this.liquidSatelliteUUIDList.set(i, uuid2);
                        continue;
                    }
                    canBeRemoved = false;
                }
                if (canBeRemoved) {
                    this.updateSatelliteFromIDs.liquidSatelliteIdArray = null;
                }
            }
            if (this.updateSatelliteFromIDs.liquidSatelliteId != -1 && (uuid = this.getUUIDForFluidSatelliteName(Integer.toString(this.updateSatelliteFromIDs.liquidSatelliteId))) != null) {
                this.updateSatelliteFromIDs.liquidSatelliteId = -1;
                this.liquidSatelliteUUID.setValue(uuid);
            }
            if (this.updateSatelliteFromIDs.satelliteId != -1 && (uuid = this.getUUIDForFluidSatelliteName(Integer.toString(this.updateSatelliteFromIDs.satelliteId))) != null) {
                this.updateSatelliteFromIDs.satelliteId = -1;
                this.satelliteUUID.setValue(uuid);
            }
            if (this.updateSatelliteFromIDs.advancedSatelliteIdArray == null && this.updateSatelliteFromIDs.liquidSatelliteId == -1 && this.updateSatelliteFromIDs.liquidSatelliteIdArray == null && this.updateSatelliteFromIDs.satelliteId == -1) {
                this.updateSatelliteFromIDs = null;
            }
        }
        if (this._lostItems.isEmpty()) {
            return;
        }
        DelayedGeneric lostItem = (DelayedGeneric)this._lostItems.poll();
        int reRequested = 0;
        while (lostItem != null && reRequested < 100) {
            SinkReply reply;
            Pair pair = (Pair)lostItem.get();
            if (service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING) && ((reply = LogisticsManager.canSink(((ItemIdentifierStack)pair.getValue1()).makeNormalStack(), this.getRouter(), null, true, ((ItemIdentifierStack)pair.getValue1()).getItem(), null, true, true, false)) == null || reply.maxNumberOfItems < 1)) {
                this._lostItems.add(new DelayedGeneric<Pair>(pair, 9000 + (int)(Math.random() * 2000.0)));
                lostItem = (DelayedGeneric)this._lostItems.poll();
                continue;
            }
            int received = RequestTree.requestPartial((ItemIdentifierStack)pair.getValue1(), (CoreRoutedPipe)service, (IAdditionalTargetInformation)pair.getValue2());
            ++reRequested;
            if (received < ((ItemIdentifierStack)pair.getValue1()).getStackSize()) {
                ((ItemIdentifierStack)pair.getValue1()).setStackSize(((ItemIdentifierStack)pair.getValue1()).getStackSize() - received);
                this._lostItems.add(new DelayedGeneric<Pair>(pair, 4500 + (int)(Math.random() * 1000.0)));
            }
            lostItem = (DelayedGeneric)this._lostItems.poll();
        }
    }

    @Override
    public void itemArrived(ItemIdentifierStack item, IAdditionalTargetInformation info) {
    }

    @Override
    public void itemLost(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        this._lostItems.add(new DelayedGeneric<Pair<ItemIdentifierStack, IAdditionalTargetInformation>>(new Pair<ItemIdentifierStack, IAdditionalTargetInformation>(item, info), 5000L));
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemIdentifiers) {
        List<ItemIdentifierStack> result2 = this.getCraftedItems();
        if (result2 == null) {
            return;
        }
        result2.stream().map(ItemIdentifierStack::getItem).forEach(itemIdentifiers::add);
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean receivePassive() {
        return false;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filters) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return;
        }
        if (!service.getItemOrderManager().hasExtras() || tree.hasBeenQueried(service.getItemOrderManager())) {
            return;
        }
        IResource requestedItem = tree.getRequestType();
        if (!this.canCraft(requestedItem)) {
            return;
        }
        for (IFilter iFilter : filters) {
            if (iFilter.isBlocked() != iFilter.isFilteredItem(requestedItem) && !iFilter.blockProvider()) continue;
            return;
        }
        int remaining = 0;
        for (LogisticsItemOrder extra : service.getItemOrderManager()) {
            if (extra.getType() != IOrderInfoProvider.ResourceType.EXTRA || !extra.getResource().getItem().equals(requestedItem.getAsItem())) continue;
            remaining += extra.getResource().stack.getStackSize();
        }
        ItemIdentifierStack itemIdentifierStack = this.getCraftedItem();
        if (itemIdentifierStack == null) {
            return;
        }
        if ((remaining -= root.getAllPromissesFor(this, itemIdentifierStack.getItem())) < 1) {
            return;
        }
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzy().nextSetBit(0) != -1) {
            DictResource dict = new DictResource(itemIdentifierStack, null).loadFromBitSet(this.outputFuzzy().copyValue());
            LogisticsExtraDictPromise promise = new LogisticsExtraDictPromise(dict, Math.min(remaining, tree.getMissingAmount()), (IProvideItems)this, true);
            tree.addPromise(promise);
        } else {
            LogisticsExtraPromise promise = new LogisticsExtraPromise(itemIdentifierStack.getItem(), Math.min(remaining, tree.getMissingAmount()), (IProvideItems)this, true);
            tree.addPromise(promise);
        }
        tree.setQueried(service.getItemOrderManager());
    }

    @Override
    public LogisticsItemOrder fullFill(LogisticsPromise promise, IRequestItems destination, IAdditionalTargetInformation info) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return null;
        }
        if (promise instanceof LogisticsExtraDictPromise) {
            service.getItemOrderManager().removeExtras(((LogisticsExtraDictPromise)promise).getResource());
        }
        if (promise instanceof LogisticsExtraPromise) {
            service.getItemOrderManager().removeExtras(new DictResource(new ItemIdentifierStack(promise.item, promise.numberOfItems), null));
        }
        if (promise instanceof LogisticsDictPromise) {
            service.spawnParticle(Particles.WhiteParticle, 2);
            return service.getItemOrderManager().addOrder(((LogisticsDictPromise)promise).getResource(), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
        }
        service.spawnParticle(Particles.WhiteParticle, 2);
        return service.getItemOrderManager().addOrder(new ItemIdentifierStack(promise.item, promise.numberOfItems), destination, IOrderInfoProvider.ResourceType.CRAFTING, info);
    }

    @Override
    public void getAllItems(Map<ItemIdentifier, Integer> list, List<IFilter> filter2) {
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        return Objects.requireNonNull(this._service, "service was null").getRouter();
    }

    @Override
    public void itemCouldNotBeSend(ItemIdentifierStack item, IAdditionalTargetInformation info) {
        Objects.requireNonNull(this._invRequester).itemCouldNotBeSend(item, info);
    }

    @Override
    public int compareTo(@Nonnull IRequestItems other) {
        return Integer.compare(this.getID(), other.getID());
    }

    @Override
    public int getID() {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return -1;
        }
        return service.getRouter().getSimpleID();
    }

    @Override
    public void registerExtras(IPromise promise) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return;
        }
        if (promise instanceof LogisticsDictPromise) {
            service.getItemOrderManager().addExtra(((LogisticsDictPromise)promise).getResource());
        } else {
            ItemIdentifierStack stack = new ItemIdentifierStack(promise.getItemType(), promise.getAmount());
            service.getItemOrderManager().addExtra(new DictResource(stack, null));
        }
    }

    @Override
    public ICraftingTemplate addCrafting(IResource toCraft) {
        int i;
        int i2;
        List<ItemIdentifierStack> stack = this.getCraftedItems();
        if (stack == null) {
            return null;
        }
        IReqCraftingTemplate template = null;
        if (this.getUpgradeManager().isFuzzyUpgrade() && this.outputFuzzy().nextSetBit(0) != -1) {
            for (ItemIdentifierStack craftable : stack) {
                DictResource dict = new DictResource(craftable, null);
                dict.loadFromBitSet(this.outputFuzzy().copyValue());
                if (!toCraft.matches(dict, IResource.MatchSettings.NORMAL)) continue;
                template = new DictCraftingTemplate(dict, this, (Integer)this.priority.getValue());
                break;
            }
        } else {
            for (ItemIdentifierStack craftable : stack) {
                if (!toCraft.matches(craftable.getItem(), IResource.MatchSettings.NORMAL)) continue;
                template = new ItemCraftingTemplate(craftable, this, (Integer)this.priority.getValue());
                break;
            }
        }
        if (template == null) {
            return null;
        }
        IRequestItems[] target = new IRequestItems[9];
        for (i2 = 0; i2 < 9; ++i2) {
            target[i2] = this;
        }
        if (!this.isSatelliteConnected()) {
            return null;
        }
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            IRouter r = this.getSatelliteRouter(-1);
            if (r != null) {
                CoreRoutedPipe sat = r.getPipe();
                for (i = 6; i < 9; ++i) {
                    target[i] = sat;
                }
            }
        } else {
            for (i2 = 0; i2 < 9; ++i2) {
                IRouter r = this.getSatelliteRouter(i2);
                if (r == null) continue;
                target[i2] = r.getPipe();
            }
        }
        for (int i3 = 0; i3 < 9; ++i3) {
            IResource req;
            ItemIdentifierStack resourceStack = this.dummyInventory.getIDStackInSlot(i3);
            if (resourceStack == null || resourceStack.getStackSize() == 0) continue;
            if (this.getUpgradeManager().isFuzzyUpgrade() && this.inputFuzzy(i3).nextSetBit(0) != -1) {
                DictResource dict = new DictResource(resourceStack, target[i3]);
                req = dict;
                dict.loadFromBitSet(this.inputFuzzy(i3).copyValue());
            } else {
                req = new ItemResource(resourceStack, target[i3]);
            }
            template.addRequirement(req, new CraftingChassisInformation(i3, this.getPositionInt()));
        }
        int liquidCrafter = this.getUpgradeManager().getFluidCrafter();
        IRequestFluid[] liquidTarget = new IRequestFluid[liquidCrafter];
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            IRouter r = this.getFluidSatelliteRouter(-1);
            if (r != null) {
                IRequestFluid sat = (IRequestFluid)((Object)r.getPipe());
                for (int i4 = 0; i4 < liquidCrafter; ++i4) {
                    liquidTarget[i4] = sat;
                }
            }
        } else {
            for (i = 0; i < liquidCrafter; ++i) {
                IRouter r = this.getFluidSatelliteRouter(i);
                if (r == null) continue;
                liquidTarget[i] = (IRequestFluid)((Object)r.getPipe());
            }
        }
        for (int i5 = 0; i5 < liquidCrafter; ++i5) {
            FluidIdentifier liquid = this.getFluidMaterial(i5);
            int amount = (Integer)this.liquidAmounts.get(i5);
            if (liquid == null || amount <= 0 || liquidTarget[i5] == null) continue;
            template.addRequirement(new FluidResource(liquid, amount, liquidTarget[i5]), null);
        }
        if (this.getUpgradeManager().hasByproductExtractor() && this.getByproductItem() != null) {
            template.addByproduct(this.getByproductItem());
        }
        return template;
    }

    public boolean isSatelliteConnected() {
        if (!this.getUpgradeManager().isAdvancedSatelliteCrafter()) {
            if (this.satelliteUUID.isZero()) {
                return true;
            }
            int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID((UUID)this.satelliteUUID.getValue());
            if (satelliteRouterId != -1) {
                List<ExitRoute> rt = this.getRouter().getRouteTable().get(satelliteRouterId);
                return rt != null && !rt.isEmpty();
            }
        } else {
            boolean foundAll = true;
            for (int i = 0; i < 9; ++i) {
                List<ExitRoute> rt;
                boolean foundOne = false;
                if (this.advancedSatelliteUUIDList.isZero(i)) continue;
                int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID((UUID)this.advancedSatelliteUUIDList.get(i));
                if (satelliteRouterId != -1 && (rt = this.getRouter().getRouteTable().get(satelliteRouterId)) != null && !rt.isEmpty()) {
                    foundOne = true;
                }
                foundAll &= foundOne;
            }
            return foundAll;
        }
        return false;
    }

    @Override
    public boolean canCraft(IResource toCraft) {
        if (this.getCraftedItem() == null) {
            return false;
        }
        if (toCraft instanceof ItemResource || toCraft instanceof DictResource) {
            return toCraft.matches(this.getCraftedItem().getItem(), IResource.MatchSettings.NORMAL);
        }
        return false;
    }

    @Override
    @Deprecated
    public List<ItemIdentifierStack> getCraftedItems() {
        ArrayList<ItemIdentifierStack> list = new ArrayList<ItemIdentifierStack>(1);
        if (this.getCraftedItem() != null) {
            list.add(this.getCraftedItem());
        }
        return list;
    }

    @Nullable
    public ItemIdentifierStack getCraftedItem() {
        return this.dummyInventory.getIDStackInSlot(9);
    }

    @Override
    public int getTodo() {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return 0;
        }
        return service.getItemOrderManager().totalAmountCountInAllOrders();
    }

    private IRouter getSatelliteRouter(int x) {
        UUID satelliteUUID = x == -1 ? (UUID)this.satelliteUUID.getValue() : (UUID)this.advancedSatelliteUUIDList.get(x);
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(satelliteUUID);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    @Override
    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        int i;
        super.readFromNBT(tag);
        for (i = 0; i < 9; ++i) {
            String advancedSatelliteUUIDArrayString = tag.func_74779_i("advancedSatelliteUUID" + i);
            if (advancedSatelliteUUIDArrayString.isEmpty()) continue;
            this.advancedSatelliteUUIDList.set(i, UUID.fromString(advancedSatelliteUUIDArrayString));
        }
        for (i = 0; i < 3; ++i) {
            String liquidSatelliteUUIDArrayString = tag.func_74779_i("liquidSatelliteUUIDArray" + i);
            if (liquidSatelliteUUIDArrayString.isEmpty()) continue;
            this.liquidSatelliteUUIDList.set(i, UUID.fromString(liquidSatelliteUUIDArrayString));
        }
        if (tag.func_74764_b("fuzzyFlags")) {
            NBTTagList lst = tag.func_150295_c("fuzzyFlags", 10);
            for (int i2 = 0; i2 < 9; ++i2) {
                FuzzyUtil.INSTANCE.readFromNBT(this.inputFuzzy(i2), lst.func_150305_b(i2));
            }
        }
        if (tag.func_74764_b("outputFuzzyFlags")) {
            FuzzyUtil.INSTANCE.readFromNBT(this.outputFuzzy(), tag.func_74775_l("outputFuzzyFlags"));
        }
        if (tag.func_74764_b("satelliteid")) {
            int i3;
            this.updateSatelliteFromIDs = new UpgradeSatelliteFromIDs();
            this.updateSatelliteFromIDs.satelliteId = tag.func_74762_e("satelliteid");
            for (i3 = 0; i3 < 9; ++i3) {
                this.updateSatelliteFromIDs.advancedSatelliteIdArray[i3] = tag.func_74762_e("advancedSatelliteId" + i3);
            }
            for (i3 = 0; i3 < 3; ++i3) {
                this.updateSatelliteFromIDs.liquidSatelliteIdArray[i3] = tag.func_74762_e("liquidSatelliteIdArray" + i3);
            }
            this.updateSatelliteFromIDs.liquidSatelliteId = tag.func_74762_e("liquidSatelliteId");
        }
    }

    public IBitSet outputFuzzy() {
        int startIdx = 36;
        return this.fuzzyFlags.get(36, 39);
    }

    public IBitSet inputFuzzy(int slot) {
        int startIdx = 4 * slot;
        return this.fuzzyFlags.get(startIdx, startIdx + 3);
    }

    public ModernPacket getCPipePacket() {
        return PacketHandler.getPacket(CraftingPipeUpdatePacket.class).setAmount(this.liquidAmounts.getArray()).setLiquidSatelliteNameArray(this.getSatelliteNamesForUUIDs(this.liquidSatelliteUUIDList)).setLiquidSatelliteName(this.getSatelliteNameForUUID((UUID)this.liquidSatelliteUUID.getValue())).setSatelliteName(this.getSatelliteNameForUUID((UUID)this.satelliteUUID.getValue())).setAdvancedSatelliteNameArray(this.getSatelliteNamesForUUIDs(this.advancedSatelliteUUIDList)).setPriority((Integer)this.priority.getValue()).setModulePos(this);
    }

    private String getSatelliteNameForUUID(UUID uuid) {
        if (UUIDPropertyKt.isZero(uuid)) {
            return "";
        }
        int simpleId = SimpleServiceLocator.routerManager.getIDforUUID(uuid);
        IRouter router = SimpleServiceLocator.routerManager.getRouter(simpleId);
        if (router != null) {
            CoreRoutedPipe pipe = router.getPipe();
            if (pipe instanceof PipeItemsSatelliteLogistics) {
                return ((PipeItemsSatelliteLogistics)pipe).getSatellitePipeName();
            }
            if (pipe instanceof PipeFluidSatellite) {
                return ((PipeFluidSatellite)pipe).getSatellitePipeName();
            }
        }
        return "UNKNOWN NAME";
    }

    private String[] getSatelliteNamesForUUIDs(UUIDListProperty list) {
        return (String[])list.stream().map(this::getSatelliteNameForUUID).toArray(String[]::new);
    }

    public void handleCraftingUpdatePacket(CraftingPipeUpdatePacket packet) {
        if (!MainProxy.isClient((IBlockAccess)this.getWorld())) {
            throw new UnsupportedOperationException();
        }
        this.liquidAmounts.replaceContent(packet.getAmount());
        this.clientSideSatelliteNames.liquidSatelliteNameArray = packet.getLiquidSatelliteNameArray();
        this.clientSideSatelliteNames.liquidSatelliteName = packet.getLiquidSatelliteName();
        this.clientSideSatelliteNames.satelliteName = packet.getSatelliteName();
        this.clientSideSatelliteNames.advancedSatelliteNameArray = packet.getAdvancedSatelliteNameArray();
        this.priority.setValue(packet.getPriority());
    }

    @Override
    @Nonnull
    public ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(CraftingModuleSlot.class).setAdvancedSat(this.getUpgradeManager().isAdvancedSatelliteCrafter()).setLiquidCrafter(this.getUpgradeManager().getFluidCrafter()).setAmount(this.liquidAmounts.getArray()).setHasByproductExtractor(this.getUpgradeManager().hasByproductExtractor()).setFuzzy(this.getUpgradeManager().isFuzzyUpgrade()).setCleanupSize(this.getUpgradeManager().getCrafterCleanup()).setCleanupExclude((Boolean)this.cleanupModeIsExclude.getValue());
    }

    @Override
    @Nonnull
    public ModuleInHandGuiProvider getInHandGuiProvider() {
        return NewGuiHandler.getGui(CraftingModuleInHand.class).setAmount(this.liquidAmounts.getArray()).setCleanupExclude((Boolean)this.cleanupModeIsExclude.getValue());
    }

    public void importFromCraftingTable(@Nullable EntityPlayer player) {
        if (MainProxy.isClient((IBlockAccess)this.getWorld())) {
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeSatelliteImport.class).setModulePos(this);
            MainProxy.sendPacketToServer(packet);
        } else {
            IPipeServiceProvider service = this._service;
            if (service == null) {
                return;
            }
            service.getAvailableAdjacent().neighbors().keySet().stream().flatMap(neighbor -> SimpleServiceLocator.craftingRecipeProviders.stream().filter(provider -> provider.importRecipe((TileEntity)neighbor.getTileEntity(), this.dummyInventory)).map(provider1 -> new Pair<NeighborTileEntity, ICraftingRecipeProvider>((NeighborTileEntity)neighbor, (ICraftingRecipeProvider)provider1))).findFirst().ifPresent(neighborProviderPair -> {
                if (neighborProviderPair.getValue2() instanceof IFuzzyRecipeProvider) {
                    ((IFuzzyRecipeProvider)neighborProviderPair.getValue2()).importFuzzyFlags((TileEntity)((NeighborTileEntity)neighborProviderPair.getValue1()).getTileEntity(), this.dummyInventory.getSlotAccess(), this.fuzzyFlags);
                }
            });
            ModuleCoordinatesPacket packet = PacketHandler.getPacket(CPipeSatelliteImportBack.class).setInventory(this.dummyInventory).setModulePos(this);
            if (player != null) {
                MainProxy.sendPacketToPlayer(packet, player);
            }
            MainProxy.sendPacketToAllWatchingChunk(this, (ModernPacket)packet);
        }
    }

    public ItemIdentifierStack getByproductItem() {
        return this.dummyInventory.getIDStackInSlot(10);
    }

    public FluidIdentifier getFluidMaterial(int slotnr) {
        ItemIdentifierStack stack = this.liquidInventory.getIDStackInSlot(slotnr);
        if (stack == null) {
            return null;
        }
        return FluidIdentifier.get(stack.getItem());
    }

    public void changeFluidAmount(int change, int slot, EntityPlayer player) {
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(FluidCraftingAmount.class).setInteger2(slot).setInteger(change).setModulePos(this));
        } else {
            this.liquidAmounts.increase(slot, change);
            if ((Integer)this.liquidAmounts.get(slot) <= 0) {
                this.liquidAmounts.set(slot, 0);
            }
            MainProxy.sendPacketToPlayer(PacketHandler.getPacket(FluidCraftingAmount.class).setInteger2(slot).setInteger((Integer)this.liquidAmounts.get(slot)).setModulePos(this), player);
        }
    }

    private IRouter getFluidSatelliteRouter(int x) {
        UUID liquidSatelliteUUID = x == -1 ? (UUID)this.liquidSatelliteUUID.getValue() : (UUID)this.liquidSatelliteUUIDList.get(x);
        int satelliteRouterId = SimpleServiceLocator.routerManager.getIDforUUID(liquidSatelliteUUID);
        return SimpleServiceLocator.routerManager.getRouter(satelliteRouterId);
    }

    public boolean openAttachedGui(EntityPlayer player) {
        boolean guiOpened;
        int i;
        if (MainProxy.isClient((IBlockAccess)player.field_70170_p)) {
            if (player instanceof EntityPlayerMP) {
                player.func_71053_j();
            } else if (player instanceof EntityPlayerSP) {
                player.func_71053_j();
            }
            MainProxy.sendPacketToServer(PacketHandler.getPacket(CraftingPipeOpenConnectedGuiPacket.class).setModulePos(this));
            return false;
        }
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return false;
        }
        IWorldProvider worldProvider = this._world;
        if (worldProvider == null) {
            return false;
        }
        int savedEquipped = player.field_71071_by.field_70461_c;
        boolean foundSlot = false;
        for (i = 0; i < 9; ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_190926_b()) continue;
            foundSlot = true;
            player.field_71071_by.field_70461_c = i;
            break;
        }
        if (!foundSlot) {
            for (i = 0; i < 9; ++i) {
                ItemStack is = player.field_71071_by.func_70301_a(i);
                if (!(is.func_77973_b() instanceof ItemBlock)) continue;
                foundSlot = true;
                player.field_71071_by.field_70461_c = i;
                break;
            }
        }
        if (!foundSlot) {
            player.field_71071_by.field_70461_c = (player.field_71071_by.field_70461_c + 1) % 9;
        }
        if (!(guiOpened = service.getAvailableAdjacent().neighbors().keySet().stream().anyMatch(neighbor -> {
            if (neighbor.canHandleItems() || SimpleServiceLocator.craftingRecipeProviders.stream().anyMatch(provider -> provider.canOpenGui((TileEntity)neighbor.getTileEntity()))) {
                BlockPos pos = neighbor.getTileEntity().func_174877_v();
                IBlockState blockState = worldProvider.getWorld().func_180495_p(pos);
                return !blockState.func_177230_c().isAir(blockState, (IBlockAccess)worldProvider.getWorld(), pos) && blockState.func_177230_c().func_180639_a(worldProvider.getWorld(), pos, neighbor.getTileEntity().func_145831_w().func_180495_p(pos), player, EnumHand.MAIN_HAND, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
            }
            return false;
        }))) {
            LogisticsPipes.log.warn("Ignored open attached GUI request at " + player.field_70170_p + " @ " + this.getBlockPos());
        }
        player.field_71071_by.field_70461_c = savedEquipped;
        return guiOpened;
    }

    public void enabledUpdateEntity() {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return;
        }
        if (service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            if (service.isNthTick(6)) {
                this.cacheAreAllOrderesToBuffer();
            }
            if (service.getItemOrderManager().isFirstOrderWatched()) {
                TileEntity tile = (TileEntity)this.lastAccessedCrafter.get();
                if (tile != null) {
                    service.getItemOrderManager().setMachineProgress(SimpleServiceLocator.machineProgressProvider.getProgressForTile(tile));
                } else {
                    service.getItemOrderManager().setMachineProgress((byte)0);
                }
            }
        } else {
            this.cachedAreAllOrderesToBuffer = false;
        }
        if (!service.isNthTick(6)) {
            return;
        }
        List<NeighborTileEntity<TileEntity>> adjacentInventories = service.getAvailableAdjacent().inventories();
        if (!service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            ISlotUpgradeManager upgradeManager = Objects.requireNonNull(this.getUpgradeManager());
            if (upgradeManager.getCrafterCleanup() > 0) {
                adjacentInventories.stream().map(neighbor -> this.extractFiltered((NeighborTileEntity<TileEntity>)neighbor, this.cleanupInventory, (Boolean)this.cleanupModeIsExclude.getValue(), upgradeManager.getCrafterCleanup() * 3)).filter(stack -> !stack.func_190926_b()).findFirst().ifPresent(extracted -> {
                    service.queueRoutedItem(SimpleServiceLocator.routedItemHelper.createNewTravelItem((ItemStack)extracted), EnumFacing.UP);
                    service.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
                });
            }
            return;
        }
        if (adjacentInventories.size() < 1) {
            if (service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
                service.getItemOrderManager().sendFailed();
            }
            return;
        }
        List<ItemIdentifierStack> wantedItem = this.getCraftedItems();
        if (wantedItem == null || wantedItem.isEmpty()) {
            return;
        }
        service.spawnParticle(Particles.VioletParticle, 2);
        int itemsLeft = this.itemsToExtract();
        int stacksLeft = this.stacksToExtract();
        block0: while (itemsLeft > 0 && stacksLeft > 0 && service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
            NeighborTileEntity<TileEntity> adjacentCrafter;
            LogisticsItemOrder nextOrder = (LogisticsItemOrder)service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA);
            int maxToSend = Math.min(itemsLeft, nextOrder.getResource().stack.getStackSize());
            maxToSend = Math.min(nextOrder.getResource().getItem().getMaxStackSize(), maxToSend);
            ItemStack extracted2 = ItemStack.field_190927_a;
            NeighborTileEntity<TileEntity> adjacent = null;
            Iterator<NeighborTileEntity<TileEntity>> iterator2 = adjacentInventories.iterator();
            while (iterator2.hasNext() && (extracted2 = this.extract(adjacent = (adjacentCrafter = iterator2.next()), nextOrder.getResource(), maxToSend)).func_190926_b()) {
            }
            if (extracted2.func_190926_b()) {
                service.getItemOrderManager().deferSend();
                break;
            }
            service.getCacheHolder().trigger(CacheHolder.CacheTypes.Inventory);
            Objects.requireNonNull(adjacent);
            this.lastAccessedCrafter = new WeakReference<TileEntity>(adjacent.getTileEntity());
            ItemIdentifier extractedID = ItemIdentifier.get(extracted2);
            while (!extracted2.func_190926_b()) {
                if (this.isExtractedMismatch(nextOrder, extractedID)) {
                    LogisticsItemOrder startOrder = nextOrder;
                    if (service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) {
                        do {
                            service.getItemOrderManager().deferSend();
                        } while (this.isExtractedMismatch(nextOrder = (LogisticsItemOrder)service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA), extractedID) && startOrder != nextOrder);
                    }
                    if (startOrder == nextOrder) {
                        int numToSend = Math.min(extracted2.func_190916_E(), extractedID.getMaxStackSize());
                        if (numToSend == 0) continue block0;
                        --stacksLeft;
                        itemsLeft -= numToSend;
                        ItemStack stackToSend = extracted2.func_77979_a(numToSend);
                        service.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, null, adjacent.getDirection());
                        continue;
                    }
                }
                int numToSend = Math.min(extracted2.func_190916_E(), extractedID.getMaxStackSize());
                if ((numToSend = Math.min(numToSend, nextOrder.getResource().stack.getStackSize())) == 0) continue block0;
                --stacksLeft;
                itemsLeft -= numToSend;
                ItemStack stackToSend = extracted2.func_77979_a(numToSend);
                if (nextOrder.getDestination() != null) {
                    SinkReply reply = LogisticsManager.canSink(stackToSend, nextOrder.getDestination().getRouter(), null, true, ItemIdentifier.get(stackToSend), null, true, false);
                    boolean deferSend = reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1;
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stackToSend);
                    item.setDestination(nextOrder.getDestination().getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    item.setAdditionalTargetInformation(nextOrder.getInformation());
                    service.queueRoutedItem(item, adjacent.getDirection());
                    service.getItemOrderManager().sendSuccessfull(stackToSend.func_190916_E(), deferSend, item);
                } else {
                    service.sendStack(stackToSend, -1, CoreRoutedPipe.ItemSendMode.Normal, nextOrder.getInformation(), adjacent.getDirection());
                    service.getItemOrderManager().sendSuccessfull(stackToSend.func_190916_E(), false, null);
                }
                if (!service.getItemOrderManager().hasOrders(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA)) continue;
                nextOrder = (LogisticsItemOrder)service.getItemOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.CRAFTING, IOrderInfoProvider.ResourceType.EXTRA);
            }
        }
    }

    private boolean isExtractedMismatch(LogisticsItemOrder nextOrder, ItemIdentifier extractedID) {
        return !nextOrder.getResource().getItem().equals(extractedID) && (!this.getUpgradeManager().isFuzzyUpgrade() || nextOrder.getResource().getBitSet().nextSetBit(0) == -1 || !nextOrder.getResource().matches(extractedID, IResource.MatchSettings.NORMAL));
    }

    public boolean areAllOrderesToBuffer() {
        return this.cachedAreAllOrderesToBuffer;
    }

    public void cacheAreAllOrderesToBuffer() {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return;
        }
        boolean result2 = true;
        for (LogisticsItemOrder order : service.getItemOrderManager()) {
            if (order.getDestination() instanceof IItemSpaceControl) {
                SinkReply reply = LogisticsManager.canSink(order.getResource().stack.makeNormalStack(), order.getDestination().getRouter(), null, true, order.getResource().getItem(), null, true, false);
                if (reply == null || reply.bufferMode != SinkReply.BufferMode.NONE || reply.maxNumberOfItems < 1) continue;
                result2 = false;
                break;
            }
            result2 = false;
            break;
        }
        this.cachedAreAllOrderesToBuffer = result2;
    }

    @Nonnull
    private ItemStack extract(NeighborTileEntity<TileEntity> adjacent, IResource item, int amount) {
        return LPNeighborTileEntityKt.optionalIs(adjacent, LogisticsCraftingTableTileEntity.class).map(adjacentCraftingTable -> this.extractFromLogisticsCraftingTable((NeighborTileEntity<LogisticsCraftingTableTileEntity>)adjacentCraftingTable, item, amount)).orElseGet(() -> {
            IInventoryUtil invUtil = LPNeighborTileEntityKt.getInventoryUtil(adjacent);
            if (invUtil == null) {
                return ItemStack.field_190927_a;
            }
            return this.extractFromInventory(invUtil, item, amount);
        });
    }

    @Nonnull
    private ItemStack extractFiltered(NeighborTileEntity<TileEntity> neighbor, IItemIdentifierInventory inv, boolean isExcluded, int filterInvLimit) {
        IInventoryUtil invUtil = LPNeighborTileEntityKt.getInventoryUtil(neighbor);
        if (invUtil == null) {
            return ItemStack.field_190927_a;
        }
        return this.extractFromInventoryFiltered(invUtil, inv, isExcluded, filterInvLimit);
    }

    @Nonnull
    private ItemStack extractFromInventory(@Nonnull IInventoryUtil invUtil, IResource wantedItem, int count2) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return ItemStack.field_190927_a;
        }
        ItemIdentifier itemToExtract = null;
        if (wantedItem instanceof ItemResource) {
            itemToExtract = ((ItemResource)wantedItem).getItem();
        } else if (wantedItem instanceof DictResource) {
            int max = Integer.MIN_VALUE;
            ItemIdentifier toExtract = null;
            for (Map.Entry<ItemIdentifier, Integer> content : invUtil.getItemsAndCount().entrySet()) {
                if (!wantedItem.matches(content.getKey(), IResource.MatchSettings.NORMAL) || content.getValue() <= max) continue;
                max = content.getValue();
                toExtract = content.getKey();
            }
            if (toExtract == null) {
                return ItemStack.field_190927_a;
            }
            itemToExtract = toExtract;
        }
        if (itemToExtract == null) {
            return ItemStack.field_190927_a;
        }
        int available = invUtil.itemCount(itemToExtract);
        if (available == 0 || !service.canUseEnergy(this.neededEnergy() * Math.min(count2, available))) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = invUtil.getMultipleItems(itemToExtract, Math.min(count2, available));
        service.useEnergy(this.neededEnergy() * extracted.func_190916_E());
        return extracted;
    }

    @Nonnull
    private ItemStack extractFromInventoryFiltered(@Nonnull IInventoryUtil invUtil, IItemIdentifierInventory filter2, boolean isExcluded, int filterInvLimit) {
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return ItemStack.field_190927_a;
        }
        ItemIdentifier wantedItem = null;
        boolean found = false;
        for (ItemIdentifier item : invUtil.getItemsAndCount().keySet()) {
            found = this.isFiltered(filter2, filterInvLimit, item, found);
            if (isExcluded == found) continue;
            wantedItem = item;
            break;
        }
        if (wantedItem == null) {
            return ItemStack.field_190927_a;
        }
        int available = invUtil.itemCount(wantedItem);
        if (available == 0 || !service.canUseEnergy(this.neededEnergy() * Math.min(64, available))) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = invUtil.getMultipleItems(wantedItem, Math.min(64, available));
        service.useEnergy(this.neededEnergy() * extracted.func_190916_E());
        return extracted;
    }

    private boolean isFiltered(IItemIdentifierInventory filter2, int filterInvLimit, ItemIdentifier item, boolean found) {
        for (int i = 0; i < filter2.func_70302_i_() && i < filterInvLimit; ++i) {
            ItemIdentifierStack identStack = filter2.getIDStackInSlot(i);
            if (identStack == null || !identStack.getItem().equalsWithoutNBT(item)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Nonnull
    private ItemStack extractFromLogisticsCraftingTable(NeighborTileEntity<LogisticsCraftingTableTileEntity> adjacentCraftingTable, IResource wantedItem, int count2) {
        ItemStack stack;
        IPipeServiceProvider service = this._service;
        if (service == null) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = this.extractFromInventory(Objects.requireNonNull(LPNeighborTileEntityKt.getInventoryUtil(adjacentCraftingTable)), wantedItem, count2);
        if (!extracted.func_190926_b()) {
            return extracted;
        }
        ItemStack retStack = ItemStack.field_190927_a;
        while (count2 > 0 && !(stack = adjacentCraftingTable.getTileEntity().getOutput(wantedItem, service)).func_190926_b() && !(!retStack.func_190926_b() ? !retStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)retStack, (ItemStack)stack) : !wantedItem.matches(ItemIdentifier.get(stack), wantedItem instanceof ItemResource ? IResource.MatchSettings.WITHOUT_NBT : IResource.MatchSettings.NORMAL)) && service.useEnergy(this.neededEnergy() * stack.func_190916_E())) {
            if (retStack.func_190926_b()) {
                retStack = stack;
            } else {
                retStack.func_190917_f(stack.func_190916_E());
            }
            count2 -= stack.func_190916_E();
            if (!Objects.requireNonNull(this.getUpgradeManager()).isFuzzyUpgrade()) continue;
            break;
        }
        return retStack;
    }

    protected int neededEnergy() {
        return (int)(10.0 * Math.pow(1.1, this.getUpgradeManager().getItemExtractionUpgrade()) * Math.pow(1.2, this.getUpgradeManager().getItemStackExtractionUpgrade()));
    }

    protected int itemsToExtract() {
        return (int)Math.pow(2.0, this.getUpgradeManager().getItemExtractionUpgrade());
    }

    protected int stacksToExtract() {
        return 1 + this.getUpgradeManager().getItemStackExtractionUpgrade();
    }

    public void importCleanup() {
        int i;
        for (i = 0; i < 10; ++i) {
            ItemIdentifierStack identStack = this.dummyInventory.getIDStackInSlot(i);
            if (identStack == null) {
                this.cleanupInventory.clearInventorySlotContents(i);
                continue;
            }
            this.cleanupInventory.setInventorySlotContents(i, new ItemIdentifierStack(identStack));
        }
        for (i = 10; i < this.cleanupInventory.func_70302_i_(); ++i) {
            this.cleanupInventory.clearInventorySlotContents(i);
        }
        this.cleanupInventory.getSlotAccess().compactFirst(10);
        this.cleanupInventory.recheckStackLimit();
        this.cleanupModeIsExclude.setValue(false);
    }

    @Override
    public void startHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStartModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void stopHUDWatching() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(HUDStopModuleWatchingPacket.class).setModulePos(this));
    }

    @Override
    public void startWatching(EntityPlayer player) {
        this.localModeWatchers.add(player);
    }

    @Override
    public void stopWatching(EntityPlayer player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getHUDRenderer() {
        return null;
    }

    private void updateSatellitesOnClient() {
        MainProxy.sendToPlayerList(this.getCPipePacket(), this.guiWatcher);
    }

    public void setSatelliteUUID(@Nullable UUID pipeID) {
        if (pipeID == null) {
            this.satelliteUUID.zero();
        } else {
            this.satelliteUUID.setValue(pipeID);
        }
        this.updateSatellitesOnClient();
        this.updateSatelliteFromIDs = null;
    }

    public void setAdvancedSatelliteUUID(int i, @Nullable UUID pipeID) {
        if (pipeID == null) {
            this.advancedSatelliteUUIDList.zero(i);
        } else {
            this.advancedSatelliteUUIDList.set(i, pipeID);
        }
        this.updateSatellitesOnClient();
        this.updateSatelliteFromIDs = null;
    }

    public void setFluidSatelliteUUID(@Nullable UUID pipeID) {
        if (pipeID == null) {
            this.liquidSatelliteUUID.zero();
        } else {
            this.liquidSatelliteUUID.setValue(pipeID);
        }
        this.updateSatellitesOnClient();
        this.updateSatelliteFromIDs = null;
    }

    public void setAdvancedFluidSatelliteUUID(int i, @Nullable UUID pipeID) {
        if (pipeID == null) {
            this.liquidSatelliteUUIDList.zero(i);
        } else {
            this.liquidSatelliteUUIDList.set(i, pipeID);
        }
        this.updateSatellitesOnClient();
        this.updateSatelliteFromIDs = null;
    }

    @Override
    public void guiOpenedByPlayer(EntityPlayer player) {
        this.guiWatcher.add(player);
    }

    @Override
    public void guiClosedByPlayer(EntityPlayer player) {
        this.guiWatcher.remove(player);
    }

    public boolean hasByproductUpgrade() {
        return this.getUpgradeManager().hasByproductExtractor();
    }

    public boolean hasFuzzyUpgrade() {
        return this.getUpgradeManager().isFuzzyUpgrade();
    }

    public static class ClientSideSatelliteNames {
        @Nonnull
        public String satelliteName = "";
        @Nonnull
        public String[] advancedSatelliteNameArray = new String[0];
        @Nonnull
        public String liquidSatelliteName = "";
        @Nonnull
        public String[] liquidSatelliteNameArray = new String[0];
    }

    private static class UpgradeSatelliteFromIDs {
        public int satelliteId;
        public int[] advancedSatelliteIdArray = new int[9];
        public int[] liquidSatelliteIdArray = new int[3];
        public int liquidSatelliteId;

        private UpgradeSatelliteFromIDs() {
        }
    }

    public static class CraftingChassisInformation
    extends PipeLogisticsChassis.ChassiTargetInformation {
        private final int craftingSlot;

        public CraftingChassisInformation(int craftingSlot, int moduleSlot) {
            super(moduleSlot);
            this.craftingSlot = craftingSlot;
        }

        public int getCraftingSlot() {
            return this.craftingSlot;
        }
    }
}

