/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.abstractpackets;

import logisticspipes.LogisticsPipes;
import logisticspipes.items.ItemModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.exception.TargetNotFoundException;
import logisticspipes.pipes.PipeLogisticsChassis;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.gui.DummyModuleContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public abstract class ModuleCoordinatesPacket
extends CoordinatesPacket {
    private LogisticsModule.ModulePositionType type;
    private int positionInt;
    private boolean moduleBased = false;

    public ModuleCoordinatesPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.type != null);
        if (this.type != null) {
            output.writeEnum(this.type);
            output.writeInt(this.positionInt);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        if (input.readBoolean()) {
            this.type = input.readEnum(LogisticsModule.ModulePositionType.class);
            this.positionInt = input.readInt();
        }
    }

    public ModuleCoordinatesPacket setModulePos(LogisticsModule module) {
        this.type = module.getSlot();
        this.positionInt = module.getPositionInt();
        if (this.type.isInWorld()) {
            this.setBlockPos(module.getBlockPos());
        }
        return this;
    }

    public ModuleCoordinatesPacket setPacketPos(ModuleCoordinatesPacket packet) {
        this.type = packet.type;
        this.positionInt = packet.positionInt;
        super.setPacketPos(packet);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getLogisticsModule(EntityPlayer player, Class<T> clazz) {
        LogisticsModule module;
        if (this.type == LogisticsModule.ModulePositionType.IN_PIPE) {
            this.moduleBased = true;
            LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_(), CoordinatesPacket.LTGPCompletionCheck.NONE);
            this.moduleBased = false;
            if (!(pipe.pipe instanceof CoreRoutedPipe)) {
                throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", pipe didn't exsist", this);
            }
            module = ((CoreRoutedPipe)pipe.pipe).getLogisticsModule();
        } else if (this.type == LogisticsModule.ModulePositionType.IN_HAND) {
            if (MainProxy.isServer((IBlockAccess)player.func_130014_f_())) {
                if (player.field_71070_bA instanceof DummyModuleContainer) {
                    DummyModuleContainer dummy = (DummyModuleContainer)player.field_71070_bA;
                    module = dummy.getModule();
                } else {
                    if (!(player.field_71070_bA instanceof ContainerPlayer)) throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", no DummyModuleContainer open and the player is in another GUI", this);
                    module = ItemModule.getLogisticsModule(player, this.getPositionInt());
                    if (module == null) {
                        throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", module not found at slot " + this.getPositionInt(), this);
                    }
                }
            } else {
                module = MainProxy.proxy.getModuleFromGui();
                if (module == null) {
                    module = ItemModule.getLogisticsModule(player, this.getPositionInt());
                }
                if (module == null) {
                    throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", GUI didn't provide the module and module not found at slot " + this.getPositionInt(), this);
                }
            }
        } else {
            this.moduleBased = true;
            LogisticsTileGenericPipe pipe = this.getPipe(player.func_130014_f_(), CoordinatesPacket.LTGPCompletionCheck.NONE);
            this.moduleBased = false;
            if (!(pipe.pipe instanceof CoreRoutedPipe)) {
                throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", pipe didn't exsist", this);
            }
            if (!pipe.isInitialized()) {
                return null;
            }
            if (!(pipe.pipe instanceof PipeLogisticsChassis)) {
                throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", pipe wasn't a chassi pipe", this);
            }
            module = ((PipeLogisticsChassis)pipe.pipe).getSubModule(this.positionInt);
        }
        if (module == null) throw new TargetNotFoundException("Couldn't find " + clazz.getName(), this);
        if (clazz.isAssignableFrom(module.getClass())) return (T)module;
        throw new TargetNotFoundException("Couldn't find " + clazz.getName() + ", found " + module.getClass(), this);
    }

    @Override
    public <T> T getTileAs(World world, Class<T> clazz) {
        if (LogisticsPipes.isDEBUG() && !this.moduleBased && this.type != null) {
            new Exception("ModulePacket was asked for a pipe").printStackTrace();
        }
        return super.getTileAs(world, clazz);
    }

    public LogisticsModule.ModulePositionType getType() {
        return this.type;
    }

    public ModuleCoordinatesPacket setType(LogisticsModule.ModulePositionType type) {
        this.type = type;
        return this;
    }

    public int getPositionInt() {
        return this.positionInt;
    }

    public ModuleCoordinatesPacket setPositionInt(int positionInt) {
        this.positionInt = positionInt;
        return this;
    }
}

