/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.block;

import java.util.BitSet;
import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.gui.GuiLogisticsCraftingTable;
import logisticspipes.network.abstractguis.CoordinatesGuiProvider;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class AutoCraftingGui
extends CoordinatesGuiProvider {
    boolean isFuzzy;
    BitSet fuzzyFlags = new BitSet(36);
    ItemIdentifier targetType;

    public AutoCraftingGui(int id) {
        super(id);
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        LogisticsCraftingTableTileEntity tile = this.getTileAs(player.field_70170_p, LogisticsCraftingTableTileEntity.class);
        if (tile.isFuzzy()) {
            tile.fuzzyFlags.replaceWith(this.fuzzyFlags);
        }
        tile.targetType = this.targetType;
        return new GuiLogisticsCraftingTable(player, tile);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        LogisticsCraftingTableTileEntity tile = this.getTileAs(player.field_70170_p, LogisticsCraftingTableTileEntity.class);
        DummyContainer dummy = new DummyContainer(player, tile.matrix, tile);
        for (int X = 0; X < 3; ++X) {
            for (int Y = 0; Y < 3; ++Y) {
                dummy.addFuzzyDummySlot(Y * 3 + X, 35 + X * 18, 10 + Y * 18, tile.inputFuzzy(Y * 3 + X));
            }
        }
        dummy.addFuzzyUnmodifiableSlot(0, tile.resultInv, 125, 28, tile.outputFuzzy());
        for (int Y = 0; Y < 2; ++Y) {
            for (int X = 0; X < 9; ++X) {
                dummy.addNormalSlot(Y * 9 + X, tile.inv, 8 + X * 18, 80 + Y * 18);
            }
        }
        dummy.addNormalSlotsForPlayerInventory(8, 135);
        return dummy;
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeItemIdentifier(this.targetType);
        output.writeBoolean(this.isFuzzy);
        if (this.isFuzzy) {
            output.writeBitSet(this.fuzzyFlags);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.targetType = input.readItemIdentifier();
        if (input.readBoolean()) {
            this.fuzzyFlags = input.readBitSet();
        }
    }

    public AutoCraftingGui setCraftingTable(LogisticsCraftingTableTileEntity tile) {
        this.setTilePos(tile);
        if (tile.isFuzzy()) {
            this.isFuzzy = true;
            this.fuzzyFlags = tile.fuzzyFlags.copyValue(0, 35);
        }
        this.targetType = tile.targetType;
        return this;
    }

    @Override
    public GuiProvider template() {
        return new AutoCraftingGui(this.getId());
    }
}

