/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.orderer;

import logisticspipes.interfaces.IRequestWatcher;
import logisticspipes.network.abstractpackets.IntegerCoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ResourceNetwork;
import logisticspipes.routing.order.LinkedLogisticsOrderList;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class OrdererWatchPacket
extends IntegerCoordinatesPacket {
    private IResource stack;
    private LinkedLogisticsOrderList orders;

    public OrdererWatchPacket(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        ResourceNetwork.writeResource(output, this.stack);
        output.writeSerializable(this.orders);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.stack = ResourceNetwork.readResource(input);
        this.orders = new LinkedLogisticsOrderList(input);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.field_70170_p);
        if (tile.pipe instanceof IRequestWatcher) {
            ((IRequestWatcher)((Object)tile.pipe)).handleClientSideListInfo(this.getInteger(), this.getStack(), this.getOrders());
        }
    }

    @Override
    public ModernPacket template() {
        return new OrdererWatchPacket(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public IResource getStack() {
        return this.stack;
    }

    public OrdererWatchPacket setStack(IResource stack) {
        this.stack = stack;
        return this;
    }

    public LinkedLogisticsOrderList getOrders() {
        return this.orders;
    }

    public OrdererWatchPacket setOrders(LinkedLogisticsOrderList orders) {
        this.orders = orders;
        return this;
    }
}

