/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.packets.pipe.PipeDebugResponse;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.client.FMLClientHandler;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;

@StaticResolve
public class PipeDebugAskForTarget
extends ModernPacket {
    private boolean isServer;

    public PipeDebugAskForTarget(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInput input) {
        this.isServer = input.readBoolean();
    }

    @Override
    public void processPacket(EntityPlayer player) {
        RayTraceResult box = FMLClientHandler.instance().getClient().field_71476_x;
        if (box != null && box.field_72313_a == RayTraceResult.Type.BLOCK) {
            if (!this.isServer) {
                TileEntity tile = new DoubleCoordinates(box.func_178782_a()).getTileEntity((IBlockAccess)player.func_130014_f_());
                if (tile instanceof LogisticsTileGenericPipe) {
                    boolean bl = ((LogisticsTileGenericPipe)tile).pipe.debug.debugThisPipe = !((LogisticsTileGenericPipe)tile).pipe.debug.debugThisPipe;
                    if (((LogisticsTileGenericPipe)tile).pipe.debug.debugThisPipe) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Debug enabled On Client"));
                    } else {
                        player.func_145747_a((ITextComponent)new TextComponentString("Debug disabled On Client"));
                    }
                }
            } else {
                MainProxy.sendPacketToServer(PacketHandler.getPacket(PipeDebugResponse.class).setBlockPos(box.func_178782_a()));
            }
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeBoolean(this.isServer);
    }

    @Override
    public ModernPacket template() {
        return new PipeDebugAskForTarget(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public PipeDebugAskForTarget setServer(boolean isServer) {
        this.isServer = isServer;
        return this;
    }

    public boolean isServer() {
        return this.isServer;
    }
}

