/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.pipe;

import java.util.Objects;
import javax.annotation.Nonnull;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import network.rs485.logisticspipes.property.PropertyHolder;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class PipePropertiesUpdate
extends CoordinatesPacket {
    @Nonnull
    public NBTTagCompound tag = new NBTTagCompound();

    public PipePropertiesUpdate(int id) {
        super(id);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeNBTTagCompound(this.tag);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.tag = Objects.requireNonNull(input.readNBTTagCompound(), "read null NBT in PipePropertiesUpdate");
    }

    @Override
    public ModernPacket template() {
        return new PipePropertiesUpdate(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsTileGenericPipe tile = this.getPipe(player.func_130014_f_(), CoordinatesPacket.LTGPCompletionCheck.PIPE);
        if (!(tile.pipe instanceof PropertyHolder)) {
            return;
        }
        tile.pipe.readFromNBT(this.tag);
        MainProxy.runOnServer((IBlockAccess)player.field_70170_p, () -> () -> MainProxy.sendPacketToPlayer(PipePropertiesUpdate.fromPropertyHolder((PropertyHolder)((Object)tile.pipe)).setPacketPos(this), player));
    }

    @Nonnull
    public static PipePropertiesUpdate fromPropertyHolder(PropertyHolder holder) {
        PipePropertiesUpdate packet = PacketHandler.getPacket(PipePropertiesUpdate.class);
        holder.writeToNBT(packet.tag);
        return packet;
    }
}

