/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.ISpecialTankAccessHandler;
import logisticspipes.interfaces.ISpecialTankUtil;
import logisticspipes.interfaces.ITankUtil;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideFluids;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.PipeFluidUtil;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.routing.FluidLogisticsPromise;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsFluidOrder;
import logisticspipes.textures.Textures;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

public class PipeFluidProvider
extends FluidRoutedPipe
implements IProvideFluids {
    public PipeFluidProvider(Item item) {
        super(item);
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (!this.getFluidOrderManager().hasOrders(IOrderInfoProvider.ResourceType.PROVIDER) || !this.isNthTick(6)) {
            return;
        }
        LogisticsFluidOrder order = (LogisticsFluidOrder)this.getFluidOrderManager().peekAtTopRequest(IOrderInfoProvider.ResourceType.PROVIDER);
        AtomicInteger amountToSend = new AtomicInteger();
        AtomicInteger attemptedAmount = new AtomicInteger();
        amountToSend.set(Math.min(order.getAmount(), 5000));
        attemptedAmount.set(Math.min(order.getAmount(), 5000));
        for (Pair<NeighborTileEntity<TileEntity>, ITankUtil> pair : PipeFluidUtil.INSTANCE.getAdjacentTanks(this, false)) {
            if (amountToSend.get() <= 0) break;
            boolean fallback = true;
            if (pair.getValue2() instanceof ISpecialTankUtil) {
                ISpecialTankUtil util = (ISpecialTankUtil)pair.getValue2();
                fallback = false;
                ISpecialTankAccessHandler handler = util.getSpecialHandler();
                FluidStack drained = handler.drainFrom(pair.getValue1().getTileEntity(), order.getFluid(), amountToSend.get(), false);
                if (drained != null && drained.amount > 0 && order.getFluid().equals(FluidIdentifier.get(drained))) {
                    drained = handler.drainFrom(pair.getValue1().getTileEntity(), order.getFluid(), amountToSend.get(), true);
                    int amount = drained.amount;
                    amountToSend.addAndGet(-amount);
                    ItemIdentifierStack stack = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(FluidIdentifierStack.getFromStack(drained));
                    LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
                    item.setDestination(order.getRouter().getSimpleID());
                    item.setTransportMode(IRoutedItem.TransportMode.Active);
                    this.queueRoutedItem(item, pair.getValue1().getDirection());
                    this.getFluidOrderManager().sendSuccessfull(amount, false, item);
                    if (amountToSend.get() <= 0) break;
                }
            }
            if (!fallback || !pair.getValue2().containsTanks()) continue;
            pair.getValue2().tanks().map(tank -> FluidIdentifierStack.getFromStack(tank.getContents())).forEach(fluidStack -> {
                if (amountToSend.get() <= 0) {
                    return;
                }
                if (fluidStack != null && fluidStack.getFluid() != null && order.getFluid().equals(fluidStack.getFluid())) {
                    int amount = Math.min(fluidStack.getAmount(), amountToSend.get());
                    FluidIdentifierStack drained = ((ITankUtil)pair.getValue2()).drain(amount, false);
                    if (drained != null && drained.getAmount() > 0 && order.getFluid().equals(drained.getFluid())) {
                        FluidIdentifierStack addition;
                        drained = ((ITankUtil)pair.getValue2()).drain(amount, true);
                        while (drained.getAmount() < amountToSend.get() && (addition = ((ITankUtil)pair.getValue2()).drain(amountToSend.get() - drained.getAmount(), false)) != null && addition.getAmount() > 0 && order.getFluid().equals(addition.getFluid())) {
                            addition = ((ITankUtil)pair.getValue2()).drain(amountToSend.get() - drained.getAmount(), true);
                            drained.raiseAmount(addition.getAmount());
                        }
                        amount = drained.getAmount();
                        amountToSend.addAndGet(-amount);
                        ItemIdentifierStack stack = SimpleServiceLocator.logisticsFluidManager.getFluidContainer(drained);
                        LPTravelingItem.LPTravelingItemServer item = SimpleServiceLocator.routedItemHelper.createNewTravelItem(stack);
                        item.setDestination(order.getRouter().getSimpleID());
                        item.setTransportMode(IRoutedItem.TransportMode.Active);
                        this.queueRoutedItem(item, ((NeighborTileEntity)pair.getValue1()).getDirection());
                        this.getFluidOrderManager().sendSuccessfull(amount, false, item);
                    }
                }
            });
        }
        if (amountToSend.get() >= attemptedAmount.get()) {
            this.getFluidOrderManager().sendFailed();
        }
    }

    @Override
    public Map<FluidIdentifier, Integer> getAvailableFluids() {
        HashMap<FluidIdentifier, Integer> map2 = new HashMap<FluidIdentifier, Integer>();
        for (Pair<NeighborTileEntity<TileEntity>, ITankUtil> pair : PipeFluidUtil.INSTANCE.getAdjacentTanks(this, false)) {
            boolean fallback = true;
            if (pair.getValue2() instanceof ISpecialTankUtil) {
                ISpecialTankUtil util = (ISpecialTankUtil)pair.getValue2();
                fallback = false;
                ISpecialTankAccessHandler handler = util.getSpecialHandler();
                TileEntity tile = util.getTileEntity();
                Map<FluidIdentifier, Long> tmp = handler.getAvailableLiquid(tile);
                for (Map.Entry<FluidIdentifier, Long> entry : tmp.entrySet()) {
                    if (map2.containsKey(entry.getKey())) {
                        long addition = (long)((Integer)map2.get(entry.getKey())).intValue() + entry.getValue();
                        map2.put(entry.getKey(), addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                        continue;
                    }
                    map2.put(entry.getKey(), entry.getValue() > Integer.MAX_VALUE ? Integer.MAX_VALUE : entry.getValue().intValue());
                }
            }
            if (!fallback || !pair.getValue2().containsTanks()) continue;
            pair.getValue2().tanks().map(tank -> FluidIdentifierStack.getFromStack(tank.getContents())).forEach(liquid -> {
                if (liquid != null && liquid.getFluid() != null) {
                    FluidIdentifier ident = liquid.getFluid();
                    if (((ITankUtil)pair.getValue2()).canDrain(ident) && ((ITankUtil)pair.getValue2()).drain(ident.makeFluidIdentifierStack(1), false) != null) {
                        if (map2.containsKey(ident)) {
                            long addition = (long)((Integer)map2.get(ident)).intValue() + (long)liquid.getAmount();
                            map2.put(ident, addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                        } else {
                            map2.put(ident, liquid.getAmount());
                        }
                    }
                }
            });
        }
        HashMap<FluidIdentifier, Integer> result2 = new HashMap<FluidIdentifier, Integer>();
        for (Map.Entry fluid : map2.entrySet()) {
            int remaining = (Integer)fluid.getValue() - this.getFluidOrderManager().totalFluidsCountInOrders((FluidIdentifier)fluid.getKey());
            if (remaining < 1) continue;
            result2.put((FluidIdentifier)fluid.getKey(), remaining);
        }
        return result2;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_PROVIDER;
    }

    @Override
    public void canProvide(RequestTreeNode tree, RequestTree root, List<IFilter> filter2) {
        if (tree.isDone()) {
            return;
        }
        if (!(tree.getRequestType() instanceof FluidResource)) {
            return;
        }
        FluidIdentifier fluid = ((FluidResource)tree.getRequestType()).getFluid();
        AtomicInteger containedAmount = new AtomicInteger(0);
        for (Pair<NeighborTileEntity<TileEntity>, ITankUtil> pair : PipeFluidUtil.INSTANCE.getAdjacentTanks(this, false)) {
            boolean fallback = true;
            if (pair.getValue2() instanceof ISpecialTankUtil) {
                TileEntity tile;
                ISpecialTankUtil util = (ISpecialTankUtil)pair.getValue2();
                fallback = false;
                ISpecialTankAccessHandler handler = util.getSpecialHandler();
                Map<FluidIdentifier, Long> map2 = handler.getAvailableLiquid(tile = util.getTileEntity());
                if (map2.containsKey(fluid)) {
                    long addition = (long)containedAmount.get() + map2.get(fluid);
                    containedAmount.set(addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                }
            }
            if (!fallback || !pair.getValue2().containsTanks()) continue;
            pair.getValue2().tanks().map(tank -> FluidIdentifierStack.getFromStack(tank.getContents())).forEach(liquid -> {
                if (liquid != null && liquid.getFluid() != null && fluid.equals(liquid.getFluid()) && ((ITankUtil)pair.getValue2()).canDrain(liquid.getFluid()) && ((ITankUtil)pair.getValue2()).drain(liquid.getFluid().makeFluidIdentifierStack(1), false) != null) {
                    long addition = (long)containedAmount.get() + (long)liquid.getAmount();
                    containedAmount.set(addition > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)addition);
                }
            });
        }
        FluidLogisticsPromise promise = new FluidLogisticsPromise();
        promise.liquid = fluid;
        promise.amount = Math.min(tree.getMissingAmount(), containedAmount.get() - root.getAllPromissesFor(this, fluid.getItemIdentifier()));
        promise.sender = this;
        promise.type = IOrderInfoProvider.ResourceType.PROVIDER;
        if (promise.amount > 0) {
            tree.addPromise(promise);
        }
    }

    @Override
    public IOrderInfoProvider fullFill(FluidLogisticsPromise promise, IRequestFluid destination, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        return this.getFluidOrderManager().addOrder(promise, destination, type, info);
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public void collectSpecificInterests(@Nonnull Collection<ItemIdentifier> itemIdentifiers) {
        for (Pair<NeighborTileEntity<TileEntity>, ITankUtil> pair : PipeFluidUtil.INSTANCE.getAdjacentTanks(this, false)) {
            boolean fallback = true;
            if (pair.getValue2() instanceof ISpecialTankUtil) {
                ISpecialTankUtil util = (ISpecialTankUtil)pair.getValue2();
                fallback = false;
                ISpecialTankAccessHandler handler = util.getSpecialHandler();
                TileEntity tile = util.getTileEntity();
                handler.getAvailableLiquid(tile).keySet().stream().map(FluidIdentifier::getItemIdentifier).forEach(itemIdentifiers::add);
            }
            if (!fallback || !pair.getValue2().containsTanks()) continue;
            pair.getValue2().tanks().map(tank -> FluidIdentifierStack.getFromStack(tank.getContents())).forEach(liquid -> {
                if (liquid != null && liquid.getFluid() != null && ((ITankUtil)pair.getValue2()).canDrain(liquid.getFluid()) && ((ITankUtil)pair.getValue2()).drain(1, false) != null) {
                    FluidIdentifier ident = liquid.getFluid();
                    itemIdentifiers.add(ident.getItemIdentifier());
                }
            });
        }
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }
}

