/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.ccl;

import codechicken.lib.lighting.LightModel;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.buffer.BakingVertexBuffer;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.IconTransformation;
import codechicken.lib.vec.uv.UVTransformation;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.object3d.interfaces.I3DOperation;
import logisticspipes.proxy.object3d.interfaces.IBounds;
import logisticspipes.proxy.object3d.interfaces.IModel3D;
import logisticspipes.proxy.object3d.interfaces.IVec3;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Model3D
implements IModel3D {
    private static final Field spiteMap;
    private static final HashMap<Integer, TextureAtlasSprite> emptyHashMap;
    private final CCModel model;
    public Cache<Integer, List<BakedQuad>> renderCache = CacheBuilder.newBuilder().build();

    public Model3D(CCModel model) {
        if (model == null) {
            throw new NullPointerException();
        }
        this.model = model;
    }

    @Override
    public void render(I3DOperation ... i3dOperations) {
        ArrayList<IVertexOperation> list = new ArrayList<IVertexOperation>();
        for (I3DOperation op : i3dOperations) {
            list.add((IVertexOperation)op.getOriginal());
        }
        this.model.render(CCRenderState.instance(), list.toArray(new IVertexOperation[0]));
    }

    private String atlasString(TextureAtlasSprite sprite) {
        return "name='" + sprite.func_94215_i() + "', x=" + sprite.func_130010_a() + ", y=" + sprite.func_110967_i() + ", height=" + sprite.func_94216_b() + ", width=" + sprite.func_94211_a() + ", u0=" + sprite.func_94209_e() + ", u1=" + sprite.func_94212_f() + ", v0=" + sprite.func_94206_g() + ", v1=" + sprite.func_94210_h() + "}";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> renderToQuads(VertexFormat format, I3DOperation ... i3dOperations) {
        List content;
        ArrayList<IVertexOperation> list = new ArrayList<IVertexOperation>();
        HashSet<String> hash = new HashSet<String>();
        hash.add(String.valueOf(format.hashCode()));
        boolean cachable = true;
        for (I3DOperation op : i3dOperations) {
            IVertexOperation iVertexOperation = (IVertexOperation)op.getOriginal();
            list.add(iVertexOperation);
            if (iVertexOperation instanceof IconTransformation) {
                hash.add(this.atlasString(((IconTransformation)iVertexOperation).icon));
                continue;
            }
            if (iVertexOperation instanceof Rotation) {
                hash.add(iVertexOperation.toString());
                continue;
            }
            if (iVertexOperation instanceof Scale) {
                hash.add(iVertexOperation.toString());
                continue;
            }
            if (iVertexOperation instanceof Translation) {
                hash.add(iVertexOperation.toString());
                continue;
            }
            cachable = false;
        }
        if (cachable && (content = (List)this.renderCache.getIfPresent((Object)hash.hashCode())) != null) {
            return content;
        }
        BakingVertexBuffer buffer = BakingVertexBuffer.create();
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.startDrawing(7, format, (BufferBuilder)buffer);
        this.model.render(ccrs, list.toArray(new IVertexOperation[0]));
        buffer.func_178977_d();
        emptyHashMap.clear();
        if (spiteMap != null) {
            spiteMap.set(buffer, emptyHashMap);
        }
        List quads = buffer.bake();
        if (cachable) {
            this.renderCache.put((Object)hash.hashCode(), (Object)quads);
        }
        return quads;
    }

    @Override
    public IModel3D copy() {
        return SimpleServiceLocator.cclProxy.wrapModel(this.model.copy());
    }

    @Override
    public void computeStandardLighting() {
        this.model.computeLighting(LightModel.standardLightModel);
    }

    @Override
    public void computeNormals() {
        this.model.computeNormals();
    }

    @Override
    public IBounds bounds() {
        return this.wrap(this.model.bounds());
    }

    private IBounds wrap(final Cuboid6 bounds) {
        return new IBounds(){

            @Override
            public IVec3 min() {
                return new IVec3(){

                    @Override
                    public double z() {
                        return bounds.min.z;
                    }

                    @Override
                    public double y() {
                        return bounds.min.y;
                    }

                    @Override
                    public double x() {
                        return bounds.min.x;
                    }

                    @Override
                    public Object getOriginal() {
                        return bounds.min;
                    }
                };
            }

            @Override
            public IVec3 max() {
                return new IVec3(){

                    @Override
                    public double z() {
                        return bounds.max.z;
                    }

                    @Override
                    public double y() {
                        return bounds.max.y;
                    }

                    @Override
                    public double x() {
                        return bounds.max.x;
                    }

                    @Override
                    public Object getOriginal() {
                        return bounds.max;
                    }
                };
            }

            @Override
            public AxisAlignedBB toAABB() {
                return bounds.aabb();
            }
        };
    }

    @Override
    public IModel3D backfacedCopy() {
        return SimpleServiceLocator.cclProxy.wrapModel(this.model.backfacedCopy());
    }

    @Override
    public IModel3D apply(I3DOperation translation) {
        if (translation.getOriginal() instanceof UVTransformation) {
            return SimpleServiceLocator.cclProxy.wrapModel(this.model.apply((UVTransformation)translation.getOriginal()));
        }
        if (translation.getOriginal() instanceof Transformation) {
            return SimpleServiceLocator.cclProxy.wrapModel(this.model.apply((Transformation)translation.getOriginal()));
        }
        throw new UnsupportedOperationException(translation.getOriginal().getClass().toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof Model3D) {
            return ((Model3D)obj).model.equals(this.model);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.model.hashCode();
    }

    @Override
    public IModel3D twoFacedCopy() {
        return SimpleServiceLocator.cclProxy.wrapModel(this.model.twoFacedCopy());
    }

    @Override
    public Object getOriginal() {
        return this.model;
    }

    @Override
    public IBounds getBoundsInside(AxisAlignedBB boundingBox) {
        Cuboid6 c = null;
        for (Vertex5 v : this.model.verts) {
            if (!boundingBox.func_72318_a(new Vec3d(v.vec.x, v.vec.y, v.vec.z))) continue;
            if (c == null) {
                c = new Cuboid6(v.vec.copy(), v.vec.copy());
                continue;
            }
            c.enclose(v.vec);
        }
        if (c == null) {
            return null;
        }
        return this.wrap(c);
    }

    static {
        emptyHashMap = new HashMap();
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            try {
                spiteMap = BakingVertexBuffer.class.getDeclaredField("spriteMap");
                spiteMap.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        } else {
            spiteMap = null;
        }
    }
}

