/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.EnumSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import logisticspipes.routing.PipeRoutingConnectionType;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public class LaserData {
    private int posX;
    private int posY;
    private int posZ;
    private boolean finalPipe = true;
    private boolean startPipe = false;
    private int length = 1;
    @Nonnull
    private EnumFacing dir;
    @Nonnull
    private EnumSet<PipeRoutingConnectionType> connectionType;

    public LaserData(int posX, int posY, int posZ, @Nonnull EnumFacing dir, @Nonnull EnumSet<PipeRoutingConnectionType> connectionType) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.dir = dir;
        this.connectionType = connectionType;
    }

    public LaserData(LPDataInput input) {
        this.posX = input.readInt();
        this.posY = input.readInt();
        this.posZ = input.readInt();
        this.dir = Objects.requireNonNull(input.readFacing());
        this.finalPipe = input.readBoolean();
        this.startPipe = input.readBoolean();
        this.length = input.readInt();
        this.connectionType = EnumSet.noneOf(PipeRoutingConnectionType.class);
        for (PipeRoutingConnectionType type : PipeRoutingConnectionType.values()) {
            if (!input.readBoolean()) continue;
            this.connectionType.add(type);
        }
    }

    public void writeData(LPDataOutput output) {
        output.writeInt(this.posX);
        output.writeInt(this.posY);
        output.writeInt(this.posZ);
        output.writeFacing(this.dir);
        output.writeBoolean(this.finalPipe);
        output.writeBoolean(this.startPipe);
        output.writeInt(this.length);
        for (PipeRoutingConnectionType type : PipeRoutingConnectionType.values()) {
            output.writeBoolean(this.connectionType.contains((Object)type));
        }
    }

    public int getPosX() {
        return this.posX;
    }

    public LaserData setPosX(int posX) {
        this.posX = posX;
        return this;
    }

    public int getPosY() {
        return this.posY;
    }

    public LaserData setPosY(int posY) {
        this.posY = posY;
        return this;
    }

    public int getPosZ() {
        return this.posZ;
    }

    public LaserData setPosZ(int posZ) {
        this.posZ = posZ;
        return this;
    }

    @Nonnull
    public EnumFacing getDir() {
        return this.dir;
    }

    public LaserData setDir(EnumFacing dir) {
        this.dir = dir;
        return this;
    }

    @Nonnull
    public EnumSet<PipeRoutingConnectionType> getConnectionType() {
        return this.connectionType;
    }

    public LaserData setConnectionType(@Nonnull EnumSet<PipeRoutingConnectionType> connectionType) {
        this.connectionType = connectionType;
        return this;
    }

    public boolean isFinalPipe() {
        return this.finalPipe;
    }

    public LaserData setFinalPipe(boolean finalPipe) {
        this.finalPipe = finalPipe;
        return this;
    }

    public boolean isStartPipe() {
        return this.startPipe;
    }

    public LaserData setStartPipe(boolean startPipe) {
        this.startPipe = startPipe;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public LaserData setLength(int length) {
        this.length = length;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LaserData)) {
            return false;
        }
        LaserData other = (LaserData)o;
        if (this.getPosX() != other.getPosX()) {
            return false;
        }
        if (this.getPosY() != other.getPosY()) {
            return false;
        }
        if (this.getPosZ() != other.getPosZ()) {
            return false;
        }
        if (!Objects.equals(this.getDir(), other.getDir())) {
            return false;
        }
        if (!Objects.equals(this.getConnectionType(), other.getConnectionType())) {
            return false;
        }
        if (this.isFinalPipe() != other.isFinalPipe()) {
            return false;
        }
        if (this.isStartPipe() != other.isStartPipe()) {
            return false;
        }
        return this.getLength() == other.getLength();
    }

    public int hashCode() {
        int PRIME = 59;
        int result2 = 1;
        result2 = result2 * 59 + this.getPosX();
        result2 = result2 * 59 + this.getPosY();
        result2 = result2 * 59 + this.getPosZ();
        result2 = result2 * 59 + this.getDir().hashCode();
        result2 = result2 * 59 + this.getConnectionType().hashCode();
        result2 = result2 * 59 + (this.isFinalPipe() ? 79 : 97);
        result2 = result2 * 59 + (this.isStartPipe() ? 79 : 97);
        result2 = result2 * 59 + this.getLength();
        return result2;
    }

    public String toString() {
        return "LaserData(posX=" + this.getPosX() + ", posY=" + this.getPosY() + ", posZ=" + this.getPosZ() + ", dir=" + this.getDir() + ", connectionType=" + this.getConnectionType() + ", finalPipe=" + this.isFinalPipe() + ", startPipe=" + this.isStartPipe() + ", length=" + this.getLength() + ")";
    }
}

