/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils.item;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.LogisticsPipes;
import logisticspipes.utils.item.DictIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DictItemIdentifier {
    private static ConcurrentHashMap<BitSet, DictItemIdentifier> identifiers = new ConcurrentHashMap();
    private final List<DictIdentifier> parts = new ArrayList<DictIdentifier>();

    @Nullable
    public static DictItemIdentifier getDictItemIdentifier(@Nonnull ItemIdentifier itemIdent) {
        BitSet ids = new BitSet();
        boolean hasDict = false;
        ItemStack stack = itemIdent.unsafeMakeNormalStack(1);
        if (stack.func_190926_b()) {
            LogisticsPipes.log.error("Cannot make stack from item " + itemIdent.toString() + " -- item creates and empty stack!");
            return null;
        }
        for (int oreId : OreDictionary.getOreIDs((ItemStack)stack)) {
            ids.set(oreId);
            hasDict = true;
        }
        if (!hasDict) {
            return null;
        }
        DictItemIdentifier dictIdent = identifiers.get(ids);
        if (dictIdent == null) {
            dictIdent = new DictItemIdentifier(ids);
            identifiers.put(ids, dictIdent);
        }
        return dictIdent;
    }

    private DictItemIdentifier(BitSet set) {
        int id = -1;
        while ((id = set.nextSetBit(id + 1)) != -1) {
            this.parts.add(DictIdentifier.getForId(id));
        }
    }

    public boolean canMatch(DictItemIdentifier ident, boolean byName, boolean byCategory) {
        for (DictIdentifier ident1 : this.parts) {
            for (DictIdentifier ident2 : ident.parts) {
                if (ident1 == ident2) {
                    return true;
                }
                if (byName && ident1.canNameMatch(ident2)) {
                    return true;
                }
                if (!byCategory || !ident1.canCategoryMatch(ident2)) continue;
                return true;
            }
        }
        return false;
    }

    public void debugDumpData(boolean isClient) {
        StringBuilder builder = new StringBuilder("DictIdentifiers: [");
        boolean first2 = true;
        for (DictIdentifier ident : this.parts) {
            if (!first2) {
                builder.append(", ");
            }
            ident.debugDumpData(isClient, builder);
            first2 = false;
        }
        builder.append("]");
        System.out.println(builder.toString());
    }
}

