/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes;

import java.util.Collection;
import java.util.List;
import logisticspipes.interfaces.ITankUtil;
import logisticspipes.interfaces.routing.IFluidSink;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.pipes.PipeFluidUtil;
import logisticspipes.pipes.basic.fluid.FluidRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.FluidSinkReply;
import logisticspipes.utils.PlayerCollectionList;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import network.rs485.logisticspipes.connection.NeighborTileEntity;
import network.rs485.logisticspipes.property.ItemIdentifierInventoryProperty;
import network.rs485.logisticspipes.property.Property;
import network.rs485.logisticspipes.property.PropertyHolder;
import network.rs485.logisticspipes.property.UtilKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u001bH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010#\u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"J\u0010\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006,"}, d2={"Lnetwork/rs485/logisticspipes/FluidSinkPipe;", "Llogisticspipes/pipes/basic/fluid/FluidRoutedPipe;", "Llogisticspipes/interfaces/routing/IFluidSink;", "Lnetwork/rs485/logisticspipes/property/PropertyHolder;", "item", "Lnet/minecraft/item/Item;", "inventoryName", "", "inventorySize", "", "(Lnet/minecraft/item/Item;Ljava/lang/String;I)V", "guiOpenedBy", "Llogisticspipes/utils/PlayerCollectionList;", "priority", "Llogisticspipes/utils/FluidSinkReply$FixedFluidPriority;", "getPriority", "()Llogisticspipes/utils/FluidSinkReply$FixedFluidPriority;", "properties", "", "Lnetwork/rs485/logisticspipes/property/Property;", "getProperties", "()Ljava/util/List;", "sinkInv", "Lnetwork/rs485/logisticspipes/property/ItemIdentifierInventoryProperty;", "getSinkInv", "()Lnetwork/rs485/logisticspipes/property/ItemIdentifierInventoryProperty;", "canInsertFromSideToTanks", "", "canInsertToTanks", "canReceiveFluid", "finishInit", "", "guiClosedByPlayer", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "guiOpenedByPlayer", "readFromNBT", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "sinkAmount", "Llogisticspipes/utils/FluidSinkReply;", "stack", "Llogisticspipes/utils/FluidIdentifierStack;", "writeToNBT", "logisticspipes"})
public abstract class FluidSinkPipe
extends FluidRoutedPipe
implements IFluidSink,
PropertyHolder {
    @NotNull
    private final PlayerCollectionList guiOpenedBy;
    @NotNull
    private final ItemIdentifierInventoryProperty sinkInv;
    @NotNull
    private final List<Property<?>> properties;

    public FluidSinkPipe(@NotNull Item item, @NotNull String inventoryName, int inventorySize) {
        Intrinsics.checkNotNullParameter(item, "item");
        Intrinsics.checkNotNullParameter(inventoryName, "inventoryName");
        super(item);
        this.guiOpenedBy = new PlayerCollectionList();
        this.sinkInv = new ItemIdentifierInventoryProperty(new ItemIdentifierInventory(inventorySize, inventoryName, 1, true), "");
        this.properties = CollectionsKt.listOf(this.sinkInv);
    }

    @NotNull
    public final ItemIdentifierInventoryProperty getSinkInv() {
        return this.sinkInv;
    }

    @Override
    @NotNull
    public List<Property<?>> getProperties() {
        return this.properties;
    }

    @NotNull
    public abstract FluidSinkReply.FixedFluidPriority getPriority();

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        super.readFromNBT(tag);
        PropertyHolder.super.readFromNBT(tag);
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        super.writeToNBT(tag);
        PropertyHolder.super.writeToNBT(tag);
    }

    @Override
    public void finishInit() {
        super.finishInit();
        MainProxy.runOnServer((IBlockAccess)this.getWorld(), () -> FluidSinkPipe.finishInit$lambda-1(this));
    }

    @Override
    @Nullable
    public FluidSinkReply sinkAmount(@NotNull FluidIdentifierStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        if (!this.guiOpenedBy.isEmpty()) {
            return null;
        }
        int n = this.sinkInv.size();
        for (int i = 0; i < n; ++i) {
            ItemIdentifierStack identStack;
            if (this.sinkInv.getIDStackInSlot(i) == null || !Intrinsics.areEqual(stack.getFluid(), FluidIdentifier.get(identStack.getItem()))) continue;
            int onTheWay = this.countOnRoute(stack.getFluid());
            long freeSpace = -((long)onTheWay);
            for (Pair<NeighborTileEntity<TileEntity>, ITankUtil> pair : PipeFluidUtil.INSTANCE.getAdjacentTanks(this, true)) {
                int dirOrdinal = pair.component1().getDirection().ordinal();
                PipeTransportLogistics pipeTransportLogistics = this.transport;
                Intrinsics.checkNotNull(pipeTransportLogistics, "null cannot be cast to non-null type logisticspipes.transport.PipeFluidTransportLogistics");
                FluidTank tank = ((PipeFluidTransportLogistics)pipeTransportLogistics).sideTanks[dirOrdinal];
                freeSpace += (long)pair.component2().getFreeSpaceInsideTank(stack.getFluid());
                if ((freeSpace += (long)stack.getFluid().getFreeSpaceInsideTank((IFluidTank)tank)) < (long)stack.getAmount()) continue;
                return new FluidSinkReply(this.getPriority(), stack.getAmount());
            }
            return new FluidSinkReply(this.getPriority(), freeSpace);
        }
        return null;
    }

    public final void guiOpenedByPlayer(@Nullable EntityPlayer player) {
        this.guiOpenedBy.add(player);
    }

    public final void guiClosedByPlayer(@Nullable EntityPlayer player) {
        this.guiOpenedBy.remove(player);
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public boolean canReceiveFluid() {
        return false;
    }

    private static final void finishInit$lambda-1$lambda-0(FluidSinkPipe this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        UtilKt.addObserver((Collection)this$0.getProperties(), new Function1<Property<?>, Unit>(this$0){
            final /* synthetic */ FluidSinkPipe this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Property<?> it) {
                Intrinsics.checkNotNullParameter(it, "it");
                this.this$0.markTileDirty();
            }
        });
    }

    private static final Runnable finishInit$lambda-1(FluidSinkPipe this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        return () -> FluidSinkPipe.finishInit$lambda-1$lambda-0(this$0);
    }
}

