/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.compat;

import java.util.Map;
import java.util.Set;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin._Assertions;
import logisticspipes.kotlin.collections.MapsKt;
import logisticspipes.kotlin.collections.SetsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.inventory.ProviderMode;
import pl.asie.charset.api.storage.IBarrel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010#\n\u0000\n\u0002\u0010%\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cH\u0016J\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\u0017H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0014H\u0016J\b\u0010#\u001a\u00020\u0017H\u0016J\u0010\u0010$\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010%\u001a\u00020\u0011H\u0002J\u0010\u0010&\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0014H\u0016J\u0010\u0010(\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\fH\u0016J\f\u0010)\u001a\u00020\u0017*\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lnetwork/rs485/logisticspipes/compat/BarrelInventoryHandler;", "Llogisticspipes/proxy/specialinventoryhandler/SpecialInventoryHandler;", "tile", "Lpl/asie/charset/api/storage/IBarrel;", "mode", "Lnetwork/rs485/logisticspipes/inventory/ProviderMode;", "(Lpl/asie/charset/api/storage/IBarrel;Lnetwork/rs485/logisticspipes/inventory/ProviderMode;)V", "getMode", "()Lnetwork/rs485/logisticspipes/inventory/ProviderMode;", "getTile", "()Lpl/asie/charset/api/storage/IBarrel;", "add", "Lnet/minecraft/item/ItemStack;", "stack", "orientation", "Lnet/minecraft/util/EnumFacing;", "doAdd", "", "containsUndamagedItem", "item", "Llogisticspipes/utils/item/ItemIdentifier;", "decrStackSize", "slot", "", "amount", "getIdentifier", "getItem", "getItems", "", "getItemsAndCount", "", "getMultipleItems", "itemIdent", "count", "getSingleItem", "getSizeInventory", "getStackInSlot", "isEmpty", "isValidItem", "itemCount", "roomForItem", "providerMode", "logisticspipes"})
public final class BarrelInventoryHandler
extends SpecialInventoryHandler {
    @NotNull
    private final IBarrel tile;
    @NotNull
    private final ProviderMode mode;

    public BarrelInventoryHandler(@NotNull IBarrel tile, @NotNull ProviderMode mode) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Intrinsics.checkNotNullParameter((Object)mode, "mode");
        this.tile = tile;
        this.mode = mode;
    }

    @NotNull
    public final IBarrel getTile() {
        return this.tile;
    }

    @NotNull
    public final ProviderMode getMode() {
        return this.mode;
    }

    @Override
    @NotNull
    public ItemStack decrStackSize(int slot, int amount) {
        if (slot != 0) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue(itemStack, "EMPTY");
            return itemStack;
        }
        ItemStack itemStack = this.tile.extractItem(amount, false);
        Intrinsics.checkNotNullExpressionValue(itemStack, "tile.extractItem(amount, false)");
        return itemStack;
    }

    @Override
    public boolean containsUndamagedItem(@NotNull ItemIdentifier item) {
        Intrinsics.checkNotNullParameter(item, "item");
        return ItemIdentifier.get(this.getItem()).getUndamaged().equals(item);
    }

    @Override
    @NotNull
    public ItemStack add(@NotNull ItemStack stack, @Nullable EnumFacing orientation, boolean doAdd) {
        block6: {
            ItemStack itemStack;
            ItemStack leftover;
            block7: {
                Intrinsics.checkNotNullParameter(stack, "stack");
                if (!this.tile.shouldInsertToSide(orientation)) break block6;
                if (this.isEmpty()) break block7;
                ItemIdentifier itemIdentifier = ItemIdentifier.get(stack);
                Intrinsics.checkNotNullExpressionValue(itemIdentifier, "get(stack)");
                if (!this.isValidItem(itemIdentifier)) break block6;
            }
            if ((leftover = this.tile.insertItem(stack, !doAdd)).func_190926_b()) {
                itemStack = stack;
            } else {
                ItemStack itemStack2;
                boolean bl = Intrinsics.areEqual(leftover.func_77973_b(), stack.func_77973_b());
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                ItemStack it = itemStack2 = stack.func_77946_l();
                boolean bl2 = false;
                it.func_190920_e(it.func_190916_E() - leftover.func_190916_E());
                ItemStack itemStack3 = itemStack2;
                itemStack = itemStack3;
                Intrinsics.checkNotNullExpressionValue(itemStack3, "{\n                assert\u2026ver.count }\n            }");
            }
            return itemStack;
        }
        return stack;
    }

    @Override
    @NotNull
    public ItemStack getMultipleItems(@NotNull ItemIdentifier itemIdent, int count2) {
        Intrinsics.checkNotNullParameter(itemIdent, "itemIdent");
        if (!this.isEmpty() && this.isValidItem(itemIdent) && this.itemCount(itemIdent) >= count2) {
            ItemStack itemStack = this.tile.extractItem(count2, false);
            Intrinsics.checkNotNullExpressionValue(itemStack, "tile.extractItem(count, false)");
            return itemStack;
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue(itemStack, "EMPTY");
        return itemStack;
    }

    @Override
    @NotNull
    public ItemStack getSingleItem(@NotNull ItemIdentifier itemIdent) {
        Intrinsics.checkNotNullParameter(itemIdent, "itemIdent");
        return this.getMultipleItems(itemIdent, 1);
    }

    @Override
    @NotNull
    public Set<ItemIdentifier> getItems() {
        ItemIdentifier[] itemIdentifierArray = new ItemIdentifier[1];
        Intrinsics.checkNotNullExpressionValue(ItemIdentifier.get(this.getItem()), "get(getItem())");
        return SetsKt.mutableSetOf(itemIdentifierArray);
    }

    @Override
    @NotNull
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        Pair[] pairArray = new Pair[]{TuplesKt.to(this.getIdentifier(), this.itemCount(this.getIdentifier()))};
        return MapsKt.mutableMapOf(pairArray);
    }

    @Override
    public int getSizeInventory() {
        return 1;
    }

    @Override
    @NotNull
    public ItemStack getStackInSlot(int slot) {
        ItemStack itemStack;
        if (slot != 0) {
            ItemStack itemStack2 = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue(itemStack2, "EMPTY");
            return itemStack2;
        }
        ItemStack stack = this.getItem();
        stack.func_190920_e(this.itemCount(this.getIdentifier()));
        if (stack.func_190926_b()) {
            ItemStack itemStack3 = ItemStack.field_190927_a;
            itemStack = itemStack3;
            Intrinsics.checkNotNullExpressionValue(itemStack3, "EMPTY");
        } else {
            itemStack = stack;
        }
        return itemStack;
    }

    @Override
    public int roomForItem(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        ItemIdentifier itemIdentifier = ItemIdentifier.get(stack);
        Intrinsics.checkNotNullExpressionValue(itemIdentifier, "get(stack)");
        ItemIdentifier identifier = itemIdentifier;
        return this.isValidItem(identifier) ? this.tile.getMaxItemCount() - this.itemCount(identifier) : 0;
    }

    @Override
    public int itemCount(@NotNull ItemIdentifier itemIdent) {
        Intrinsics.checkNotNullParameter(itemIdent, "itemIdent");
        return !this.isEmpty() && this.isValidItem(itemIdent) ? this.providerMode(this.tile.getItemCount()) : 0;
    }

    private final int providerMode(int $this$providerMode) {
        return this.mode.getHideOnePerType() || this.mode.getHideOnePerStack() ? $this$providerMode - 1 : $this$providerMode;
    }

    private final boolean isEmpty() {
        return this.getItem().func_190926_b();
    }

    private final boolean isValidItem(ItemIdentifier itemIdent) {
        return itemIdent.equals(ItemIdentifier.get(this.getItem()));
    }

    private final ItemStack getItem() {
        ItemStack itemStack = this.tile.extractItem(1, true);
        Intrinsics.checkNotNullExpressionValue(itemStack, "tile.extractItem(1, true)");
        return itemStack;
    }

    private final ItemIdentifier getIdentifier() {
        ItemIdentifier itemIdentifier = ItemIdentifier.get(this.getItem());
        Intrinsics.checkNotNullExpressionValue(itemIdentifier, "get(getItem())");
        return itemIdentifier;
    }
}

