/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.collections.MapsKt;
import logisticspipes.kotlin.io.CloseableKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.text.Charsets;
import logisticspipes.utils.PlayerIdentifier;
import net.minecraftforge.fml.common.FMLCommonHandler;
import network.rs485.logisticspipes.config.ClientConfiguration;
import network.rs485.logisticspipes.config.PlayerConfiguration;
import network.rs485.logisticspipes.config.ServerConfiguration;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0010J\u0012\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u0006H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\fJ\b\u0010\u0018\u001a\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lnetwork/rs485/logisticspipes/config/ServerConfigurationManager;", "", "()V", "configFile", "Ljava/io/File;", "fileName", "", "gson", "Lcom/google/gson/Gson;", "internalRepresentation", "Lnetwork/rs485/logisticspipes/config/ServerConfiguration;", "getPlayerConfiguration", "Lnetwork/rs485/logisticspipes/config/PlayerConfiguration;", "identifier", "Llogisticspipes/utils/PlayerIdentifier;", "getPlayers", "", "getTimedFile", "suffix", "setClientConfiguration", "", "configuration", "Lnetwork/rs485/logisticspipes/config/ClientConfiguration;", "setPlayerConfiguration", "writeChange", "logisticspipes"})
public final class ServerConfigurationManager {
    @NotNull
    private final String fileName;
    @NotNull
    private final File configFile;
    @NotNull
    private final Gson gson = new Gson();
    @NotNull
    private final ServerConfiguration internalRepresentation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerConfigurationManager() {
        ServerConfiguration serverConfiguration;
        ServerConfigurationManager serverConfigurationManager;
        this.fileName = "logisticspipes.json";
        this.configFile = new File(FMLCommonHandler.instance().getSavesDirectory(), this.fileName);
        ServerConfigurationManager serverConfigurationManager2 = this;
        try {
            ServerConfiguration serverConfiguration2;
            Object object = this.configFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object3 = new InputStreamReader((InputStream)new FileInputStream((File)object3), (Charset)object2);
            object = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            ServerConfigurationManager serverConfigurationManager3 = serverConfigurationManager2;
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)object;
                boolean bl = false;
                serverConfiguration2 = (ServerConfiguration)this.gson.fromJson(this.gson.newJsonReader((Reader)it), (Type)((Object)ServerConfiguration.class));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            ServerConfiguration serverConfiguration3 = serverConfiguration2;
            serverConfigurationManager = serverConfigurationManager3;
            Intrinsics.checkNotNullExpressionValue(serverConfiguration3, "{\n            configFile\u2026)\n            }\n        }");
            serverConfiguration = serverConfiguration3;
        }
        catch (JsonParseException jsonParseException) {
            serverConfigurationManager = serverConfigurationManager2;
            LogisticsPipes.log.error("Cannot read LP configuration! Moving current configuration away and starting a new one!");
            Files.move(this.configFile.toPath(), this.getTimedFile(".bkp").toPath(), new CopyOption[0]);
            serverConfiguration = new ServerConfiguration();
        }
        catch (FileNotFoundException e) {
            serverConfigurationManager = serverConfigurationManager2;
            LogisticsPipes.log.info("Starting a new LP configuration");
            serverConfiguration = new ServerConfiguration();
        }
        serverConfigurationManager.internalRepresentation = serverConfiguration;
    }

    @NotNull
    public final Set<PlayerIdentifier> getPlayers() {
        return this.internalRepresentation.getPlayerConfigurations().keySet();
    }

    @NotNull
    public final PlayerConfiguration getPlayerConfiguration(@NotNull PlayerIdentifier identifier) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        PlayerConfiguration playerConfiguration = this.internalRepresentation.getPlayerConfigurations().get(identifier);
        if (playerConfiguration == null) {
            playerConfiguration = new PlayerConfiguration();
        }
        return playerConfiguration;
    }

    public final void setClientConfiguration(@NotNull PlayerIdentifier identifier, @NotNull ClientConfiguration configuration) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        Map<PlayerIdentifier, PlayerConfiguration> newConfigurations = MapsKt.toMutableMap(this.internalRepresentation.getPlayerConfigurations());
        newConfigurations.computeIfAbsent(identifier, ServerConfigurationManager::setClientConfiguration$lambda-1).merge(configuration);
        this.internalRepresentation.setPlayerConfigurations(newConfigurations);
        this.writeChange();
    }

    public final void setPlayerConfiguration(@NotNull PlayerIdentifier identifier, @NotNull PlayerConfiguration configuration) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        Intrinsics.checkNotNullParameter(configuration, "configuration");
        HashMap<PlayerIdentifier, PlayerConfiguration> newConfigurations = new HashMap<PlayerIdentifier, PlayerConfiguration>(this.internalRepresentation.getPlayerConfigurations());
        ((Map)newConfigurations).put(identifier, configuration);
        this.internalRepresentation.setPlayerConfigurations((Map<PlayerIdentifier, PlayerConfiguration>)newConfigurations);
        this.writeChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeChange() {
        File tmpFile = this.getTimedFile(".tmp");
        try {
            CopyOption[] copyOptionArray = tmpFile;
            Object object = Charsets.UTF_8;
            int n = 8192;
            Object object2 = copyOptionArray;
            object2 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object2), (Charset)object);
            copyOptionArray = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
            object = null;
            try {
                BufferedWriter it = (BufferedWriter)copyOptionArray;
                boolean bl = false;
                JsonElement jsonElement = this.gson.toJsonTree((Object)this.internalRepresentation, (Type)((Object)ServerConfiguration.class));
                this.gson.toJson(jsonElement, this.gson.newJsonWriter((Writer)it));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)copyOptionArray, (Throwable)object);
            }
            copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.move(tmpFile.toPath(), this.configFile.toPath(), copyOptionArray);
        }
        finally {
            Files.deleteIfExists(tmpFile.toPath());
        }
    }

    private final File getTimedFile(String suffix) {
        String time = String.valueOf(Calendar.getInstance().getTimeInMillis());
        return new File(this.configFile.getParentFile(), this.configFile.getName() + '.' + time + suffix);
    }

    static /* synthetic */ File getTimedFile$default(ServerConfigurationManager serverConfigurationManager, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        return serverConfigurationManager.getTimedFile(string);
    }

    private static final PlayerConfiguration setClientConfiguration$lambda-1(PlayerIdentifier it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return new PlayerConfiguration();
    }
}

