/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableKt;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0016J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J$\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001cH\u0016J\u000e\u0010!\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\u001cJ\u0016\u0010#\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010$\u001a\u00020\u0012R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawablePage;", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableParagraph;", "drawableParagraphs", "", "(Ljava/util/List;)V", "parent", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "draw", "", "mouseX", "", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "drawChildren", "getHovered", "getVisibleParagraphs", "preRender", "setChildrenPos", "", "setPos", "Llogisticspipes/kotlin/Pair;", "x", "y", "setWidth", "width", "updateScrollPosition", "progress", "logisticspipes"})
public final class DrawablePage
extends DrawableParagraph {
    @NotNull
    private final List<DrawableParagraph> drawableParagraphs;
    @NotNull
    private final MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;

    public DrawablePage(@NotNull List<? extends DrawableParagraph> drawableParagraphs) {
        Intrinsics.checkNotNullParameter(drawableParagraphs, "drawableParagraphs");
        this.drawableParagraphs = drawableParagraphs;
        this.relativeBody = new MutableRectangle();
    }

    @Override
    @NotNull
    public MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    @NotNull
    public final MutableRectangle setWidth(int width) {
        return this.getRelativeBody().setSize(width, this.getRelativeBody().getRoundedHeight());
    }

    public final void updateScrollPosition(@NotNull IRectangle visibleArea, float progress) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        this.getRelativeBody().setPos(this.getRelativeBody().getX0(), visibleArea.getY0() - ((float)this.getHeight() - visibleArea.getHeight()) * progress);
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> setPos(int x, int y) {
        this.getRelativeBody().setPos(x, y);
        this.getRelativeBody().setSize(this.getRelativeBody().getRoundedWidth(), this.setChildrenPos());
        return TuplesKt.to(this.getRelativeBody().getRoundedWidth(), this.getRelativeBody().getRoundedHeight());
    }

    @Override
    public int setChildrenPos() {
        int currentY = 5;
        for (DrawableParagraph paragraph : this.drawableParagraphs) {
            currentY += ((Number)DrawableKt.getY(paragraph.setPos(0, currentY))).intValue() + 5;
        }
        return currentY;
    }

    @Override
    public void preRender(float mouseX, float mouseY, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Iterable $this$forEach$iv = this.getVisibleParagraphs(visibleArea);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DrawableParagraph it = (DrawableParagraph)element$iv;
            boolean bl = false;
            it.preRender(mouseX, mouseY, visibleArea);
        }
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        this.drawChildren(mouseX, mouseY, delta, visibleArea);
    }

    @Override
    public void drawChildren(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Iterable $this$forEach$iv = this.getVisibleParagraphs(visibleArea);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DrawableParagraph it = (DrawableParagraph)element$iv;
            boolean bl = false;
            it.draw(mouseX, mouseY, delta, visibleArea);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DrawableParagraph> getVisibleParagraphs(@NotNull IRectangle visibleArea) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Iterable $this$filter$iv = this.drawableParagraphs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DrawableParagraph it = (DrawableParagraph)element$iv$iv;
            boolean bl = false;
            if (!it.visible(visibleArea)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public Drawable getHovered(float mouseX, float mouseY) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.drawableParagraphs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DrawableParagraph it = (DrawableParagraph)element$iv;
                boolean bl = false;
                if (!it.isMouseHovering(mouseX, mouseY)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        DrawableParagraph drawableParagraph = v0;
        return drawableParagraph != null ? drawableParagraph.getHovered(mouseX, mouseY) : null;
    }
}

