/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.gui.guidebook.DrawableWord;
import network.rs485.logisticspipes.gui.guidebook.DrawableWordKt;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J(\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J.\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0018\u00010\u001fR\u00020 H\u0016J\b\u0010!\u001a\u00020\u001dH\u0016J$\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d0#2\u0006\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020\u001dH\u0016R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableRegularParagraph;", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableParagraph;", "words", "", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableWord;", "(Ljava/util/List;)V", "parent", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "draw", "", "mouseX", "", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "drawChildren", "getHovered", "inBookMouseClicked", "", "mouseButton", "", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "setChildrenPos", "setPos", "Llogisticspipes/kotlin/Pair;", "x", "y", "logisticspipes"})
public final class DrawableRegularParagraph
extends DrawableParagraph {
    @NotNull
    private final List<DrawableWord> words;
    @NotNull
    private final MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;

    public DrawableRegularParagraph(@NotNull List<? extends DrawableWord> words) {
        Intrinsics.checkNotNullParameter(words, "words");
        this.words = words;
        this.relativeBody = new MutableRectangle();
    }

    @Override
    @NotNull
    public MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> setPos(int x, int y) {
        this.getRelativeBody().setPos(x, y);
        MutableRectangle mutableRectangle = this.getRelativeBody();
        Drawable drawable = this.getParent();
        Intrinsics.checkNotNull(drawable);
        mutableRectangle.setSize(drawable.getWidth(), this.setChildrenPos());
        return super.setPos(x, y);
    }

    @Override
    public int setChildrenPos() {
        return DrawableWordKt.splitAndInitialize(this.words, 0, 0, this.getWidth(), true);
    }

    @Override
    public boolean inBookMouseClicked(float mouseX, float mouseY, int mouseButton, @Nullable GuiGuideBook.ActionListener guideActionListener) {
        Object v0;
        block1: {
            Iterable iterable = this.words;
            for (Object t : iterable) {
                DrawableWord it = (DrawableWord)t;
                boolean bl = false;
                if (!it.isMouseHovering(mouseX, mouseY)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        DrawableWord drawableWord = v0;
        return drawableWord != null ? drawableWord.inBookMouseClicked(mouseX, mouseY, mouseButton, guideActionListener) : false;
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        super.draw(mouseX, mouseY, delta, visibleArea);
        this.drawChildren(mouseX, mouseY, delta, visibleArea);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void drawChildren(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        void $this$groupByTo$iv$iv;
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Iterable $this$groupBy$iv = this.words;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            DrawableWord it = (DrawableWord)element$iv$iv;
            boolean bl = false;
            Float key$iv$iv = Float.valueOf(it.getTop());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Collection lines = destination$iv$iv.values();
        for (List line : lines) {
            if (!((DrawableWord)CollectionsKt.first(line)).visible(visibleArea)) continue;
            for (DrawableWord drawable : line) {
                drawable.draw(mouseX, mouseY, delta, visibleArea);
            }
        }
    }

    @Override
    @Nullable
    public Drawable getHovered(float mouseX, float mouseY) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.words;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DrawableWord it = (DrawableWord)element$iv;
                boolean bl = false;
                if (!it.isMouseHovering(mouseX, mouseY)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

