/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Ref;
import network.rs485.logisticspipes.gui.guidebook.DrawableBreak;
import network.rs485.logisticspipes.gui.guidebook.DrawableSpace;
import network.rs485.logisticspipes.gui.guidebook.DrawableWord;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a.\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a&\u0010\b\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a6\u0010\t\u001a\u00020\u00012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0000\u001a*\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u00032\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u00a8\u0006\u000f"}, d2={"initializeJustifiedLine", "", "line", "", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableWord;", "x", "y", "maxWidth", "initializeLine", "splitAndInitialize", "drawables", "justify", "", "splitLines", "originalWords", "logisticspipes"})
public final class DrawableWordKt {
    public static final int splitAndInitialize(@NotNull List<? extends DrawableWord> drawables, int x, int y, int maxWidth, boolean justify) {
        Intrinsics.checkNotNullParameter(drawables, "drawables");
        int currentHeight = 0;
        List<List<DrawableWord>> splitLines = DrawableWordKt.splitLines(drawables, maxWidth);
        for (List<DrawableWord> line : splitLines) {
            currentHeight += !justify || DrawableWordKt.splitAndInitialize$isLastLine(splitLines, line) || DrawableWordKt.splitAndInitialize$hasBreak(line) ? DrawableWordKt.initializeLine(line, x, y + currentHeight) : DrawableWordKt.initializeJustifiedLine(line, x, y + currentHeight, maxWidth);
        }
        return currentHeight;
    }

    /*
     * WARNING - void declaration
     */
    private static final int initializeJustifiedLine(List<? extends DrawableWord> line, int x, int y, int maxWidth) {
        block9: {
            void $this$fold$iv;
            void initial$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Object v0;
            List spacesExceptIfLast;
            Iterable $this$filterNotTo$iv$iv2;
            block8: {
                void $this$filterNot$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = line;
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Object destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof DrawableSpace)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$filterNot = false;
                $this$filterIsInstanceTo$iv$iv = $this$filterNot$iv2;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo2 = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
                    DrawableSpace it = (DrawableSpace)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual(it, CollectionsKt.last(line))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                spacesExceptIfLast = (List)destination$iv$iv;
                $this$filterNotTo$iv$iv2 = line;
                for (Object $i$f$filterNotTo2 : $this$filterNotTo$iv$iv2) {
                    DrawableWord it = (DrawableWord)$i$f$filterNotTo2;
                    boolean bl = false;
                    if (!(it instanceof DrawableSpace && Intrinsics.areEqual(it, CollectionsKt.last(line)))) continue;
                    v0 = $i$f$filterNotTo2;
                    break block8;
                }
                v0 = null;
            }
            DrawableSpace spaceIfLast = v0;
            $this$filterNotTo$iv$iv2 = line;
            int n = maxWidth;
            boolean $i$f$filterNot = false;
            void $i$f$filterNotTo2 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                DrawableWord it = (DrawableWord)element$iv$iv;
                boolean bl = false;
                if (it instanceof DrawableSpace) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = (List)destination$iv$iv;
            $this$filterNot$iv = list;
            $i$f$filterNot = false;
            boolean $i$f$fold = false;
            void accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void word;
                DrawableWord element$iv$iv = (DrawableWord)element$iv;
                void currentWidth = accumulator$iv;
                boolean bl = false;
                accumulator$iv = currentWidth + word.getWidth();
            }
            void var18_33 = accumulator$iv;
            int totalSpaceWidth = n - var18_33;
            int spaceWidthBase = (int)Math.floor((float)totalSpaceWidth / (float)spacesExceptIfLast.size());
            int remainder = 0;
            remainder = !((Collection)spacesExceptIfLast).isEmpty() ? totalSpaceWidth % spacesExceptIfLast.size() : 0;
            Iterable $this$forEach$iv = spacesExceptIfLast;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n2;
                DrawableSpace space = (DrawableSpace)element$iv;
                boolean bl = false;
                if (remainder > 0) {
                    remainder += -1;
                    n2 = spaceWidthBase + 1;
                } else {
                    n2 = spaceWidthBase;
                }
                int currentSpaceWidth = n2;
                space.setWidth(currentSpaceWidth);
            }
            DrawableSpace drawableSpace = spaceIfLast;
            if (drawableSpace == null) break block9;
            drawableSpace.setWidth(0);
        }
        return DrawableWordKt.initializeLine(line, x, y);
    }

    /*
     * WARNING - void declaration
     */
    private static final int initializeLine(List<? extends DrawableWord> line, int x, int y) {
        void $this$fold$iv;
        if (line.isEmpty()) {
            return 0;
        }
        Iterable iterable = line;
        int initial$iv = x;
        boolean $i$f$fold = false;
        int accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void word;
            DrawableWord drawableWord = (DrawableWord)element$iv;
            int currentX = accumulator$iv;
            boolean bl = false;
            word.setPos(currentX, y);
            accumulator$iv = currentX + word.getWidth();
        }
        Iterator iterator2 = ((Iterable)line).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        DrawableWord word = (DrawableWord)iterator2.next();
        boolean bl = false;
        int n = word.getHeight();
        while (iterator2.hasNext()) {
            DrawableWord word2 = (DrawableWord)iterator2.next();
            $i$a$-maxOf-DrawableWordKt$initializeLine$2 = false;
            int n2 = word2.getHeight();
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    private static final List<List<DrawableWord>> splitLines(List<? extends DrawableWord> originalWords, int maxWidth) {
        List line = new ArrayList();
        List lines = new ArrayList();
        Ref.IntRef currentWidth = new Ref.IntRef();
        for (DrawableWord drawableWord : originalWords) {
            if (drawableWord instanceof DrawableSpace) {
                ((DrawableSpace)drawableWord).resetWidth();
            }
            if (currentWidth.element + drawableWord.getWidth() > maxWidth && !(drawableWord instanceof DrawableSpace)) {
                DrawableWordKt.splitLines$breakLine(currentWidth, lines, line);
            }
            DrawableWordKt.splitLines$addWordToLine(currentWidth, line, drawableWord);
            if (!(drawableWord instanceof DrawableBreak) && !Intrinsics.areEqual(drawableWord, CollectionsKt.last(originalWords))) continue;
            DrawableWordKt.splitLines$breakLine(currentWidth, lines, line);
        }
        return lines;
    }

    private static final boolean splitAndInitialize$isLastLine(List<? extends List<? extends DrawableWord>> splitLines, List<? extends DrawableWord> line) {
        return Intrinsics.areEqual(line, CollectionsKt.last(splitLines));
    }

    private static final boolean splitAndInitialize$hasBreak(List<? extends DrawableWord> line) {
        return line.contains(DrawableBreak.INSTANCE);
    }

    private static final void splitLines$breakLine(Ref.IntRef currentWidth, List<List<DrawableWord>> lines, List<DrawableWord> line) {
        currentWidth.element = 0;
        lines.add(CollectionsKt.toMutableList((Collection)line));
        line.clear();
    }

    private static final void splitLines$addWordToLine(Ref.IntRef currentWidth, List<DrawableWord> line, DrawableWord word) {
        currentWidth.element += word.getWidth();
        line.add(word);
    }
}

