/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTTagCompound;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawablePage;
import network.rs485.logisticspipes.gui.guidebook.DrawableParagraph;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.IPageData;
import network.rs485.logisticspipes.gui.guidebook.PageData;
import network.rs485.logisticspipes.guidebook.BookContents;
import network.rs485.logisticspipes.guidebook.PageInfoProvider;
import network.rs485.logisticspipes.util.ColorUtilKt;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001d\u001a\u00020\u00062\b\b\u0002\u0010\u001e\u001a\u00020\u001fJ&\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\u0016J\u0011\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0096\u0001J\u000e\u0010*\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#J\u0018\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0016J\u0006\u0010-\u001a\u00020\u001fJ2\u0010.\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\n\u00100\u001a\u000601R\u000202J\u000e\u00103\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u0000J\u0011\u00105\u001a\u00020!2\u0006\u00106\u001a\u000207H\u0096\u0001J\u000e\u00108\u001a\u00020!2\u0006\u00109\u001a\u00020#J\t\u0010:\u001a\u00020)H\u0096\u0001J\u0016\u0010;\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010<\u001a\u00020\u0016J\u0011\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020?H\u0096\u0001R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u0016X\u0096\u000f\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006@"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/Page;", "Lnetwork/rs485/logisticspipes/gui/guidebook/IPageData;", "data", "Lnetwork/rs485/logisticspipes/gui/guidebook/PageData;", "(Lnetwork/rs485/logisticspipes/gui/guidebook/PageData;)V", "color", "", "getColor", "()Ljava/lang/Integer;", "setColor", "(Ljava/lang/Integer;)V", "drawable", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawablePage;", "infoProvider", "Lnetwork/rs485/logisticspipes/guidebook/PageInfoProvider;", "page", "", "getPage", "()Ljava/lang/String;", "setPage", "(Ljava/lang/String;)V", "progress", "", "getProgress", "()F", "setProgress", "(F)V", "title", "getTitle", "cycleColor", "inverted", "", "draw", "", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "mouseX", "mouseY", "partialTicks", "fromTag", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "getExtraHeight", "getHovered", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "isBookmarkable", "mouseClicked", "mouseButton", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "pageEquals", "other", "read", "input", "Lnetwork/rs485/logisticspipes/util/LPDataInput;", "setDrawablesPosition", "area", "toTag", "updateScrollPosition", "currentProgress", "write", "output", "Lnetwork/rs485/logisticspipes/util/LPDataOutput;", "logisticspipes"})
public final class Page
implements IPageData {
    private final /* synthetic */ PageData $$delegate_0;
    @NotNull
    private final PageInfoProvider infoProvider;
    @NotNull
    private final DrawablePage drawable;

    public Page(@NotNull PageData data) {
        Intrinsics.checkNotNullParameter(data, "data");
        this.$$delegate_0 = data;
        this.infoProvider = BookContents.INSTANCE.get(this.getPage());
        this.drawable = BookContents.INSTANCE.getDrawablePage(this.getPage());
    }

    @Override
    @Nullable
    public Integer getColor() {
        return this.$$delegate_0.getColor();
    }

    @Override
    public void setColor(@Nullable Integer n) {
        this.$$delegate_0.setColor(n);
    }

    @Override
    @NotNull
    public String getPage() {
        return this.$$delegate_0.getPage();
    }

    @Override
    public void setPage(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.$$delegate_0.setPage(string);
    }

    @Override
    public float getProgress() {
        return this.$$delegate_0.getProgress();
    }

    @Override
    public void setProgress(float f) {
        this.$$delegate_0.setProgress(f);
    }

    @Override
    public void fromTag(@NotNull NBTTagCompound tag) {
        Intrinsics.checkNotNullParameter(tag, "tag");
        this.$$delegate_0.fromTag(tag);
    }

    @Override
    public void read(@NotNull LPDataInput input) {
        Intrinsics.checkNotNullParameter(input, "input");
        this.$$delegate_0.read(input);
    }

    @Override
    @NotNull
    public NBTTagCompound toTag() {
        return this.$$delegate_0.toTag();
    }

    @Override
    public void write(@NotNull LPDataOutput output) {
        Intrinsics.checkNotNullParameter(output, "output");
        this.$$delegate_0.write(output);
    }

    @NotNull
    public final String getTitle() {
        return this.infoProvider.getMetadata().getTitle();
    }

    public final void updateScrollPosition(@NotNull IRectangle visibleArea, float currentProgress) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        this.drawable.updateScrollPosition(visibleArea, currentProgress);
    }

    public final int getExtraHeight(@NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        return visibleArea.getRoundedHeight() < this.drawable.getHeight() ? this.drawable.getHeight() - visibleArea.getRoundedHeight() : 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void mouseClicked(float mouseX, float mouseY, int mouseButton, @NotNull IRectangle visibleArea, @NotNull GuiGuideBook.ActionListener guideActionListener) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
            Intrinsics.checkNotNullParameter(guideActionListener, "guideActionListener");
            Iterable iterable = this.drawable.getVisibleParagraphs(visibleArea);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                DrawableParagraph it = (DrawableParagraph)element$iv;
                boolean bl = false;
                if (!it.getAbsoluteBody().contains(mouseX, mouseY)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        DrawableParagraph drawableParagraph = v0;
        if (drawableParagraph != null) {
            drawableParagraph.inBookMouseClicked(mouseX, mouseY, mouseButton, guideActionListener);
        }
    }

    public final void setDrawablesPosition(@NotNull IRectangle area) {
        Intrinsics.checkNotNullParameter(area, "area");
        this.drawable.setWidth(area.getRoundedWidth());
        this.drawable.setPos(area.getRoundedX(), area.getRoundedY());
    }

    public final boolean isBookmarkable() {
        return this.infoProvider.getBookmarkable();
    }

    public final boolean pageEquals(@NotNull Page other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return Intrinsics.areEqual(this.getPage(), other.getPage());
    }

    public final int cycleColor(boolean inverted) {
        int n;
        Integer n2 = this.getColor();
        int it = n = ColorUtilKt.cycleMinecraftColorId(n2 != null ? n2 : 0, inverted);
        boolean bl = false;
        this.setColor(it);
        return n;
    }

    public static /* synthetic */ int cycleColor$default(Page page, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return page.cycleColor(bl);
    }

    public final void draw(@NotNull IRectangle visibleArea, float mouseX, float mouseY, float partialTicks) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        this.drawable.preRender(mouseX, mouseY, visibleArea);
        this.drawable.draw(mouseX, mouseY, partialTicks, visibleArea);
    }

    @Nullable
    public final Drawable getHovered(float mouseX, float mouseY) {
        return this.drawable.getHovered(mouseX, mouseY);
    }
}

