/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.util.math;

import logisticspipes.jetbrains.annotations.Contract;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.jvm.internal.DefaultConstructorMarker;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.util.IRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b!\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u00013B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B'\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB/\b\u0016\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\u000eB)\u0012\b\b\u0002\u0010\u0003\u001a\u00020\f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u0019\u001a\u00020\u0000J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\fH\u0007J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\fH\u0007J\u0010\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0004H\u0007J\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0004H\u0007J\u0010\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0001H\u0016J\b\u0010\u001f\u001a\u00020\u0000H\u0007J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fH\u0007J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fH\u0007J\u0010\u0010#\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fH\u0007J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\fH\u0016J\u0018\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\f2\u0006\u0010'\u001a\u00020\fH\u0007J\u0018\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u0004H\u0007J\u0010\u0010(\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0001H\u0007J\u0018\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\f2\u0006\u0010+\u001a\u00020\fH\u0007J\u0018\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020\u00042\u0006\u0010+\u001a\u00020\u0004H\u0007J\u000e\u0010,\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0001J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\fH\u0007J\u001c\u0010/\u001a\u00020\u00002\b\b\u0002\u00100\u001a\u00020\f2\b\b\u0002\u00101\u001a\u00020\fH\u0007J\u0010\u0010/\u001a\u00020\u00002\u0006\u0010/\u001a\u00020\u0004H\u0007J\u001c\u0010/\u001a\u00020\u00002\b\b\u0002\u00100\u001a\u00020\u00042\b\b\u0002\u00101\u001a\u00020\u0004H\u0007J\u0018\u00102\u001a\u00020\u00002\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\fH\u0016J\u0018\u00102\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0016R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u000e\u0010\u0003\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013\u00a8\u00064"}, d2={"Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "()V", "x", "", "y", "width", "height", "(IIII)V", "(II)V", "firstPoint", "Llogisticspipes/kotlin/Pair;", "", "secondPoint", "(Lkotlin/Pair;Lkotlin/Pair;)V", "_width", "_height", "(FFFF)V", "getHeight", "()F", "getWidth", "x0", "getX0", "y0", "getY0", "copy", "grow", "growX", "growY", "overlap", "rect", "resetPos", "scale", "multiplier", "scalePos", "scaleSize", "scaled", "setPos", "newX", "newY", "setPosFromRectangle", "setSize", "newWidth", "newHeight", "setSizeFromRectangle", "toString", "", "translate", "translateX", "translateY", "translated", "Companion", "logisticspipes"})
public final class MutableRectangle
implements IRectangle {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float x;
    private float y;
    private float _width;
    private float _height;

    public MutableRectangle(float x, float y, float _width, float _height) {
        this.x = x;
        this.y = y;
        this._width = _width;
        this._height = _height;
    }

    public /* synthetic */ MutableRectangle(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        this(f, f2, f3, f4);
    }

    @Override
    public float getWidth() {
        return this._width;
    }

    @Override
    public float getHeight() {
        return this._height;
    }

    @Override
    public float getX0() {
        return this.x;
    }

    @Override
    public float getY0() {
        return this.y;
    }

    public MutableRectangle() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public MutableRectangle(int x, int y, int width, int height) {
        this((float)x, (float)y, (float)width, (float)height);
    }

    public MutableRectangle(int width, int height) {
        this(0.0f, 0.0f, (float)width, (float)height);
    }

    public MutableRectangle(@NotNull Pair<Float, Float> firstPoint, @NotNull Pair<Float, Float> secondPoint) {
        Intrinsics.checkNotNullParameter(firstPoint, "firstPoint");
        Intrinsics.checkNotNullParameter(secondPoint, "secondPoint");
        this(((Number)firstPoint.getFirst()).floatValue(), ((Number)firstPoint.getSecond()).floatValue(), ((Number)secondPoint.getFirst()).floatValue() - ((Number)firstPoint.getFirst()).floatValue(), ((Number)secondPoint.getSecond()).floatValue() - ((Number)firstPoint.getSecond()).floatValue());
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle setSize(float newWidth, float newHeight) {
        MutableRectangle mutableRectangle;
        MutableRectangle $this$setSize_u24lambda_u2d0 = mutableRectangle = this;
        boolean bl = false;
        $this$setSize_u24lambda_u2d0._width = newWidth;
        $this$setSize_u24lambda_u2d0._height = newHeight;
        return mutableRectangle;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle setSize(int newWidth, int newHeight) {
        return this.setSize((float)newWidth, (float)newHeight);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle grow(float growX, float growY) {
        MutableRectangle mutableRectangle;
        MutableRectangle $this$grow_u24lambda_u2d1 = mutableRectangle = this;
        boolean bl = false;
        $this$grow_u24lambda_u2d1._width += growX;
        $this$grow_u24lambda_u2d1._height += growY;
        return mutableRectangle;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle grow(float grow) {
        return this.grow(grow, grow);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle grow(int growX, int growY) {
        return this.grow((float)growX, (float)growY);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle grow(int grow) {
        return this.grow(grow, grow);
    }

    @NotNull
    public final MutableRectangle setSizeFromRectangle(@NotNull IRectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return this.setSize(rect.getWidth(), rect.getHeight());
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle scaleSize(float multiplier) {
        MutableRectangle mutableRectangle;
        MutableRectangle $this$scaleSize_u24lambda_u2d2 = mutableRectangle = this;
        boolean bl = false;
        $this$scaleSize_u24lambda_u2d2._width *= multiplier;
        $this$scaleSize_u24lambda_u2d2._height *= multiplier;
        return mutableRectangle;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle setPos(float newX, float newY) {
        MutableRectangle mutableRectangle;
        MutableRectangle $this$setPos_u24lambda_u2d3 = mutableRectangle = this;
        boolean bl = false;
        $this$setPos_u24lambda_u2d3.x = newX;
        $this$setPos_u24lambda_u2d3.y = newY;
        return mutableRectangle;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle setPos(int newX, int newY) {
        return this.setPos((float)newX, (float)newY);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle setPosFromRectangle(@NotNull IRectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return this.setPos(rect.getX0(), rect.getY0());
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle resetPos() {
        MutableRectangle mutableRectangle;
        MutableRectangle $this$resetPos_u24lambda_u2d4 = mutableRectangle = this;
        boolean bl = false;
        $this$resetPos_u24lambda_u2d4.setPos(0.0f, 0.0f);
        return mutableRectangle;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle scalePos(float multiplier) {
        MutableRectangle mutableRectangle;
        MutableRectangle $this$scalePos_u24lambda_u2d5 = mutableRectangle = this;
        boolean bl = false;
        $this$scalePos_u24lambda_u2d5.x *= multiplier;
        $this$scalePos_u24lambda_u2d5.y *= multiplier;
        return mutableRectangle;
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle translate(float translate) {
        return this.translate(translate, translate);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle translate(float translateX, float translateY) {
        MutableRectangle mutableRectangle;
        MutableRectangle $this$translate_u24lambda_u2d6 = mutableRectangle = this;
        boolean bl = false;
        $this$translate_u24lambda_u2d6.x += translateX;
        $this$translate_u24lambda_u2d6.y += translateY;
        return mutableRectangle;
    }

    public static /* synthetic */ MutableRectangle translate$default(MutableRectangle mutableRectangle, float f, float f2, int n, Object object) {
        if ((n & 1) != 0) {
            f = 0.0f;
        }
        if ((n & 2) != 0) {
            f2 = 0.0f;
        }
        return mutableRectangle.translate(f, f2);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle translate(int translate) {
        return this.translate(translate, translate);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle translate(int translateX, int translateY) {
        MutableRectangle mutableRectangle;
        MutableRectangle $this$translate_u24lambda_u2d7 = mutableRectangle = this;
        boolean bl = false;
        $this$translate_u24lambda_u2d7.x += (float)translateX;
        $this$translate_u24lambda_u2d7.y += (float)translateY;
        return mutableRectangle;
    }

    public static /* synthetic */ MutableRectangle translate$default(MutableRectangle mutableRectangle, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        return mutableRectangle.translate(n, n2);
    }

    @Override
    @NotNull
    public MutableRectangle translated(float translateX, float translateY) {
        return this.copy().translate(translateX, translateY);
    }

    @Override
    @NotNull
    public MutableRectangle translated(int translateX, int translateY) {
        return this.copy().translate(translateX, translateY);
    }

    @Contract(value="_ -> this", mutates="this")
    @NotNull
    public final MutableRectangle scale(float multiplier) {
        return this.scalePos(multiplier).scaleSize(multiplier);
    }

    @Override
    @NotNull
    public MutableRectangle scaled(float multiplier) {
        return this.copy().scalePos(multiplier).scaleSize(multiplier);
    }

    @Override
    @NotNull
    public MutableRectangle overlap(@NotNull IRectangle rect) {
        Intrinsics.checkNotNullParameter(rect, "rect");
        return new MutableRectangle(TuplesKt.to(Float.valueOf(Math.max(this.x, rect.getX0())), Float.valueOf(Math.max(this.y, rect.getY0()))), TuplesKt.to(Float.valueOf(Math.min(this.getX1(), rect.getX1())), Float.valueOf(Math.min(this.getY1(), rect.getY1()))));
    }

    @NotNull
    public final MutableRectangle copy() {
        return new MutableRectangle(this.x, this.y, this._width, this._height);
    }

    @NotNull
    public String toString() {
        return "Rectangle(x = " + this.x + ", y = " + this.y + ", width = " + this._width + ", height = " + this._height + ')';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lnetwork/rs485/logisticspipes/util/math/MutableRectangle$Companion;", "", "()V", "fromRectangle", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "rect", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "logisticspipes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MutableRectangle fromRectangle(@NotNull IRectangle rect) {
            Intrinsics.checkNotNullParameter(rect, "rect");
            return new MutableRectangle(rect.getX0(), rect.getY0(), rect.getWidth(), rect.getHeight());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

