/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.math.BlockPos;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \u000f*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u000fB\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000b\u001a\u00028\u00002\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\n8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lnet/minecraft/inventory/ContainerType;", "T", "Lnet/minecraft/inventory/Container;", "", "factory", "Lkotlin/Function2;", "Lnet/minecraft/entity/player/EntityPlayer;", "Lnet/minecraft/util/math/BlockPos;", "(Lkotlin/jvm/functions/Function2;)V", "id", "", "create", "player", "pos", "(Lnet/minecraft/entity/player/EntityPlayer;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraft/inventory/Container;", "Companion", "WitcheryResurrected"})
public final class ContainerType<T extends Container> {
    @JvmField
    public final int id;
    private final Function2<EntityPlayer, BlockPos, T> factory;
    private static final AtomicInteger CURRENT_ID;
    public static final Companion Companion;

    @NotNull
    public final T create(@NotNull EntityPlayer player, @NotNull BlockPos pos) {
        Intrinsics.checkParameterIsNotNull(player, "player");
        Intrinsics.checkParameterIsNotNull(pos, "pos");
        return (T)((Container)this.factory.invoke(player, pos));
    }

    public ContainerType(@NotNull Function2<? super EntityPlayer, ? super BlockPos, ? extends T> factory2) {
        Intrinsics.checkParameterIsNotNull(factory2, "factory");
        this.factory = factory2;
        this.id = CURRENT_ID.getAndIncrement();
    }

    static {
        Companion = new Companion(null);
        CURRENT_ID = new AtomicInteger();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lnet/minecraft/inventory/ContainerType$Companion;", "", "()V", "CURRENT_ID", "Ljava/util/concurrent/atomic/AtomicInteger;", "WitcheryResurrected"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

