/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\bf\u0018\u0000 \f2\u00020\u0001:\u0001\fJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0003H\u0017\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006\r"}, d2={"Lnet/minecraft/item/Dyeable;", "", "getColor", "", "stack", "Lnet/minecraft/item/ItemStack;", "hasColor", "", "removeColor", "", "setColor", "color", "Companion", "WitcheryResurrected"})
public interface Dyeable {
    public static final Companion Companion = net.minecraft.item.Dyeable$Companion.$$INSTANCE;

    @JvmDefault
    default public boolean hasColor(@NotNull ItemStack stack) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        NBTTagCompound tag = stack.func_77978_p();
        return tag != null && tag.func_150297_b("display", 10) && tag.func_74775_l("display").func_150297_b("color", 3);
    }

    @JvmDefault
    default public int getColor(@NotNull ItemStack stack) {
        NBTTagCompound display;
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (display = tag.func_74775_l("display")).func_150297_b("color", 3)) {
            return display.func_74762_e("color");
        }
        return 10511680;
    }

    @JvmDefault
    default public void removeColor(@NotNull ItemStack stack) {
        NBTTagCompound display;
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && (display = tag.func_74775_l("display")).func_74764_b("color")) {
            display.func_82580_o("color");
        }
    }

    @JvmDefault
    default public void setColor(@NotNull ItemStack stack, int color2) {
        Intrinsics.checkParameterIsNotNull(stack, "stack");
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        }
        NBTTagCompound display = tag.func_74775_l("display");
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)display);
        }
        display.func_74768_a("color", color2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a8\u0006\t"}, d2={"Lnet/minecraft/item/Dyeable$Companion;", "", "()V", "dyeItem", "Lnet/minecraft/item/ItemStack;", "stack", "dyes", "", "Lnet/minecraft/item/EnumDyeColor;", "WitcheryResurrected"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        @NotNull
        public final ItemStack dyeItem(@NotNull ItemStack stack, @NotNull List<? extends EnumDyeColor> dyes) {
            ItemStack itemStack;
            Intrinsics.checkParameterIsNotNull(stack, "stack");
            Intrinsics.checkParameterIsNotNull(dyes, "dyes");
            ItemStack result2 = ItemStack.field_190927_a;
            int[] aint = new int[3];
            int i = 0;
            int j = 0;
            Dyeable dyeableItem = null;
            Item item = stack.func_77973_b();
            if (item instanceof Dyeable) {
                dyeableItem = (Dyeable)item;
                ItemStack itemStack2 = result2 = stack.func_77946_l();
                Intrinsics.checkExpressionValueIsNotNull(itemStack2, "result");
                itemStack2.func_190920_e(1);
                if (dyeableItem.hasColor(stack)) {
                    int n = dyeableItem.getColor(result2);
                    float f = (float)(n >> 16 & 0xFF) / 255.0f;
                    float f1 = (float)(n >> 8 & 0xFF) / 255.0f;
                    float f2 = (float)(n & 0xFF) / 255.0f;
                    i = (int)((float)i + RangesKt.coerceAtLeast(f, RangesKt.coerceAtLeast(f1, f2)) * 255.0f);
                    aint[0] = (int)((float)aint[0] + f * 255.0f);
                    aint[1] = (int)((float)aint[1] + f1 * 255.0f);
                    aint[2] = (int)((float)aint[2] + f2 * 255.0f);
                    ++j;
                }
                for (EnumDyeColor enumDyeColor : dyes) {
                    float[] afloat = enumDyeColor.func_193349_f();
                    int i2 = (int)(afloat[0] * 255.0f);
                    int l = (int)(afloat[1] * 255.0f);
                    int i1 = (int)(afloat[2] * 255.0f);
                    i += RangesKt.coerceAtLeast(i2, RangesKt.coerceAtLeast(l, i1));
                    aint[0] = aint[0] + i2;
                    aint[1] = aint[1] + l;
                    aint[2] = aint[2] + i1;
                    ++j;
                }
            }
            if (dyeableItem == null) {
                ItemStack itemStack3 = ItemStack.field_190927_a;
                itemStack = itemStack3;
                Intrinsics.checkExpressionValueIsNotNull(itemStack3, "ItemStack.EMPTY");
            } else {
                int n = aint[0] / j;
                int k1 = aint[1] / j;
                int l1 = aint[2] / j;
                float f3 = (float)i / (float)j;
                float f4 = RangesKt.coerceAtLeast(n, RangesKt.coerceAtLeast(k1, l1));
                int n2 = (int)((float)n * f3 / f4);
                k1 = (int)((float)k1 * f3 / f4);
                l1 = (int)((float)l1 * f3 / f4);
                int j2 = (n2 << 8) + k1;
                j2 = (j2 << 8) + l1;
                ItemStack itemStack4 = result2;
                Intrinsics.checkExpressionValueIsNotNull(itemStack4, "result");
                dyeableItem.setColor(itemStack4, j2);
                itemStack = result2;
            }
            return itemStack;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

