/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.recipe.RecipeType;
import net.minecraft.resources.JsonReloadListener;
import net.minecraft.resources.RecipeManager;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.msrandom.witchery.recipe.WitcheryRecipe;
import net.msrandom.witchery.recipe.WitcheryRecipeSerializer;
import net.msrandom.witchery.registry.RegistryWrappersKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 (2\u00020\u0001:\u0001(B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u000b2\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0013JI\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\b\b\u0000\u0010\u0017*\u00020\u0018\"\u000e\b\u0001\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00170\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00052\u0006\u0010\u001a\u001a\u0002H\u00172\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\u001dJ\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00152\u0006\u0010\u001e\u001a\u00020\u0007JI\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \"\b\b\u0000\u0010\u0017*\u00020\u0018\"\u000e\b\u0001\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00170\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00052\u0006\u0010\u001a\u001a\u0002H\u00172\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010\"J\u0010\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0$JB\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\b0\u0006\"\b\b\u0000\u0010\u0017*\u00020\u0018\"\u000e\b\u0001\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00170\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0005H\u0002JI\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u00160%\"\b\b\u0000\u0010\u0017*\u00020\u0018\"\u000e\b\u0001\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00170\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00052\u0006\u0010\u001a\u001a\u0002H\u00172\u0006\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\u0002\u0010&J4\u0010'\u001a\b\u0012\u0004\u0012\u0002H\u00160%\"\b\b\u0000\u0010\u0017*\u00020\u0018\"\u000e\b\u0001\u0010\u0016*\b\u0012\u0004\u0012\u0002H\u00170\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0005RR\u0010\u0003\u001aF\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u00060\u0004j\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lnet/minecraft/resources/RecipeManager;", "Lnet/minecraft/resources/JsonReloadListener;", "()V", "recipes", "Ljava/util/HashMap;", "Lnet/minecraft/recipe/RecipeType;", "", "Lnet/minecraft/util/ResourceLocation;", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "Lkotlin/collections/HashMap;", "apply", "", "value", "", "Lcom/google/gson/JsonElement;", "resourceManager", "Lnet/minecraft/resources/ResourceManager;", "deserializeRecipes", "newRecipes", "", "getRecipe", "Ljava/util/Optional;", "T", "C", "Lnet/minecraft/inventory/IInventory;", "recipeType", "inventoryIn", "worldIn", "Lnet/minecraft/world/World;", "(Lnet/minecraft/recipe/RecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/Optional;", "recipeId", "getRecipeNonNull", "Lnet/minecraft/util/NonNullList;", "Lnet/minecraft/item/ItemStack;", "(Lnet/minecraft/recipe/RecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Lnet/minecraft/util/NonNullList;", "getRecipes", "", "", "(Lnet/minecraft/recipe/RecipeType;Lnet/minecraft/inventory/IInventory;Lnet/minecraft/world/World;)Ljava/util/List;", "getRecipesForType", "Companion", "WitcheryResurrected"})
public final class RecipeManager
extends JsonReloadListener {
    private final HashMap<RecipeType<?>, Map<ResourceLocation, WitcheryRecipe<?>>> recipes;
    private static final Gson GSON;
    private static final Logger LOGGER;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Override
    protected void apply(@NotNull Map<ResourceLocation, ? extends JsonElement> value, @NotNull ResourceManager resourceManager) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(resourceManager, "resourceManager");
        this.recipes.clear();
        ResourceLocation resourceLocation = value;
        boolean bl = false;
        Iterator<Map.Entry<ResourceLocation, ? extends JsonElement>> iterator2 = resourceLocation.entrySet().iterator();
        while (iterator2.hasNext()) {
            void id;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry2;
            Map.Entry<ResourceLocation, ? extends JsonElement> entry3 = entry2 = iterator2.next();
            boolean bl2 = false;
            resourceLocation = entry3.getKey();
            entry3 = entry2;
            bl2 = false;
            JsonElement json = entry3.getValue();
            try {
                JsonObject jsonObject = JsonUtils.func_151210_l((JsonElement)json, (String)"top element");
                Intrinsics.checkExpressionValueIsNotNull(jsonObject, "JsonUtils.getJsonObject(json, \"top element\")");
                WitcheryRecipe<?> recipe = Companion.deserializeRecipe((ResourceLocation)id, jsonObject);
                Map<ResourceLocation, WitcheryRecipe<?>> map2 = this.recipes.computeIfAbsent(recipe.getType(), apply.1.INSTANCE);
                Intrinsics.checkExpressionValueIsNotNull(map2, "recipes.computeIfAbsent(\u2026ipe.type) { hashMapOf() }");
                map2.put((ResourceLocation)id, recipe);
            }
            catch (RuntimeException exception) {
                LOGGER.error("Parsing error loading recipe {}", (Object)id, (Object)exception);
            }
        }
        LOGGER.info("Loaded {} recipes", (Object)this.recipes.size());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <C extends IInventory, T extends WitcheryRecipe<C>> Optional<T> getRecipe(@NotNull RecipeType<T> recipeType, @NotNull C inventoryIn, @NotNull World worldIn) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(recipeType, "recipeType");
        Intrinsics.checkParameterIsNotNull(inventoryIn, "inventoryIn");
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Iterable $this$flatMap$iv = this.getRecipes(recipeType).values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Object> list2;
            WitcheryRecipe it = (WitcheryRecipe)((Object)element$iv$iv);
            boolean bl = false;
            if (it.canCraft(inventoryIn, worldIn)) {
                WitcheryRecipe witcheryRecipe = it;
                if (witcheryRecipe == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                list2 = CollectionsKt.listOf(witcheryRecipe);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Optional optional = Optional.ofNullable(CollectionsKt.firstOrNull((List)destination$iv$iv));
        Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.ofNullable(\n   \u2026 .firstOrNull()\n        )");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <C extends IInventory, T extends WitcheryRecipe<C>> List<T> getRecipesForType(@NotNull RecipeType<T> recipeType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(recipeType, "recipeType");
        Iterable $this$map$iv = this.getRecipes(recipeType).values();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void var12_12;
            void it;
            WitcheryRecipe witcheryRecipe = (WitcheryRecipe)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it == null) {
                throw new TypeCastException("null cannot be cast to non-null type T");
            }
            collection.add(var12_12);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <C extends IInventory, T extends WitcheryRecipe<C>> List<T> getRecipes(@NotNull RecipeType<T> recipeType, @NotNull C inventoryIn, @NotNull World worldIn) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(recipeType, "recipeType");
        Intrinsics.checkParameterIsNotNull(inventoryIn, "inventoryIn");
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Iterable $this$flatMap$iv = this.getRecipes(recipeType).values();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<Object> list2;
            WitcheryRecipe it = (WitcheryRecipe)((Object)element$iv$iv);
            boolean bl = false;
            if (it.canCraft(inventoryIn, worldIn)) {
                WitcheryRecipe witcheryRecipe = it;
                if (witcheryRecipe == null) {
                    throw new TypeCastException("null cannot be cast to non-null type T");
                }
                list2 = CollectionsKt.listOf(witcheryRecipe);
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        iterable = $this$sortedBy$iv;
        boolean bl = false;
        Comparator comparator = new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                WitcheryRecipe it = (WitcheryRecipe)((Object)a);
                boolean bl2 = false;
                ItemStack itemStack = it.func_77571_b();
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "it.recipeOutput");
                it = (WitcheryRecipe)((Object)b);
                Comparable comparable = (Comparable)((Object)itemStack.func_77977_a());
                bl2 = false;
                ItemStack itemStack2 = it.func_77571_b();
                Intrinsics.checkExpressionValueIsNotNull(itemStack2, "it.recipeOutput");
                String string = itemStack2.func_77977_a();
                return ComparisonsKt.compareValues(comparable, (Comparable)((Object)string));
            }
        };
        return CollectionsKt.sortedWith(iterable, comparator);
    }

    private final <C extends IInventory, T extends WitcheryRecipe<C>> Map<ResourceLocation, WitcheryRecipe<C>> getRecipes(RecipeType<T> recipeType) {
        return (Map)RecipeManager.Companion.cast(this.recipes.getOrDefault(recipeType, Collections.emptyMap()));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <C extends IInventory, T extends WitcheryRecipe<C>> NonNullList<ItemStack> getRecipeNonNull(@NotNull RecipeType<T> recipeType, @NotNull C inventoryIn, @NotNull World worldIn) {
        Intrinsics.checkParameterIsNotNull(recipeType, "recipeType");
        Intrinsics.checkParameterIsNotNull(inventoryIn, "inventoryIn");
        Intrinsics.checkParameterIsNotNull(worldIn, "worldIn");
        Optional<T> optional = this.getRecipe(recipeType, inventoryIn, worldIn);
        NonNullList list2 = NonNullList.func_191197_a((int)inventoryIn.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (optional.isPresent()) {
            int n = 0;
            NonNullList nonNullList = list2;
            Intrinsics.checkExpressionValueIsNotNull(nonNullList, "list");
            int n2 = ((Collection)nonNullList).size();
            while (n < n2) {
                void i;
                ItemStack stack;
                ItemStack itemStack = stack = inventoryIn.func_70301_a((int)i);
                Intrinsics.checkExpressionValueIsNotNull(itemStack, "stack");
                if (itemStack.func_77973_b().hasContainerItem(stack)) {
                    list2.set((int)i, (Object)stack.func_77973_b().getContainerItem(stack));
                }
                ++i;
            }
        } else {
            NonNullList nonNullList = list2;
            Intrinsics.checkExpressionValueIsNotNull(nonNullList, "list");
            int n = ((Collection)nonNullList).size();
            for (int i = 0; i < n; ++i) {
                list2.set(i, (Object)inventoryIn.func_70301_a(i));
            }
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Optional<WitcheryRecipe<?>> getRecipe(@NotNull ResourceLocation recipeId) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull(recipeId, "recipeId");
        Collection<Map<ResourceLocation, WitcheryRecipe<?>>> collection = this.recipes.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "recipes.values");
        Iterable $this$map$iv = collection;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map map2 = (Map)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            WitcheryRecipe witcheryRecipe = (WitcheryRecipe)((Object)it.get(recipeId));
            collection2.add(witcheryRecipe);
        }
        Optional<WitcheryRecipe<?>> optional = Optional.ofNullable(CollectionsKt.firstOrNull((List)destination$iv$iv));
        Intrinsics.checkExpressionValueIsNotNull(optional, "Optional.ofNullable(reci\u2026ecipeId] }.firstOrNull())");
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<WitcheryRecipe<?>> getRecipes() {
        void $this$flatMapTo$iv$iv;
        Collection<Map<ResourceLocation, WitcheryRecipe<?>>> collection = this.recipes.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, "recipes.values");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Map it = (Map)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.values();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.toHashSet((List)destination$iv$iv);
    }

    public final void deserializeRecipes(@NotNull Iterable<? extends WitcheryRecipe<?>> newRecipes) {
        Intrinsics.checkParameterIsNotNull(newRecipes, "newRecipes");
        this.recipes.clear();
        for (WitcheryRecipe<?> recipe : newRecipes) {
            boolean bl = this.recipes.computeIfAbsent(recipe.getType(), deserializeRecipes.1.INSTANCE).put(recipe.getId(), recipe) == null;
            boolean bl2 = false;
            boolean bl3 = false;
            if (bl) continue;
            boolean bl4 = false;
            String string = "Duplicate recipe ignored with ID " + recipe.getId();
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public RecipeManager() {
        Gson gson = GSON;
        Intrinsics.checkExpressionValueIsNotNull(gson, "GSON");
        super(gson, "recipes");
        RecipeManager recipeManager = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        recipeManager.recipes = hashMap;
    }

    static {
        Companion = new Companion(null);
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        LOGGER = LogManager.getLogger((String)("witchery/minecraft/" + Reflection.getOrCreateKotlinClass(RecipeManager.class).getSimpleName()));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\b\u001a\u0002H\t\"\u0004\b\u0000\u0010\n\"\u0004\b\u0001\u0010\t2\u0006\u0010\u000b\u001a\u0002H\nH\u0002\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnet/minecraft/resources/RecipeManager$Companion;", "", "()V", "GSON", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "cast", "T", "F", "from", "(Ljava/lang/Object;)Ljava/lang/Object;", "deserializeRecipe", "Lnet/msrandom/witchery/recipe/WitcheryRecipe;", "recipeId", "Lnet/minecraft/util/ResourceLocation;", "json", "Lcom/google/gson/JsonObject;", "WitcheryResurrected"})
    public static final class Companion {
        private final <F, T> T cast(F from) {
            return (T)from;
        }

        @NotNull
        public final WitcheryRecipe<?> deserializeRecipe(@NotNull ResourceLocation recipeId, @NotNull JsonObject json) {
            Intrinsics.checkParameterIsNotNull(recipeId, "recipeId");
            Intrinsics.checkParameterIsNotNull(json, "json");
            String s = JsonUtils.func_151200_h((JsonObject)json, (String)"type");
            WitcheryRecipeSerializer witcheryRecipeSerializer = (WitcheryRecipeSerializer)RegistryWrappersKt.getRECIPE_SERIALIZER_REGISTRY().get(new ResourceLocation(s));
            if (witcheryRecipeSerializer == null) {
                throw (Throwable)new JsonSyntaxException("Invalid or unsupported recipe type '" + s + '\'');
            }
            WitcheryRecipeSerializer serializer = witcheryRecipeSerializer;
            Object t = serializer.read(recipeId, json);
            if (t == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.msrandom.witchery.recipe.WitcheryRecipe<*>");
            }
            return (WitcheryRecipe)((Object)t);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

