/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import net.minecraft.resources.Resource;
import net.minecraft.resources.ResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.msrandom.witchery.WitcheryResurrected;
import net.msrandom.witchery.util.WitcheryUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/minecraft/resources/ResourceManager;", "", "world", "Lnet/minecraft/world/WorldServer;", "(Lnet/minecraft/world/WorldServer;)V", "findResources", "", "Lnet/minecraft/util/ResourceLocation;", "resourceType", "", "pathPredicate", "Ljava/util/function/Predicate;", "getResource", "Lnet/minecraft/resources/Resource;", "id", "WitcheryResurrected"})
public final class ResourceManager {
    private final WorldServer world;

    @NotNull
    public final Resource getResource(@NotNull ResourceLocation id) throws IOException {
        Intrinsics.checkParameterIsNotNull(id, "id");
        String string = id.func_110623_a();
        Intrinsics.checkExpressionValueIsNotNull(string, "id.path");
        int firstSeparator = StringsKt.indexOf$default((CharSequence)string, "/", 0, false, 6, null);
        String string2 = id.func_110623_a();
        Intrinsics.checkExpressionValueIsNotNull(string2, "id.path");
        String string3 = string2;
        int n = 0;
        int n2 = 0;
        String string4 = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n, firstSeparator);
        Intrinsics.checkExpressionValueIsNotNull(string5, "(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String resourceType = string5;
        String string6 = id.func_110623_a();
        Intrinsics.checkExpressionValueIsNotNull(string6, "id.path");
        String string7 = string6;
        n2 = firstSeparator + 1;
        boolean bl = false;
        String string8 = string7;
        if (string8 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string9 = string8.substring(n2);
        Intrinsics.checkExpressionValueIsNotNull(string9, "(this as java.lang.String).substring(startIndex)");
        String path = string9;
        WorldServer worldServer = this.world;
        if (worldServer != null) {
            string7 = worldServer;
            n2 = 0;
            bl = false;
            String it = string7;
            boolean bl2 = false;
            ISaveHandler iSaveHandler = it.func_72860_G();
            Intrinsics.checkExpressionValueIsNotNull(iSaveHandler, "it.saveHandler");
            File file2 = new File(iSaveHandler.func_75765_b(), "data/" + resourceType + '/' + id.func_110624_b() + '/' + path);
            if (file2.exists()) {
                return new Resource(new FileInputStream(file2));
            }
        }
        InputStream inputStream = WitcheryResurrected.class.getResourceAsStream("/data/" + id.func_110624_b() + '/' + id.func_110623_a());
        if (inputStream == null) {
            throw (Throwable)new FileNotFoundException(id.toString());
        }
        return new Resource(inputStream);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<ResourceLocation> findResources(@NotNull String resourceType, @NotNull Predicate<String> pathPredicate) {
        Intrinsics.checkParameterIsNotNull(resourceType, "resourceType");
        Intrinsics.checkParameterIsNotNull(pathPredicate, "pathPredicate");
        TreeSet<ResourceLocation> set2 = SetsKt.sortedSetOf(new ResourceLocation[0]);
        findResources.1 $fun$relativize$1 = findResources.1.INSTANCE;
        WorldServer worldServer = this.world;
        if (worldServer != null) {
            WorldServer worldServer2 = worldServer;
            boolean bl = false;
            boolean bl2 = false;
            WorldServer serverWorld = worldServer2;
            boolean bl3 = false;
            ISaveHandler iSaveHandler = serverWorld.func_72860_G();
            Intrinsics.checkExpressionValueIsNotNull(iSaveHandler, "serverWorld.saveHandler");
            Path dataPath = iSaveHandler.func_75765_b().toPath().resolve("data").resolve(resourceType);
            if (Files.exists(dataPath, new LinkOption[0])) {
                Iterator iterator2 = Files.list(dataPath).iterator();
                while (iterator2.hasNext()) {
                    Path namespacedDirectory = (Path)iterator2.next();
                    Iterator iterator3 = Files.walk(namespacedDirectory, new FileVisitOption[0]).iterator();
                    while (iterator3.hasNext()) {
                        Path path = (Path)iterator3.next();
                        if (!(Intrinsics.areEqual(path, namespacedDirectory) ^ true) || StringsKt.endsWith$default(((Object)path).toString(), ".mcmeta", false, 2, null) || !pathPredicate.test(((Object)path).toString())) continue;
                        Path path2 = dataPath;
                        Intrinsics.checkExpressionValueIsNotNull(path2, "dataPath");
                        Path path3 = namespacedDirectory;
                        Intrinsics.checkExpressionValueIsNotNull(path3, "namespacedDirectory");
                        String string = findResources.1.INSTANCE.invoke(path2, path3);
                        StringBuilder stringBuilder = new StringBuilder().append(resourceType).append('/');
                        Path path4 = path;
                        Intrinsics.checkExpressionValueIsNotNull(path4, "path");
                        set2.add(new ResourceLocation(string, stringBuilder.append(findResources.1.INSTANCE.invoke(namespacedDirectory, path4)).toString()));
                    }
                }
            }
        }
        Loader loader = Loader.instance();
        Intrinsics.checkExpressionValueIsNotNull(loader, "Loader.instance()");
        for (ModContainer modContainer : loader.getActiveModList()) {
            void root;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            StringBuilder stringBuilder = new StringBuilder().append("/data/");
            ModContainer modContainer2 = modContainer;
            Intrinsics.checkExpressionValueIsNotNull(modContainer2, "modContainer");
            WitcheryUtils.iterate(WitcheryResurrected.class, stringBuilder.append(modContainer2.getModId()).append('/').append(resourceType).toString(), (Function1<? super Path, Unit>)new Function1<Path, Unit>(pathPredicate, set2, modContainer, resourceType, (Ref.ObjectRef)root){
                final /* synthetic */ Predicate $pathPredicate;
                final /* synthetic */ TreeSet $set;
                final /* synthetic */ ModContainer $modContainer;
                final /* synthetic */ String $resourceType;
                final /* synthetic */ Ref.ObjectRef $root;

                public final void invoke(@NotNull Path it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    if (!it.endsWith(".mcmeta") && this.$pathPredicate.test(((Object)it).toString())) {
                        ModContainer modContainer = this.$modContainer;
                        Intrinsics.checkExpressionValueIsNotNull(modContainer, "modContainer");
                        String string = modContainer.getModId();
                        StringBuilder stringBuilder = new StringBuilder().append(this.$resourceType).append('/');
                        T t = this.$root.element;
                        if (t == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("root");
                        }
                        this.$set.add(new ResourceLocation(string, stringBuilder.append(findResources.1.INSTANCE.invoke((Path)t, it)).toString()));
                    }
                }
                {
                    this.$pathPredicate = predicate2;
                    this.$set = treeSet;
                    this.$modContainer = modContainer;
                    this.$resourceType = string;
                    this.$root = objectRef;
                    super(1);
                }
            }, (Function1<? super Path, Unit>)new Function1<Path, Unit>((Ref.ObjectRef)root){
                final /* synthetic */ Ref.ObjectRef $root;

                public final void invoke(@NotNull Path it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    this.$root.element = it;
                }
                {
                    this.$root = objectRef;
                    super(1);
                }
            });
        }
        return set2;
    }

    public ResourceManager(@Nullable WorldServer world) {
        this.world = world;
    }
}

