/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.loot.conditions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Random;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.loot.conditions.StatePropertiesPredicate;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lnet/minecraft/world/loot/conditions/BlockStatePropertyCondition;", "Lnet/minecraft/world/storage/loot/conditions/LootCondition;", "block", "Lnet/minecraft/block/Block;", "properties", "Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate;", "(Lnet/minecraft/block/Block;Lnet/minecraft/world/loot/conditions/StatePropertiesPredicate;)V", "testCondition", "", "rand", "Ljava/util/Random;", "lootContext", "Lnet/minecraft/world/storage/loot/LootContext;", "Companion", "Serializer", "WitcheryResurrected"})
public final class BlockStatePropertyCondition
implements LootCondition {
    private final Block block;
    private final StatePropertiesPredicate properties;
    public static final Companion Companion = new Companion(null);

    public boolean func_186618_a(@NotNull Random rand, @NotNull LootContext lootContext) {
        IBlockState state;
        Intrinsics.checkParameterIsNotNull(rand, "rand");
        Intrinsics.checkParameterIsNotNull(lootContext, "lootContext");
        Entity entity = lootContext.func_186495_b();
        if (entity == null) {
            throw new TypeCastException("null cannot be cast to non-null type net.minecraft.entity.player.EntityPlayer");
        }
        EntityPlayer player = (EntityPlayer)entity;
        NBTTagCompound data2 = player.getEntityData();
        if (!data2.func_74764_b("LastMinedState")) {
            return false;
        }
        IBlockState iBlockState = state = NBTUtil.func_190008_d((NBTTagCompound)data2.func_74775_l("LastMinedState"));
        Intrinsics.checkExpressionValueIsNotNull(iBlockState, "state");
        return this.block == iBlockState.func_177230_c() && this.properties.matches(state);
    }

    private BlockStatePropertyCondition(Block block, StatePropertiesPredicate properties2) {
        this.block = block;
        this.properties = properties2;
    }

    static {
        LootConditionManager.func_186639_a((LootCondition.Serializer)new Serializer());
    }

    public /* synthetic */ BlockStatePropertyCondition(Block block, StatePropertiesPredicate properties2, DefaultConstructorMarker $constructor_marker) {
        this(block, properties2);
    }

    @JvmStatic
    public static final void init() {
        Companion.init();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lnet/minecraft/world/loot/conditions/BlockStatePropertyCondition$Serializer;", "Lnet/minecraft/world/storage/loot/conditions/LootCondition$Serializer;", "Lnet/minecraft/world/loot/conditions/BlockStatePropertyCondition;", "()V", "deserialize", "json", "Lcom/google/gson/JsonObject;", "context", "Lcom/google/gson/JsonDeserializationContext;", "serialize", "", "value", "Lcom/google/gson/JsonSerializationContext;", "WitcheryResurrected"})
    public static final class Serializer
    extends LootCondition.Serializer<BlockStatePropertyCondition> {
        public void serialize(@NotNull JsonObject json, @NotNull BlockStatePropertyCondition value, @NotNull JsonSerializationContext context) {
            Intrinsics.checkParameterIsNotNull(json, "json");
            Intrinsics.checkParameterIsNotNull(value, "value");
            Intrinsics.checkParameterIsNotNull(context, "context");
            json.addProperty("block", String.valueOf(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)value.block)));
            json.add("properties", value.properties.toJsonElement());
        }

        @NotNull
        public BlockStatePropertyCondition deserialize(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
            Intrinsics.checkParameterIsNotNull(json, "json");
            Intrinsics.checkParameterIsNotNull(context, "context");
            ResourceLocation id = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"block"));
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(id);
            if (block == null) {
                throw (Throwable)new IllegalArgumentException("Can't find block " + id);
            }
            Intrinsics.checkExpressionValueIsNotNull(block, "ForgeRegistries.BLOCKS.g\u2026n(\"Can't find block $id\")");
            Block block2 = block;
            StatePropertiesPredicate properties2 = StatePropertiesPredicate.Companion.deserializeProperties(json.get("properties"));
            BlockStateContainer blockStateContainer = block2.func_176194_O();
            Intrinsics.checkExpressionValueIsNotNull(blockStateContainer, "block.blockState");
            properties2.forAbsent(blockStateContainer, (Function1<? super String, Unit>)new Function1<String, Unit>(block2){
                final /* synthetic */ Block $block;

                public final void invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull(it, "it");
                    throw (Throwable)new JsonSyntaxException("Block " + this.$block + " has no property " + it);
                }
                {
                    this.$block = block;
                    super(1);
                }
            });
            return new BlockStatePropertyCondition(block2, properties2, null);
        }

        public Serializer() {
            super(new ResourceLocation("block_state_property"), BlockStatePropertyCondition.class);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lnet/minecraft/world/loot/conditions/BlockStatePropertyCondition$Companion;", "", "()V", "init", "", "WitcheryResurrected"})
    public static final class Companion {
        @JvmStatic
        public final void init() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

