/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.events.priority;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.msrandom.events.EventHandler;
import net.msrandom.events.priority.CancellableEventArgs;
import net.msrandom.events.priority.Priority;

public class PriorityEventHandler<S, A extends CancellableEventArgs>
implements EventHandler<S, A> {
    private static final Priority[] PRIORITIES = Priority.values();
    private final Map<Priority, Set<BiConsumer<S, A>>> subscribers = new HashMap<Priority, Set<BiConsumer<S, A>>>();
    private final Map<BiConsumer<S, A>, Priority> reversePriority = new HashMap<BiConsumer<S, A>, Priority>();

    public void subscribe(BiConsumer<S, A> subscriber, Priority priority) {
        this.subscribers.computeIfAbsent(priority, k -> new HashSet()).add(subscriber);
        this.reversePriority.put(subscriber, priority);
    }

    @Override
    public void subscribe(BiConsumer<S, A> subscriber) {
        this.subscribe(subscriber, Priority.NORMAL);
    }

    @Override
    public void unsubscribe(BiConsumer<S, A> subscriber) {
        this.subscribers.get((Object)this.reversePriority.get(subscriber)).remove(subscriber);
        this.reversePriority.remove(subscriber);
    }

    @Override
    public void accept(S sender, A args2) {
        for (int i = PRIORITIES.length - 1; i >= 0; --i) {
            Priority priority = PRIORITIES[i];
            Set<BiConsumer<S, A>> prioritySubscribers = this.subscribers.get((Object)priority);
            if (prioritySubscribers == null || !PriorityEventHandler.acceptSubscribers(sender, args2, prioritySubscribers)) continue;
            return;
        }
    }

    private static <S, A extends CancellableEventArgs> boolean acceptSubscribers(S sender, A args2, Set<BiConsumer<S, A>> subscribers) {
        for (BiConsumer<S, A> subscriber : subscribers) {
            subscriber.accept(sender, args2);
            if (!args2.isCanceled()) continue;
            return true;
        }
        return false;
    }
}

