/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.asm;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.msrandom.witchery.WitcheryModContainer;
import net.msrandom.witchery.asm.EntityAgeableTransformer;
import net.msrandom.witchery.asm.EntityPlayerTransformer;
import net.msrandom.witchery.asm.InjectedModContainerTransformer;
import net.msrandom.witchery.asm.MinecraftClientTransformer;
import net.msrandom.witchery.asm.MinecraftServerTransformer;
import net.msrandom.witchery.asm.StructureStartTransformer;
import net.msrandom.witchery.asm.WitcheryClassTransformer;
import net.msrandom.witchery.asm.WorldServerTransformer;
import net.msrandom.witchery.asm.WorldTransformer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

@IFMLLoadingPlugin.MCVersion(value="1.12.2")
public class WitcheryLoadingPlugin
implements IFMLLoadingPlugin {
    private static File source;

    public String[] getASMTransformerClass() {
        return new String[]{Transformer.class.getName()};
    }

    public String getModContainerClass() {
        return WitcheryModContainer.class.getName();
    }

    @Nullable
    public String getSetupClass() {
        return null;
    }

    public static File getSource() {
        return source;
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public void injectData(Map<String, Object> data2) {
        source = (File)data2.get("coremodLocation");
    }

    public static class Transformer
    implements IClassTransformer {
        public static final Logger LOGGER = LogManager.getLogger((String)WitcheryLoadingPlugin.class.getSimpleName());
        public static final String PACKAGE = "net/msrandom/witchery/";
        private final Map<String, WitcheryClassTransformer> transformers = new HashMap<String, WitcheryClassTransformer>();

        public Transformer() {
            this.transformers.put("net.minecraft.entity.EntityAgeable", new EntityAgeableTransformer());
            this.transformers.put("net.minecraft.entity.player.EntityPlayer", new EntityPlayerTransformer());
            this.transformers.put("net.minecraftforge.fml.common.InjectedModContainer", new InjectedModContainerTransformer());
            this.transformers.put("net.minecraft.client.Minecraft", new MinecraftClientTransformer());
            this.transformers.put("net.minecraft.server.MinecraftServer", new MinecraftServerTransformer());
            this.transformers.put("net.minecraft.world.WorldServer", new WorldServerTransformer());
            this.transformers.put("net.minecraft.world.gen.structure.StructureStart", new StructureStartTransformer());
            this.transformers.put("net.minecraft.world.World", new WorldTransformer());
        }

        public byte[] transform(String name2, String transformedName, byte[] basicClass) {
            WitcheryClassTransformer transformer = this.transformers.get(transformedName);
            if (transformer != null) {
                ClassNode node = new ClassNode();
                ClassReader reader = new ClassReader(basicClass);
                reader.accept((ClassVisitor)node, 0);
                ClassWriter writer = new ClassWriter(reader, transformer.transform(name2.replace(".", "/"), node));
                node.accept((ClassVisitor)writer);
                return writer.toByteArray();
            }
            return basicClass;
        }
    }
}

