/*
 * Decompiled with CFR 0.152.
 */
package net.msrandom.witchery.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.msrandom.witchery.init.WitcheryBlocks;
import net.msrandom.witchery.init.WitcheryTileEntities;
import net.msrandom.witchery.init.items.WitcheryGeneralItems;
import net.msrandom.witchery.init.items.WitcheryIngredientItems;
import net.msrandom.witchery.network.PacketParticles;
import net.msrandom.witchery.network.WitcheryNetworkChannel;
import org.jetbrains.annotations.Nullable;

public class BlockAlluringSkull
extends BlockContainer {
    public static final PropertyBool ON = PropertyBool.func_177716_a((String)"on");
    private static final PropertyDirection FACING = BlockDirectional.field_176387_N;
    private static final AxisAlignedBB DEFAULT_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.5, 0.75, 0.75, 1.0);
    private static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.25, 0.25, 0.0, 0.75, 0.75, 0.5);
    private static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.5, 0.25, 0.25, 1.0, 0.75, 0.75);
    private static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.25, 0.25, 0.5, 0.75, 0.75);

    public BlockAlluringSkull() {
        super(Material.field_151594_q);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(false)));
        this.func_149715_a(0.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149722_s();
        this.func_149752_b(1000.0f);
        this.func_149647_a(WitcheryGeneralItems.TAB);
    }

    public static void allure(World world, BlockPos pos, int quad) {
        AxisAlignedBB bounds;
        double posX = pos.func_177958_n();
        double posY = pos.func_177956_o();
        double posZ = pos.func_177952_p();
        float r = 64.0f;
        float dy = 10.0f;
        switch (quad) {
            case 0: {
                bounds = new AxisAlignedBB(posX, posY - (double)dy, posZ - (double)r, posX + (double)r, posY, posZ);
                break;
            }
            case 1: {
                bounds = new AxisAlignedBB(posX - (double)r, posY - (double)dy, posZ - (double)r, posX, posY, posZ);
                break;
            }
            case 2: {
                bounds = new AxisAlignedBB(posX, posY - (double)dy, posZ, posX + (double)r, posY, posZ + (double)r);
                break;
            }
            case 3: {
                bounds = new AxisAlignedBB(posX - (double)r, posY - (double)dy, posZ, posX, posY, posZ + (double)r);
                break;
            }
            case 4: {
                bounds = new AxisAlignedBB(posX - (double)r, posY + 1.0, posZ - (double)r, posX, posY + (double)dy, posZ);
                break;
            }
            case 5: {
                bounds = new AxisAlignedBB(posX, posY + 1.0, posZ, posX + (double)r, posY + (double)dy, posZ + (double)r);
                break;
            }
            case 6: {
                bounds = new AxisAlignedBB(posX - (double)r, posY + 1.0, posZ, posX, posY + (double)dy, posZ + (double)r);
                break;
            }
            default: {
                bounds = new AxisAlignedBB(posX, posY + 1.0, posZ - (double)r, posX + (double)r, posY + (double)dy, posZ);
            }
        }
        for (EntityCreature creature2 : world.func_72872_a(EntityCreature.class, bounds)) {
            Path path;
            if (creature2.func_70668_bt() != EnumCreatureAttribute.UNDEAD || creature2.func_70661_as().func_75492_a(posX, posY, posZ, 1.0) || (path = creature2.func_70661_as().func_75494_a((Entity)creature2)) == null) continue;
            creature2.func_70661_as().func_75484_a(path, (double)creature2.func_70689_ay());
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack itemstack;
        if (!world.field_72995_K && !(itemstack = player.func_184586_b(hand)).func_190926_b() && itemstack.func_77973_b() == WitcheryIngredientItems.NECRO_STONE) {
            if (!((Boolean)state.func_177229_b((IProperty)ON)).booleanValue()) {
                world.func_184148_a(null, 0.5 + (double)pos.func_177958_n(), 0.3 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), SoundEvents.field_187860_ff, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.func_177958_n(), 0.3 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 0.5f, 0.5f, EnumParticleTypes.FLAME), world, 0.5 + (double)pos.func_177958_n(), 0.3 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p());
                world.func_175656_a(pos, state.func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf(true)));
            } else {
                world.func_184148_a(null, 0.5 + (double)pos.func_177958_n(), 0.3 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), SoundEvents.field_187862_fg, player.func_184176_by(), 0.5f, 0.4f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                WitcheryNetworkChannel.sendToAllAround(new PacketParticles(0.5 + (double)pos.func_177958_n(), 0.3 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), 0.5f, 0.5f, EnumParticleTypes.EXPLOSION_NORMAL), world, 0.5 + (double)pos.func_177958_n(), 0.3 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p());
                world.func_175698_g(pos);
                world.func_72838_d((Entity)new EntityItem(world, 0.5 + (double)pos.func_177958_n(), 0.8 + (double)pos.func_177956_o(), 0.5 + (double)pos.func_177952_p(), new ItemStack((Block)WitcheryBlocks.ALLURING_SKULL)));
            }
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, facing, hitX, hitY, hitZ);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            default: {
                return DEFAULT_AABB;
            }
            case NORTH: {
                return NORTH_AABB;
            }
            case SOUTH: {
                return SOUTH_AABB;
            }
            case WEST: {
                return WEST_AABB;
            }
            case EAST: 
        }
        return EAST_AABB;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)ON) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7))).func_177226_a((IProperty)ON, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING, ON}).build();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return WitcheryTileEntities.ALLURING_SKULL.create();
    }
}

